﻿function FileFormatCustomJson() {
    let formSerializeArr = $('#PBXEditConfigurationFrom').serializeArray();

    var jsonObj = {};
    jsonObj['Fields'] = [];

    jQuery.map(formSerializeArr, function (n, i) {
        if (n.name !== '__RequestVerificationToken' && jsonObj[n.name] === undefined) {
            if (n.name.includes('fff_')) {//for fields
                let field = {};
                let e = $('#' + n.name);

                field['Name'] = $(e).data('fieldname');
                field['StartPos'] = $(e).data('start');
                field['Length'] = $(e).data('lenght');
                field['ParseFormat'] = $(e).data('format');
                field['DataType'] = $(e).data('type');
                field['FieldMask'] = $(e).data('validation');
                field['Description'] = $(e).data('description');
                field['IsEnabled'] = $(e).data('enabled') === "True";
                field['IsOptional'] = $(e).data('optional') === "True";
                field['IsTrimSpaces'] = $(e).data('trim') === "True";

                jsonObj['Fields'].push(field);
            }
            else//for other
                jsonObj[n.name] = n.value;
        }
    });

    return jsonObj;
}

$(document).ready(() => {
    let selectedFieldName = null;
    let isEdit = false;

    function SetDontProc() {
        if ($('#DontProc').prop('checked')) {
            $('#DontProcExtension').removeClass('disDiv');
        }
        else {
            $('#DontProcExtension').addClass('disDiv');
        }
    }

    function UpdateButtonsFileFormat() {
        if (selectedFieldName === null) {
            $("#btnEdit-History").attr("disabled", true);
            $("#btnDelete-History").attr("disabled", true);
        }
        else {
            $("#btnEdit-History").attr("disabled", false);
            $("#btnDelete-History").attr("disabled", false);
        }
    }

    function AttachEventToTableWithFileFormatfields() {
        selectedFieldName = null;

        $('#tariscope-fileformatfields tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedFieldName = null;
            }
            else {
                selectedFieldName = $(this).find('td[data-name="Name"]').text();
                $('#tariscope-fileformatfields tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtonsFileFormat();
        });
        UpdateButtonsFileFormat();
    }

    function SetEnabledFields() {
        if ($('#fffEnabled').prop('checked')) {
            $('#enabledFFfieldsSection').removeClass('disDiv');
        }
        else {
            $('#enabledFFfieldsSection').addClass('disDiv');
        }
    }

    function RefreshSample() {
        var formData = new FormData();
        formData.append('model', JSON.stringify(FileFormatCustomJson()));

        $.ajax({
            type: "POST",
            url: '/Devices/FileformatSample',
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#exmapleTable').load('/Devices/GetFileformatSample');
                }
            }
        });
    }

    function SortTableRows(row1, row2) {
        var v1, v2, r;
        v1 = $(row1).find("td:eq(4)").text();
        v2 = $(row2).find("td:eq(4)").text();

        if (v1 < v2) {
            r = $('#lblYes').val() === 'Да' ? -1 : 1;
        } else if (v1 > v2) {
            r = $('#lblYes').val() === 'Да' ? 1 : -1;
        } else {
            r = 0;
        }

        if (r === 0) {
            // we have a tie in column 1 values, compare column 2 instead
            v1 = $(row1).find("td:eq(1)").text();
            v2 = $(row2).find("td:eq(1)").text();
            r = v1 - v2;
        }
        return r;
    }

    //update dont proc field
    $('#DontProc').change(SetDontProc);

    //hide table with file
    $('#fsHideFile').on('click', () => {
        $('#fsHideFile').hide();
        $('#fsHShowFile').show();
        $('#examleTablesection').slideUp('fast');
    });

    //show table with file
    $('#fsHShowFile').on('click', () => {
        $('#fsHideFile').show();
        $('#fsHShowFile').hide();
        $('#examleTablesection').slideDown('fast');
    });

    //hide fields
    $('#fsHideFields').on('click', () => {
        $('#fsHideFields').hide();
        $('#fsShowFields').show();
        $('#fieldsTableSection').slideUp('fast');
    });

    //show fields
    $('#fsShowFields').on('click', () => {
        $('#fsHideFields').show();
        $('#fsShowFields').hide();
        $('#fieldsTableSection').slideDown('fast');
    });

    //show modal for add a new field
    $('#btnAdd-History').on('click', () => {
        $('#fieldsTableSection').slideUp('fast');
        $('#fsHideFields').addClass('disDiv');
        isEdit = false;

        $('#fffName').val('');

        $('#fffEnabled').prop('checked', true);
        $('#fffOptional').prop('checked', true);
        $('#fffTrim').prop('checked', false);
        SetEnabledFields();

        $('#fffStart').val('0');
        $('#fffLenght').val('0');

        $('#fffFormat').val('');
        $('#fffDescription').val('');

        $('#fffValid').val('');
        $('#fffTypes').val('18');

        $('#btnConfirmAddField').prop('disabled', true);
        $('#btnConfirmAddField').unbind();

        $('#emptyfffName').hide();
        $('#existfffName').hide();

        //confirm add a new field
        $('#btnConfirmAddField').on('click', () => {
            let name = $('#fffName').val().replace(' ', '_');

            //add field
            $('#realFFFields').append('<input id="fff_' + name + '" data-label="FFFields"' +
                ' data-fieldname="' + name + '"' +
                ' data-start="' + $('#fffStart').val() + '"' +
                ' data-lenght="' + $('#fffLenght').val() + '"' +
                ' data-format="' + $('#fffFormat').val() + '"' +
                ' data-type="' + $('#fffTypes').val() + '"' +
                ' data-validation="' + $('#fffValid').val() + '"' +
                ' data-description="' + $('#fffDescription').val() + '"' +
                ' data-enabled="' + ($('#fffEnabled').prop('checked') ? "True" : "False") + '"' +
                ' data-optional="' + ($('#fffOptional').prop('checked') ? "True" : "False") + '"' +
                ' data-trim="' + ($('#fffTrim').prop('checked') ? "True" : "False") + '"' +
                ' name="fff_' + name + '"' +
                ' value="1" />');

            //add a table row
            $('#bodyFFfieldsSection').append('<tr class="' + ($('#fffOptional').prop('checked') ? "" : "requiredField") + '">' +
                ' <td data-name="Name" style="padding-left: 10px !important;">' + name + '</td>' +
                ' <td data-name="StartPos">' + $('#fffStart').val() + '</td>' +
                ' <td data-name="Length">' + $('#fffLenght').val() + '</td>' +
                ' <td data-name="EndPos">' + ($('#fffStart').val() * 1 + $('#fffLenght').val() * 1) + '</td>' +
                ' <td data-name="IsEnabled" style="padding-right: 10px !important;">' + ($('#fffEnabled').prop('checked') ? $('#lblYes').val() : $('#lblNo').val()) + '</td></tr>');

            //sort fileds
            var rows = $("#bodyFFfieldsSection tr").detach().get();
            rows.sort(SortTableRows);
            $("#bodyFFfieldsSection").append(rows);


            $('#btnCloseAddField').click();
        });

        $('#addFieldSection').slideDown('fast');
    });

    //show modal for edit field
    $('#btnEdit-History').on('click', () => {
        $('#fieldsTableSection').slideUp('fast');
        $('#fsHideFields').addClass('disDiv');
        isEdit = true;

        let e = $('#fff_' + selectedFieldName);

        $('#fffName').val($(e).data('fieldname'));

        $('#fffEnabled').prop('checked', $(e).data('enabled') === "True");
        $('#fffOptional').prop('checked', (e).data('optional') === "True");
        $('#fffTrim').prop('checked', $(e).data('trim') === "True");
        SetEnabledFields();

        $('#fffStart').val($(e).data('start'));
        $('#fffLenght').val($(e).data('lenght'));

        $('#fffFormat').val($(e).data('format'));
        $('#fffDescription').val($(e).data('description'));

        $('#fffValid').val($(e).data('validation'));
        $('#fffTypes').val($(e).data('type'));

        $('#btnConfirmAddField').prop('disabled', false);
        $('#btnConfirmAddField').unbind();

        $('#emptyfffName').hide();
        $('#existfffName').hide();

        //confirm add a new field
        $('#btnConfirmAddField').on('click', () => {
            //remove old field and the table row
            $('#fff_' + selectedFieldName).remove();
            $('#bodyFFfieldsSection tr td').filter(function () { return $(this).text() === selectedFieldName; }).closest("tr").remove();

            let name = $('#fffName').val().replace(' ', '_');

            //add field
            $('#realFFFields').append('<input id="fff_' + name + '" data-label="FFFields"' +
                ' data-fieldname="' + name + '"' +
                ' data-start="' + $('#fffStart').val() + '"' +
                ' data-lenght="' + $('#fffLenght').val() + '"' +
                ' data-format="' + $('#fffFormat').val() + '"' +
                ' data-type="' + $('#fffTypes').val() + '"' +
                ' data-validation="' + $('#fffValid').val() + '"' +
                ' data-description="' + $('#fffDescription').val() + '"' +
                ' data-enabled="' + ($('#fffEnabled').prop('checked') ? "True" : "False") + '"' +
                ' data-optional="' + ($('#fffOptional').prop('checked') ? "True" : "False") + '"' +
                ' data-trim="' + ($('#fffTrim').prop('checked') ? "True" : "False") + '"' +
                ' name="fff_' + name + '"' +
                ' value="1" />');

            //add a table row
            $('#bodyFFfieldsSection').append('<tr class="' + ($('#fffOptional').prop('checked') ? "" : "requiredField") + '">' +
                ' <td data-name="Name" style="padding-left: 10px !important;">' + name + '</td>' +
                ' <td data-name="StartPos">' + $('#fffStart').val() + '</td>' +
                ' <td data-name="Length">' + $('#fffLenght').val() + '</td>' +
                ' <td data-name="EndPos">' + ($('#fffStart').val() * 1 + $('#fffLenght').val() * 1) + '</td>' +
                ' <td data-name="IsEnabled" style="padding-right: 10px !important;">' + ($('#fffEnabled').prop('checked') ? $('#lblYes').val() : $('#lblNo').val()) + '</td></tr>');


            //sort fileds
            var rows = $("#bodyFFfieldsSection tr").detach().get();
            rows.sort(SortTableRows);
            $("#bodyFFfieldsSection").append(rows);


            UpdateButtonsFileFormat();
            $('#btnCloseAddField').click();
        });

        $('#addFieldSection').slideDown('fast');
    });

    //show error when name of field is empty or already exists
    $('#fffName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {//empty name
            $('#emptyfffName').slideDown('fast');
            $('#existfffName').slideUp('fast');
            $('#btnConfirmAddField').prop('disabled', true);
        }
        else {
            $('#emptyfffName').slideUp('fast');

            if (isEdit) {
                if ($(this).val() !== selectedFieldName && $('#fff_' + $(this).val()).length > 0) {//name exists
                    $('#existfffName').slideDown('fast');
                    $('#btnConfirmAddField').prop('disabled', true);
                }
                else {//name free
                    $('#existfffName').slideUp('fast');
                    $('#btnConfirmAddField').prop('disabled', false);
                }
            }
            else {
                if ($('#fff_' + $(this).val()).length > 0) {//name exists
                    $('#existfffName').slideDown('fast');
                    $('#btnConfirmAddField').prop('disabled', true);
                }
                else {//name free
                    $('#existfffName').slideUp('fast');
                    $('#btnConfirmAddField').prop('disabled', false);
                }
            }
        }
    });

    //set enable/disable ff fiedls
    $('#fffEnabled').change(SetEnabledFields);

    //close add/edit field (cancel)
    $('#btnCloseAddField').on('click', () => {
        $('#fieldsTableSection').slideDown('fast');
        $('#fsHideFields').removeClass('disDiv');
        $('#addFieldSection').slideUp('fast');
    });

    //show modal for delete field
    $('#btnDelete-History').on('click', () => {
        $('#fieldsTableSection').slideUp('fast');
        $('#fsHideFields').addClass('disDiv');
        $('#deleteFieldSection').slideDown('fast');
    });

    //close delete field (cancel)
    $('#btnCloseDeleteField').on('click', () => {
        $('#fieldsTableSection').slideDown('fast');
        $('#fsHideFields').removeClass('disDiv');
        $('#deleteFieldSection').slideUp('fast');
    });

    //confirm delete field
    $('#btnConfirmDeleteField').on('click', () => {

        $('#fff_' + selectedFieldName).remove();
        $('tr[class*="selected"]').remove();

        selectedFieldName = null;
        UpdateButtonsFileFormat();

        $('#btnCloseDeleteField').click();
    });

    //open dialog for select file
    $('#fsUploadTestFile').on('click', () => { $('#FileInput').click(); });

    //uploading file into server
    $("#FileInput").change(function () {

        var formData = new FormData();
        Array.from(document.getElementById("FileInput").files).forEach(e => {
            formData.append(e.name, e);
        });

        $.ajax({
            type: 'POST',
            async: true,
            url: '/Devices/Upload/',
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            success: function (response) {
                if (response.success == true) {
                    $('#fsRefreshSample').removeClass('disDiv');
                    RefreshSample();
                }
            }
        });
    });

    //refresh sample table
    $('#fsRefreshSample').on('click', RefreshSample);

    AttachEventToTableWithFileFormatfields();
    SetDontProc();
});