﻿$(document).ready(() => {
    let selectedRow = null;
    let headSource = false;

    function ExpandLeftMenu() {
        try {
            if (NodeIsLoaded) {
                ShowNodes('NewNodesMenu');
                ShowNodeEntry($('#nodeID').val() + '');
                ShowDevices('CNode_' + $('#nodeID').val() + '');
                ShowDeviceContent('CNode_' + $('#nodeID').val() + 'CSelectedDevice_' + $('#deviceID').val());
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }
    }

    function UpdateButtons() {
        if (selectedRow === null) {
            $("#btnAdd").attr("disabled", true);
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
            $("#btnEditTariff").attr("disabled", true);
            $("#btnEditRestr").attr("disabled", true);
            $("#btnEditNetwork").attr("disabled", true);
        }
        else {
            $("#btnAdd").attr("disabled", headSource === 2 || headSource === 3);
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", headSource < 0);
            $("#btnEditTariff").attr("disabled", false);
            $("#btnEditRestr").attr("disabled", false);
            $("#btnEditNetwork").attr("disabled", false);
        }
    }

    function AttachEventsToTable() {
        selectedRow = null;

        var header = document.getElementById("routesHead");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        $('#tariscope-rg tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedRow = null;
                headSource = null;
            }
            else {
                selectedRow = $(this).find('td[data-name="ID"]').text();
                headSource = $(this).data('t');
                $('#tariscope-rg tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtons();
        });

        UpdateButtons();
    }

    function Load() {
        $('#rgTable').load('/Devices/RoutesGateways/Load/' + $('#deviceID').val(), AttachEventsToTable);
    }

    //show modal for delete element
    $('#btnDelete').on('click', () => { $('#deleteRoutemodal').modal('show'); });

    //confimr delete element
    $('#confirmDeleteElement').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Devices/RoutesGateways/Delete/' + selectedRow,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#deleteRoutemodal').modal('hide');
                    let row = $('tr > td[data-name="ID"]:contains("' + selectedRow + '")').parent();
                    row.treegrid('collapse');
                    row.remove();
                    selectedRow = null;
                    UpdateButtons();
                }
            }
        });
    });

    //show modal for detect reoutes
    $('#btnDetect').on('click', () => { $('#detectRoutesmopdal').modal('show'); });

    //confimr find routes and gateways
    $('#autoDetectBtn').on('click', () => {
        $('#detectRoutesmopdal').modal('hide');
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/Devices/RoutesGateways/Search/' + $('#deviceID').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    Load();
                    ShowSpinner(false);
                }
            }
        });
    });

    //show moda for add a new rout
    $('#btnAdd').on('click', () => {
        $('#editGeneralTitle').text($('#addTitle').val());
        $('#confirmSaveGeneral').unbind();

        let url = '';

        switch (headSource) {
            case -1:
                $('#RoutTitle').show();
                $('#TrunkTitle').hide();
                $('#GatewayTitle').hide();
                $('#routeRoute').prop('type', 'number');
                url = '/Devices/RoutesGateways/Route/Add/';
                break;
            case -2:
                $('#RoutTitle').hide();
                $('#TrunkTitle').hide();
                $('#GatewayTitle').show();
                $('#routeRoute').prop('type', 'text');
                url = '/Devices/RoutesGateways/Gateway/Add/';
                break;
            case 1:
                $('#RoutTitle').hide();
                $('#TrunkTitle').show();
                $('#GatewayTitle').hide();
                $('#routeRoute').prop('type', 'number');
                url = '/Devices/RoutesGateways/Trunk/Add/' + selectedRow + '/';
                break;
        }

        $('#routeRoute').val('');
        $('#routeDescription').val('');
        $('#routeRoute').prop('disabled', false);
        $('#routeAccessCode').val('');

        $('#routeProvider1').val($('option:first', $('#routeProvider1')).val());
        $('#routeProvider2').val($('option:first', $('#routeProvider2')).val());

        $('#emptyRout').hide();
        $('#confirmSaveGeneral').prop('disabled', true);

        //save rout
        $('#confirmSaveGeneral').on('click', () => {
            $.ajax({
                type: "POST",
                url: url + $('#deviceID').val()
                    + '/' + $('#routeProvider1').val()
                    + '/' + $('#routeProvider2').val()
                    + '/?Route=' + encodeURIComponent($('#routeRoute').val())
                    + '&AccessCode=' + encodeURIComponent($('#routeAccessCode').val())
                    + '&Description=' + encodeURIComponent($('#routeDescription').val()),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#editGeneralRoutesmodal').modal('hide');
                        Load();
                    }
                }
            });
        });

        $('#editGeneralRoutesmodal').modal('show');
    });

    //show error when empty rout
    $('#routeRoute').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyRout').slideDown('fast');
            $('#confirmSaveGeneral').prop('disabled', true);
        }
        else {
            $('#emptyRout').slideUp('fast');
            $('#confirmSaveGeneral').prop('disabled', false);
        }
    });

    //show modal for edit rout
    $('#btnEdit').on('click', () => {
        $('#editGeneralTitle').text($('#editTitle').val());
        $('#confirmSaveGeneral').unbind();
        $('#emptyRout').hide();
        $('#confirmSaveGeneral').prop('disabled', false);
        $('#routeRoute').val('');
        $('#routeRoute').prop('disabled', headSource < 0);

        $.ajax({
            type: "POST",
            url: '/Devices/RoutesGateways/Get/' + selectedRow,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#routeDescription').val(response.r.Name);
                    $('#routeAccessCode').val(response.r.AccessCode);

                    $('#routeProvider1').val(response.r.CallProviderID);
                    $('#routeProvider2').val(response.r.CallProviderID2);

                    switch (headSource) {
                        case -1:
                            $('#RoutTitle').show();
                            $('#TrunkTitle').hide();
                            $('#GatewayTitle').hide();
                            $('#routeRoute').prop('type', 'number');
                            break;
                        case -2:
                            $('#RoutTitle').hide();
                            $('#TrunkTitle').hide();
                            $('#GatewayTitle').show();
                            $('#routeRoute').prop('type', 'text');
                            break;
                        case 1:
                            $('#RoutTitle').show();
                            $('#TrunkTitle').hide();
                            $('#GatewayTitle').hide();
                            $('#routeRoute').prop('type', 'number');
                            $('#routeRoute').val(response.r.Route);
                            break;
                        case 2:
                            $('#RoutTitle').hide();
                            $('#TrunkTitle').show();
                            $('#GatewayTitle').hide();
                            $('#routeRoute').prop('type', 'number');
                            $('#routeRoute').val(response.r.Trunk);
                            break;
                        case 3:
                            $('#RoutTitle').hide();
                            $('#TrunkTitle').hide();
                            $('#GatewayTitle').show();
                            $('#routeRoute').prop('type', 'text');
                            $('#routeRoute').val(response.r.Gateway);
                            break;
                    }

                    //save rout
                    $('#confirmSaveGeneral').on('click', () => {
                        $.ajax({
                            type: "POST",
                            url: '/Devices/RoutesGateways/Edit/' + selectedRow
                                + '/' + $('#routeProvider1').val()
                                + '/' + $('#routeProvider2').val()
                                + '/?Route=' + encodeURIComponent($('#routeRoute').val())
                                + '&AccessCode=' + encodeURIComponent($('#routeAccessCode').val())
                                + '&Description=' + encodeURIComponent($('#routeDescription').val()),
                            traditional: true,
                            success: function (response) {
                                if (response !== null && response.success === true) {
                                    $('#editGeneralRoutesmodal').modal('hide');
                                    Load();
                                }
                            }
                        });
                    });

                    $('#editGeneralRoutesmodal').modal('show');
                }
            }
        });
    });

    //show modal for edit transit calls tarification
    $('#btnEditTariff').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Devices/RoutesGateways/Get/' + selectedRow,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#routeVirtualAbonent').val(response.r.AbonentID);
                    $('#routeExternalAccessCode').val(response.r.RemoteCode);
                    $('#isExternal').prop('checked', response.r.IsRemoteCabinet);

                    $('#routeTariffmodal').modal('show');
                }
            }
        });
    });

    //save tarification
    $('#confirmSaveTariff').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Devices/RoutesGateways/SaveTariffication/' + selectedRow
                + '/' + $('#routeVirtualAbonent').val()
                + '/?IsRemoute=' + $('#isExternal').prop('checked')
                + '&Code=' + encodeURIComponent($('#routeExternalAccessCode').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#routeTariffmodal').modal('hide');
                    Load();
                }
            }
        });
    });

    //show modal for edit restricitons
    $('#btnEditRestr').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Devices/RoutesGateways/Get/' + selectedRow,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#routeCredit').val(response.r.Credit);
                    $('#routeDebit').val(response.r.Debit);
                    $('#routeStatus').val(response.r.RestrictStatus === 0 ? $('#noRestrictTitle').val() : $('#RestrictTitle').val());
                    $('#routeRestrType').val(response.r.CreditType);
                    $('#routeDeviceID').val(response.r.HardwareID);

                    $('#routeRestrmodal').modal('show');
                }
            }
        });
    });

    //confirm save restriciton settings
    $('#confirmSaveRestr').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Devices/RoutesGateways/SaveRestriciton/' + selectedRow
                + '/' + $('#routeRestrType').val() + '/' + $('#routeCredit').val()
                + '/?Hardware=' + $('#routeDeviceID').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#routeRestrmodal').modal('hide');
                    Load();
                }
            }
        });
    });

    //show modal to edit network
    $('#btnEditNetwork').on('click', () => {

        $.ajax({
            type: "POST",
            url: '/Devices/RoutesGateways/Get/' + selectedRow,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#abcLinkedPBX').val(response.r.LinkedPBXID ? response.r.LinkedPBXID : 0);
                    $('#adcCallType').val(response.r.CallType);

                    $('#editNetworkRoutesmodal').modal('show');
                }
            }
        });
    });

    //save changed for network
    $('#confirmSaveNetwork').on('click', () => {
        $.ajax({
            type: "POST",
            url: `/Devices/RoutesGateways/SaveNetwork/${selectedRow}/${$('#abcLinkedPBX').val()}/${$('#adcCallType').val()}`,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#editNetworkRoutesmodal').modal('hide');
                    Load();
                }
            }
        });
    });

    //update call type
    $('#abcLinkedPBX').change(() => {
        let val = $('#abcLinkedPBX').val() * 1;
        $('#adcCallType').val(val > 0 ? '12' : '-1');
    });

    Load();
    ExpandLeftMenu();
});