﻿function SendConfiguration(btnClicked, Json = null) {
    $('#submitButton').prop('disabled', true);

    var $form = $(btnClicked).parents('form');

    var formData = new FormData();
    formData.append('model', JSON.stringify(Json !== null ? Json : jQFormSerializeArrToJson($form.serializeArray())));

    $.ajax({
        type: "POST",
        url: $form.attr('action') + '/?Name=' + $('#DataSourceType').val(),
        data: formData,
        datatype: 'application/octet-stream',
        contentType: false,
        processData: false,
        traditional: true,
        success: function (response) {
            if (response !== null) {
                $('#DataSourceConfiguration').val(response.xml);
                try {
                    $('#submitButton').prop('disabled', false);
                    $('#savedConfig').slideDown('fast');
                    setTimeout(() => { $('#savedConfig').slideUp('fast'); }, 3500);
                } catch { }
            }
        }
    });
}

function jQFormSerializeArrToJson(formSerializeArr) {
    var jsonObj = {};
    var list = {};

    jQuery.map(formSerializeArr, function (n, i) {
        if (n.name !== '__RequestVerificationToken' && jsonObj[n.name] === undefined) {
            if (n.name.includes('[') && n.name.includes(']')) {//for lists

                let name = n.name.substring(0, n.name.indexOf('['));
                if (list[name] === undefined)
                    list[name] = [];

                list[name].push(n.value);

            }
            else//for other
                jsonObj[n.name] = n.value;
        }
    });

    //load lists to json
    for (key in list) {
        jsonObj[key] = list[key];
    }

    return jsonObj;
}