﻿let showBtn = false;
let currentTab = 1;

function ClickTab(num) {
    if (num == 5 && showBtn) {
        $('#CheckConnection').show();
    }
    else {
        $('#CheckConnection').hide();
    }

    currentTab = num;
}

$(document).ready(() => {
    function InitADView() {
        if ($('#Authentication').val() == 'AD') {
            $('#ADSettingsSection').slideDown('fast');
            showBtn = true;
        }
        else {
            $('#ADSettingsSection').slideUp('fast');
            showBtn = false;
        }

        ClickTab(currentTab);
    }

    function InitChangeSections() {
        if ($('#EnablePayments').prop('checked')) {
            $('#PaymentsSection').slideDown('fast');

            if ($('#MainPaymentMethod').val() == 'LiqPay') {
                $('#PayPalSection').slideUp('fast');
                $('#LiqPaySection').slideDown('fast');
            }
            else {
                $('#LiqPaySection').slideUp('fast');
                $('#PayPalSection').slideDown('fast');
            }
        }
        else {
            $('#PaymentsSection').slideUp('fast');
        }
    }

    function InitSchemeView() {
        $('.plans-scheme-container').hide();
        $(`#plans-scheme-container-${$('#PlansSchemeSelector').val()}`).show();
    }

    //chnage auth type
    $('#Authentication').change(InitADView);

    //сhange payment method
    $('#MainPaymentMethod').change(InitChangeSections);

    //enable/disable payments
    $('#EnablePayments').change(InitChangeSections);

    //check connection
    $('#CheckConnection').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/PersonalArea/Settings/CheckConnection/?Domain=' + encodeURIComponent($('#ADDomain').val()) + '&Admin=' + encodeURIComponent($('#ADAdmin').val()) + '&Password=' + encodeURIComponent($('#ADPassword').val()),
            traditional: true,
            success: function (response) {
                ShowSpinner(false);
                if (response !== null && response.success === true) {
                    $('#ADConnectionSuccess').modal('show');
                }
                else {
                    $('#ADConnectionErrorMsg').text(response.msg);
                    $('#ADConnectionError').modal('show');
                }
            }
        });
    });

    //update scheme view
    $('#PlansSchemeSelector').change(InitSchemeView);

    //updated the checker state (plans scheme)
    $('.plans-scheme-checker').change(function () {
        let dic = {};

        $("#PlansSchemeSelector option").each(function () {
            let id = $(this).val();
            dic[id] = [];
            $(`[data-parent=${$(this).val()}]:checked`).each(function () {
                dic[id].push($(this).data('plan'));
            });
        });

        $('#RatePlanSchemeJSON').val(JSON.stringify(dic));
    });

    //init select2
    setTimeout(() => { $('#AllowedCategories').select2({ theme: "bootstrap", placeholder: $('#AllowedCategoriesPlaceholder').val() }); }, 750);

    //show alert about saving
    if ($('#AlertUpdated').length > 0)
        setTimeout(() => { $('#AlertUpdated').remove() }, 3500);

    InitADView();
    InitChangeSections();
    InitSchemeView();
});