﻿$(document).ready(() => {
    function ExpandLeftMenu() {
        try {
            if (NodeIsLoaded) {
                ShowNodes('NewNodesMenu');
                ShowNodeEntry($('#nodeID').val() + '');
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }

    }

    function MakeDisable(num) {
        //disable nex steps if prev was proccesed again
        for (var i = num; i < 8; i++) {
            var elem = $('a[aria-controls="step' + (i + 2) + '"]');
            elem.parent().addClass('disabled');
        }
    }

    function nextTab(elem) {
        //go to next wizard page
        $(elem).next().find('a[data-toggle="tab"]').click();
    }

    function prevTab(elem) {
        //go to prev wizard page
        $(elem).prev().find('a[data-toggle="tab"]').click();
    }

    function ClearTableAndSelect() {
        //remove prev added data to table and selectes
        $("#tableWithData tr").remove();
        $("#tableWithData tbody").append('<tr></tr>');

        $('#selectExtension option').remove();
        $('#selectExtensionDescription option').remove();
        $('#selectLastName option').remove();
        $('#selectFirstName option').remove();
        $('#selectSecondName option').remove();
        $('#selectFullName option').remove();
        $('#selectDepartment option').remove();
        $('#selectExtension2 option').remove();
        $('#selectExtension3 option').remove();
        $('#selectLegal option').remove();
        $('#selectAuxiliaryID option').remove();
        $('#selectTType option').remove();
        $('#selectEquipmentName option').remove();
        $('#selectDescription option').remove();
        $('#selectInformation option').remove();
        $('#selectFirm option').remove();
        $('#selectCode option').remove();
        $('#selectPCode option').remove();
        $('#selectTCode option').remove();
        $('#selectBankA option').remove();
        $('#selectBankC option').remove();
        $('#selectContractID option').remove();
        $('#selectContractDate option').remove();
        $('#selectPrivileges option').remove();
        $('#selectCDate option').remove();
        $('#selectDDate option').remove();
        $('#selectCity option').remove();
        $('#selectArea option').remove();
        $('#selectStreet option').remove();
        $('#selectHouse option').remove();
        $('#selectFlat option').remove();
        $('#selectZCode option').remove();
        $('#selectEmail option').remove();
        $('#selectACode option').remove();
        $('#selectBalance option').remove();
        $('#selectRate option').remove();
        $('#selectPassword option').remove();
        $('#selectCredit option').remove();
        $('#selectAccID option').remove();
    }

    function SelectedMatch(data) {
        //select matched fields
        $('#selectExtension').val(data[0]);
        $('#selectExtensionDescription').val(data[1]);
        $('#selectLastName').val(data[2]);
        $('#selectFirstName').val(data[3]);
        $('#selectSecondName').val(data[4]);
        $('#selectFullName').val(data[5]);
        $('#selectDepartment').val(data[6]);
        $('#selectExtension2').val(data[7]);
        $('#selectExtension3').val(data[8]);
        $('#selectLegal').val(data[9]);
        $('#selectAuxiliaryID').val(data[10]);
        $('#selectTType').val(data[11]);
        $('#selectEquipmentName').val(data[12]);
        $('#selectDescription').val(data[13]);
        $('#selectInformation').val(data[14]);
        $('#selectFirm').val(data[15]);
        $('#selectCode').val(data[16]);
        $('#selectPCode').val(data[17]);
        $('#selectTCode').val(data[18]);
        $('#selectBankA').val(data[19]);
        $('#selectBankC').val(data[20]);
        $('#selectContractID').val(data[21]);
        $('#selectContractDate').val(data[22]);
        $('#selectPrivileges').val(data[23]);
        $('#selectCDate').val(data[24]);
        $('#selectDDate').val(data[25]);
        $('#selectCity').val(data[26]);
        $('#selectArea').val(data[27]);
        $('#selectStreet').val(data[28]);
        $('#selectHouse').val(data[29]);
        $('#selectFlat').val(data[30]);
        $('#selectZCode').val(data[31]);
        $('#selectEmail').val(data[32]);
        $('#selectACode').val(data[33]);
        $('#selectBalance').val(data[34]);
        $('#selectRate').val(data[35]);
        $('#selectPassword').val(data[36]);
        $('#selectCredit').val(data[37]);
        $('#selectAccID').val(data[38]);
    }

    function AddFields(data) {
        //add empty field
        $('#selectExtension').append('<option value="' + -1 + '"></option>');
        $('#selectExtensionDescription').append('<option value="' + -1 + '"></option>');
        $('#selectLastName').append('<option value="' + -1 + '"></option>');
        $('#selectFirstName').append('<option value="' + -1 + '"></option>');
        $('#selectSecondName').append('<option value="' + -1 + '"></option>');
        $('#selectFullName').append('<option value="' + -1 + '"></option>');
        $('#selectDepartment').append('<option value="' + -1 + '"></option>');
        $('#selectExtension2').append('<option value="' + -1 + '"></option>');
        $('#selectExtension3').append('<option value="' + -1 + '"></option>');
        $('#selectLegal').append('<option value="' + -1 + '"></option>');
        $('#selectAuxiliaryID').append('<option value="' + -1 + '"></option>');
        $('#selectTType').append('<option value="' + -1 + '"></option>');
        $('#selectEquipmentName').append('<option value="' + -1 + '"></option>');
        $('#selectDescription').append('<option value="' + -1 + '"></option>');
        $('#selectInformation').append('<option value="' + -1 + '"></option>');
        $('#selectFirm').append('<option value="' + -1 + '"></option>');
        $('#selectCode').append('<option value="' + -1 + '"></option>');
        $('#selectPCode').append('<option value="' + -1 + '"></option>');
        $('#selectTCode').append('<option value="' + -1 + '"></option>');
        $('#selectBankA').append('<option value="' + -1 + '"></option>');
        $('#selectBankC').append('<option value="' + -1 + '"></option>');
        $('#selectContractID').append('<option value="' + -1 + '"></option>');
        $('#selectContractDate').append('<option value="' + -1 + '"></option>');
        $('#selectPrivileges').append('<option value="' + -1 + '"></option>');
        $('#selectCDate').append('<option value="' + -1 + '"></option>');
        $('#selectDDate').append('<option value="' + -1 + '"></option>');
        $('#selectCity').append('<option value="' + -1 + '"></option>');
        $('#selectArea').append('<option value="' + -1 + '"></option>');
        $('#selectStreet').append('<option value="' + -1 + '"></option>');
        $('#selectHouse').append('<option value="' + -1 + '"></option>');
        $('#selectFlat').append('<option value="' + -1 + '"></option>');
        $('#selectZCode').append('<option value="' + -1 + '"></option>');
        $('#selectEmail').append('<option value="' + -1 + '"></option>');
        $('#selectACode').append('<option value="' + -1 + '"></option>');
        $('#selectBalance').append('<option value="' + -1 + '"></option>');
        $('#selectRate').append('<option value="' + -1 + '"></option>');
        $('#selectPassword').append('<option value="' + -1 + '"></option>');
        $('#selectCredit').append('<option value="' + -1 + '"></option>');
        $('#selectAccID').append('<option value="' + -1 + '"></option>');

        //add source fields
        for (var i = 0; i < data.length; i++) {
            $('#selectExtension').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectExtensionDescription').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectLastName').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectFirstName').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectSecondName').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectFullName').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectDepartment').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectExtension2').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectExtension3').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectLegal').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectAuxiliaryID').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectTType').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectEquipmentName').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectDescription').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectInformation').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectFirm').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectCode').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectPCode').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectTCode').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectBankA').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectBankC').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectContractID').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectContractDate').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectPrivileges').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectCDate').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectDDate').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectCity').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectArea').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectStreet').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectHouse').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectFlat').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectZCode').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectEmail').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectACode').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectBalance').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectRate').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectPassword').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectCredit').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectAccID').append('<option value="' + i + '">' + data[i] + '</option>');
        }
    }

    function InitTable(data) {
        //create head row
        var trHead = document.createElement('tr');
        for (var i = 0; i < data[0].length; i++) {
            //create cell
            var th = document.createElement('th');
            th.innerText = data[0][i];
            //add cell to row
            trHead.appendChild(th);
        }
        $('#tableWithData tr:last').after(trHead);

        for (var i = 1; i < data.length; i++) {
            //create row
            var tr = document.createElement('tr');
            for (var j = 0; j < data[i].length; j++) {
                //create cell
                var td = document.createElement('td');
                td.innerText = data[i][j];
                //add cell to row
                tr.appendChild(td);
            }
            //add row to table
            $('#tableWithData tr:last').after(tr);
        }

    }

    function Start() {
        //start export
        $.ajax({
            type: "POST",
            async: true,
            url: '/SubscribersImport/Start/',
            traditional: true
        });
    }

    function GetStatus() {
        $.ajax({
            type: "POST",
            async: true,
            url: '/SubscribersImport/GetStatus/',
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    //not yet
                    var percent = (response.x * 100) / response.y;
                    $('#procc').css('width', percent + '%');
                    $('#procc').html(response.x + ' / ' + response.y);

                    if (!response.c) {
                        GetStatus();
                    }
                    //completed
                    else {
                        $('#process').attr('hidden', true);
                        $('#compl').attr('hidden', false);

                        $('#procc').css('width', '100%');
                        $('#procc').html(response.msg);

                        $('#addedA').text(response.addA);
                        $('#addedE').text(response.addE);
                        $('#addedX').text(response.addX);

                        $('#proccContainer').slideUp('fast');
                        $('#ImportStatus').slideDown('fast');
                        $('#ButtonsEndCase').slideDown('fast');
                    }
                }
                else {
                    $('#process').attr('hidden', true);
                    $('#compl').attr('hidden', true);
                    $('#errorl').attr('hidden', false);

                    $('#errorMsg').html(response.msg);

                    $('#proccContainer').slideUp('fast');
                    $('#ImportStatusError').slideDown('fast');
                    $('#ButtonsEndCase').slideDown('fast');
                }
            }
        });
    }

    //Initialize tooltips
    $('.nav-tabs > li a[title]').tooltip();

    //Wizard
    $('a[data-toggle="tab"]').on('show.bs.tab', function (e) {

        var $target = $(e.target);

        if ($target.parent().hasClass('disabled')) {
            return false;
        }
    });
    $(".prev-step").click(function (e) {

        var $active = $('.wizard .nav-tabs li.active');
        prevTab($active);
    });

    //file input
    var inputs = document.querySelectorAll('.file-input');
    for (var i = 0, len = inputs.length; i < len; i++) {
        customInput(inputs[i]);
    }
    function customInput(el) {
        const fileInput = el.querySelector('[type="file"]');
        const label = el.querySelector('[data-js-label]');

        fileInput.onchange = fileInput.onmouseout = function () {
            if (!fileInput.value) return;

            var value = fileInput.value.replace(/^.*[\\\/]/, '');
            el.className += ' -chosen';
            label.innerText = value;
        };
    }

    //welcome
    $('#WelcomeButton').on('click', function () {
        var $active = $('.wizard .nav-tabs li.active');
        $active.next().removeClass('disabled');
        nextTab($active);

        MakeDisable(1);
    });

    //chnage file format
    $('#SelectFileFormat').change(function () {
        $('#FileInput').attr('accept', '.' + $('#SelectFileFormat option:selected').val());
    });

    //get tables names
    $('#FileProcessButton').on('click', function () {
        var data = new FormData();
        var file = ($("#FileInput"))[0].files[0];

        if (file != null) {
            ShowSpinner(true);
            $('#emptyFile').slideUp('fast');
            data.append($('#SelectFileFormat option:selected').val(), file);

            $.ajax({
                type: "POST",
                async: true,
                url: '/SubscribersImport/LoadFile/?type=' + $('#SelectFileFormat option:selected').val(),
                data: data,
                datatype: 'json',
                contentType: false,
                processData: false,
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        //clear select with tables and load new
                        $('#SelectWitTables').empty();
                        response.tables.forEach(function (e) {
                            $('#SelectWitTables').append('<option value="' + e + '">' + e + '</option>');
                        });

                        var $active = $('.wizard .nav-tabs li.active');
                        $active.next().removeClass('disabled');
                        nextTab($active);

                        MakeDisable(2);
                    }
                    else {
                        $('#FileProcessButton').attr('disabled', true);
                    }
                    ShowSpinner(false);
                }
            });
        }
        else {
            $('#emptyFile').slideDown('fast');
        }
    });

    //get predata and build table
    $('#FilePreloadButton').on('click', function () {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            async: true,
            url: '/SubscribersImport/GetPreData/?table=' + encodeURIComponent($('#SelectWitTables option:selected').val()),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {

                    let tb = JSON.parse(response.tb);

                    //build table with pre data
                    ClearTableAndSelect();
                    InitTable(tb);

                    //add fields to selectes
                    AddFields(tb[0]);

                    //selected matched
                    SelectedMatch(response.sl);

                    var $active = $('.wizard .nav-tabs li.active');
                    $active.next().removeClass('disabled');
                    nextTab($active);

                    MakeDisable(3);
                }
                else {
                    $('#FilePreloadButton').attr('disabled', true);
                }
                ShowSpinner(false);
            }
        });
    });

    //send selected matches
    $('#FileMatchButton').on('click', function () {
        ShowSpinner(true);

        var mathces = $('#selectExtension').val() + ',' +
            $('#selectExtensionDescription').val() + ',' +
            $('#selectLastName').val() + ',' +
            $('#selectFirstName').val() + ',' +
            $('#selectSecondName').val() + ',' +
            $('#selectFullName').val() + ',' +
            $('#selectDepartment').val() + ',' +
            $('#selectExtension2').val() + ',' +
            $('#selectExtension3').val() + ',' +
            $('#selectLegal').val() + ',' +
            $('#selectAuxiliaryID').val() + ',' +
            $('#selectTType').val() + ',' +
            $('#selectEquipmentName').val() + ',' +
            $('#selectDescription').val() + ',' +
            $('#selectInformation').val() + ',' +
            $('#selectFirm').val() + ',' +
            $('#selectCode').val() + ',' +
            $('#selectPCode').val() + ',' +
            $('#selectTCode').val() + ',' +
            $('#selectBankA').val() + ',' +
            $('#selectBankC').val() + ',' +
            $('#selectContractID').val() + ',' +
            $('#selectContractDate').val() + ',' +
            $('#selectPrivileges').val() + ',' +
            $('#selectCDate').val() + ',' +
            $('#selectDDate').val() + ',' +
            $('#selectCity').val() + ',' +
            $('#selectArea').val() + ',' +
            $('#selectStreet').val() + ',' +
            $('#selectHouse').val() + ',' +
            $('#selectFlat').val() + ',' +
            $('#selectZCode').val() + ',' +
            $('#selectEmail').val() + ',' +
            $('#selectACode').val() + ',' +
            $('#selectBalance').val() + ',' +
            $('#selectRate').val() + ',' +
            $('#selectPassword').val() + ',' +
            $('#selectCredit').val() + ',' +
            $('#selectAccID').val();

        $.ajax({
            type: "POST",
            async: true,
            url: '/SubscribersImport/SetMatch/?mathces=' + mathces,
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    var $active = $('.wizard .nav-tabs li.active');
                    $active.next().removeClass('disabled');
                    nextTab($active);

                    MakeDisable(4);
                }
                else {
                    $('#FileMatchButton').attr('disabled', true);
                }
                ShowSpinner(false);
            }
        });
    });

    //save primary key
    $('#FileSaveKeyButton').on('click', function () {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            async: true,
            url: '/SubscribersImport/SaveKey/' + $('input[name=pKey]:checked').val(),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    var $active = $('.wizard .nav-tabs li.active');
                    $active.next().removeClass('disabled');
                    nextTab($active);

                    MakeDisable(5);
                }
                else {
                    $('#FileSaveKeyButton').attr('disabled', true);
                }
                ShowSpinner(false);
            }
        });
    });

    //block devices section
    $('#SelectAutoDevice').change(() => {
        if ($('#SelectAutoDevice').prop('checked')) {
            $('#pbxsSection').addClass('disDiv');
        }
        else {
            $('#pbxsSection').removeClass('disDiv');
        }
    });

    //save device
    $('#SavePlaneButton').on('click', function () {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            async: true,
            url: '/SubscribersImport/SaveDevice/' + ($('#SelectAutoDevice').prop('checked') === true ? 0 : $('#SelectedDevice option:selected').val()),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {

                    var $active = $('.wizard .nav-tabs li.active');
                    $active.next().removeClass('disabled');
                    nextTab($active);

                    MakeDisable(-1);

                    Start();
                    GetStatus();
                }
                else {
                    $('#SavePlaneButton').attr('disabled', true);
                }
                ShowSpinner(false);
            }
        });
    });

    //cloase wizard
    $('#CloseWizard, #CancelImport').on('click', function () {
        window.location = $('#closeUrl').val();
    });

    ExpandLeftMenu();
});