﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using SoftPi.Tariscope.Common;
using SoftPi.Tariscope.DAL;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;
using Microsoft.Data.SqlClient;

public class SetCosHiPath4000Script : IScript
{
    private IScriptHost Host;

    // Change this constants to set your specific parameters
    const string PBX_LOGIN = "root";
    const string PBX_PASSWORD = "hicom";
    const string TOTAL_RESTRICTED_CLASS = "2";
    const string DEFAULT_UNRESTRICTED_CLASS = "4";
    // -END OF constants

    private readonly byte[] commandCancel = new byte[] { 24 }; // ^X Cancel line
    private readonly byte[] commandDC4 = new byte[] { 20 }; // ^T Device control
    private readonly byte[] commandETX = new byte[] { 3 }; // ^C End of text

    private const int WaitTimeout = 3000;

    private bool _isCancelled;

    public void Init(IScriptHost host)
    {
        this.Host = host;
        host.Close += OnClose;
    }
    private void OnClose(ref bool Cancel)
    {
        _isCancelled = true;
        return;
    }

    public void Main(object Parameters)
    {
        SubscriberLimitingActionParameters ActionParameters = (SubscriberLimitingActionParameters)Parameters;

        try
        {
            LogScriptArguments(ActionParameters);

            List<DN> Dns = GetAffectedDns(ActionParameters);

            SendCommand(commandCancel, 500);
            SendCommand(commandCancel, 1000);
            SendCommand(commandDC4, 0);

            RetryCommand(LoginPbx, 3);

            foreach (DN currentDN in Dns)
                RetryCommand(() => ProcessDN(ActionParameters, currentDN), 3);

            SendCommand(commandCancel, 100);
            ActionParameters.Result = MediationActionResult.Success;
        }
        catch (Exception ex)
        {
            this.Host.AddEvent(ex.ToString());
            ActionParameters.Result = MediationActionResult.Fail;
        }
    }

    private void ProcessDN(SubscriberLimitingActionParameters ActionParameters, DN currentDN)
    {
        string commandText = string.Format("cha-sdat:{0},data,,,,{1},{1};", currentDN.DN, ActionParameters.CosValue);
        SendCommand(commandText);
        WaitOrThrow("<");
    }

    private void RetryCommand(Action action, int retryCount)
    {
        var currentRetries = 0;
        do
        {
            try
            {
                action.Invoke();
                return;
            }
            catch (TimeoutException ex)
            {
                Host.AddEvent(string.Format("Command execution timeout. try {0} from {1}", currentRetries, retryCount));
                currentRetries += 1;
                if (currentRetries > retryCount)
                    throw;
                if (_isCancelled)
                    throw new OperationCanceledException();
            }
        }
        while (true);
    }

    private void LoginPbx()
    {
        WaitOrThrow("LOGIN =");
        SendCommand(PBX_LOGIN);
        WaitOrThrow("PASSW =");
        SendCommand(PBX_PASSWORD);
        WaitOrThrow("<");
    }

    private void LogScriptArguments(SubscriberLimitingActionParameters ActionParameters)
    {
        this.Host.AddEvent(string.Format("Restrict subscriber:{0} Cos:{1}, Category: {2}", ActionParameters.Abonent.AbonentName, ActionParameters.CosValue, ActionParameters.Credit.CategoryID));
        this.Host.AddEvent("Action type:" + ActionParameters.ActionType.ToString());
    }

    private List<DN> GetAffectedDns(SubscriberLimitingActionParameters ActionParameters)
    {
        List<DN> Dns;
        string CategoryName;
        using (SqlConnection cn = new SqlConnection(this.Host.DatabaseConnectionString))
        {
            cn.Open();
            if (ActionParameters.Credit.CategoryID.HasValue)
                CategoryName = new Categories(cn).Details(ActionParameters.Credit.CategoryID.Value).Name;
            else
                CategoryName = "All categories";
            this.Host.AddEvent("Category:" + CategoryName);
            Dns = DNs.Instance(cn).Load(ActionParameters.Abonent.ID).Where(x => DateTime.Now > x.FromDateValue & DateTime.Now < x.ToDateValue).ToList();
        }

        return Dns;
    }

    private void SendCommand(byte[] commandBytes, int cooldownMs)
    {
        Host.SendData(commandBytes);
        if (cooldownMs > 0)
            Host.Wait(cooldownMs);
    }

    private void SendCommand(string commandText)
    {
        Host.Send(commandText);
        SendCommand(commandETX, 0);
    }

    private void WaitOrThrow(string responseText)
    {
        var result = Host.WaitFor(responseText, WaitTimeout);
        if (!result)
            throw new TimeoutException("Response timeout, waited for response: " + responseText);
    }
}
