﻿$(document).ready(() => {
    let selectedAB = null;

    //0 - charge month
    //1 - recharge month
    //2 - clear month
    //3 - clear invoice
    let monthMode = 0;

    let requestCharge = null;
    let requestReCharge = null;
    let requestCleanMonth = null;
    let requestCleanInvoices = null;

    function ShowActionProgress(show) {
        if (show) {
            $('#countAbonents').text('0');
            $('#totalAbonents').text('0');
            $('#restoreProgress').css('width', '0px');

            $("#ActionInformation").modal({
                backdrop: "static",
                keyboard: false,
                show: true
            });
        }
        else {
            $("#ActionInformation").modal('hide');

            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();
        }
    }

    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/AccountSummary/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/AccountSummary/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function UpdateButtons() {
        if (selectedAB === null) {
            $("#btnOpen").attr("disabled", true);
            $('#btnOpenMenu').addClass('disDiv');
        }
        else {
            $("#btnOpen").attr("disabled", false);
            $('#btnOpenMenu').removeClass('disDiv');
        }

    }

    function RowClick(e) {
        if (e.hasClass('selected')) {
            e.removeClass('selected');
            selectedAB = null;
        }
        else {
            if (e.data('isdepartment') !== true) {
                selectedAB = e.find('td[data-name="ID"]').text();
                $('#tariscope-ab tr.selected').removeClass('selected');
                e.addClass('selected');
            }
        }

        UpdateButtons();
    }

    function AttachEventsToTable() {
        var header = document.getElementById("accountsHeader");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        $('#tariscope-ab tbody').on('click', 'tr', function () { RowClick($(this)); });
        $('#tariscope-ab tbody').on('dblclick', 'tr', function () {
            RowClick($(this));
            if (selectedAB != null)
                $('#btnOpen').click();
        });
        UpdateButtons();
    }

    function LoadDepartments(e) {
        selectedCategory = null;

        if (!e || !e.trim()) {
            $('#subscribersTable').load('/AccountSummary/GetRoot/', AttachEventsToTable);
        }
        else {
            $('#subscribersTable').load('/AccountSummary/GetAbonentsSearchTable/?search=' + encodeURIComponent(e), AttachEventsToTable);
        }
    }

    function AttachEventsToSummary() {
        //hide and show eleemts (change view)
        $('#accountsSection').hide();
        $('#accountTitle').hide();

        $('#summarySection').show();
        $('#summaryTitle').show();
        $('#SummaryBackTo').show();
        $('#accountLinkToAccounts').show();

        ShowSpinner(false);
    }

    function AddNodes() {
        $.ajax({
            type: "POST",
            url: '/AccountSummary/GetNodes',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#NodesToAction').empty();

                    let i = 0;
                    for (key in response.nodes) {
                        $($('#NodesToAction')).append('<option value="' + key + '">' + response.nodes[key] + '</option>');
                        i++;
                    }
                    $($('#NodesToAction')).val($('option:first', $('#NodesToAction')).val());
                    $('#StartMonthAction').prop('disabled', i === 0);

                    let dt = new Date();

                    $('#YearToAction').val(dt.getFullYear() + '');
                    $('#MonthToAction').val((dt.getMonth() + 1) + '');

                    $('#ChargeServiceSection').prop('hidden', monthMode !== 1);

                    if (response.isAdmin === true) {
                        $('#nodesAdminMsg').show();
                        $('#nodesComplyMsg').hide();
                    }
                    else {
                        $('#nodesAdminMsg').hide();
                        $('#nodesComplyMsg').show();
                    }

                    $('#editMonthmodal').modal('show');
                }
            }
        });
    }

    function ChargeMonth() {
        if (requestCharge !== null)
            requestCharge.abort();

        ResetTempData(() => {
            GetMonthStatus();

            requestCharge = $.ajax({
                type: "POST",
                url: '/AccountSummary/ChargeMonth/' + $('#YearToAction').val() + '/' + $('#MonthToAction').val() + '/' + $('#NodesToAction').val(),
                traditional: true,
                success: function () {
                    requestCharge = null;
                    GetLoadedAbonents();
                }
            });
        });
    }

    function ReChargeMonth() {
        if (requestReCharge !== null)
            requestReCharge.abort();

        ResetTempData(() => {
            GetMonthStatus();

            requestReCharge = $.ajax({
                type: "POST",
                url: '/AccountSummary/ReChargeMonth/' + $('#YearToAction').val() + '/' + $('#MonthToAction').val() + '/' + $('#NodesToAction').val() + '/?ChargeServices=' + $('#chargeServices').prop('checked'),
                traditional: true,
                success: function () {
                    requestReCharge = null;
                    GetLoadedAbonents();
                }
            });
        });
    }

    function CleanMonth() {
        if (requestCleanMonth !== null)
            requestCleanMonth.abort();

        ResetTempData(() => {
            GetMonthStatus();

            requestCleanMonth = $.ajax({
                type: "POST",
                url: '/AccountSummary/CleanMonthForAll/' + $('#YearToAction').val() + '/' + $('#MonthToAction').val() + '/' + $('#NodesToAction').val(),
                traditional: true,
                success: function () {
                    requestCleanMonth = null;
                    GetLoadedAbonents();
                }
            });
        });
    }

    function CleanInvoices() {
        if (requestCleanInvoices !== null)
            requestCleanInvoices.abort();

        ResetTempData(() => {
            GetMonthStatus();

            requestCleanInvoices = $.ajax({
                type: "POST",
                url: '/AccountSummary/CleanInvoicesForAll/' + $('#YearToAction').val() + '/' + $('#MonthToAction').val() + '/' + $('#NodesToAction').val(),
                traditional: true,
                success: function () {
                    requestCleanInvoices = null;
                    GetLoadedAbonents();
                }
            });
        });
    }

    function GetMonthStatus() {
        $.ajax({
            type: "POST",
            url: '/AccountSummary/GetMonthActionStatus',
            traditional: true,
            success: function (response) {
                if (response !== null) {
                    if (response.success === true) {
                        ShowActionProgress(false);
                        $('#Successdmodal').modal('show');
                    }
                    else {
                        $('#countAbonents').text(response.Count);
                        $('#totalAbonents').text(response.Total);
                        $('#restoreProgress').css('width', response.progress + '%');

                        setTimeout(GetMonthStatus, 500);
                    }
                }
            }
        });
    }

    function ResetTempData(callback) {
        requestCharge = $.ajax({
            type: "POST",
            url: '/AccountSummary/ResetMountStatusData',
            traditional: true,
            success: function () { callback(); }
        });
    }

    function CheckForEdit() {
        if (window.location.href.includes('#')) {
            let index = window.location.href.indexOf('#') + 1;
            let id = window.location.href.substr(index, window.location.href.length - index);

            if (id || id.trim()) {
                selectedAB = id;
                ShowSpinner(true);
                $('#summarySection').load('/AccountSummary/GetSummary/' + selectedAB, AttachEventsToSummary);
            }
        }
    }

    function GetLoadedAbonents() {
        let abonents = [];
        let loadedRows = $('tr[data-isdepartment="false"]');
        for (var i = 0; i < loadedRows.length; i++) {
            abonents.push($(loadedRows[i]).data('abonentid'));
        }
        return abonents.join(',');
    }

    function UpdateBalances() {
        $.ajax({
            type: "POST",
            url: '/AccountSummary/LoadBalances/?IDs=' + encodeURIComponent(GetLoadedAbonents()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    for (id in response.balances) {
                        let b = response.balances[id];
                        let row = $('tr[data-abonentid="' + id + '"]');
                        if (row !== null) {
                            if (b < 0) {
                                $(row).css('color', 'red');
                            }
                            else {
                                $(row).css('color', 'black');
                            }
                        }

                        $(row).find('td[data-name="Balance"]').text(b);
                    }
                }
            }
        });
    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            LoadDepartments($('#tbSearch').val());
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    /*attach events for select column*/
    $('#MenuSelectColumn input').on('click', function (event) {
        var visible = $(event.target).prop('checked');
        var colName = $(event.target).attr('data-value');
        var colName2 = $(event.target).attr('data-named');

        $.ajax({
            type: "POST",
            url: '/AccountSummary/SetTableColumnVisability?colName=' + colName + "&visible=" + visible,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    if (visible === true) {
                        $('[data-name="' + colName2 + '"]').show();
                    }
                    else {
                        $('[data-name="' + colName2 + '"]').hide();
                    }
                }
            }
        });
    });

    //load summary for abonent
    $('#btnOpen, #btnOpenMenu').on('click', () => {
        ShowSpinner(true);
        $('#summarySection').load('/AccountSummary/GetSummary/' + selectedAB, AttachEventsToSummary);
    });

    //back to account
    $('#SummaryBackTo').on('click', () => {
        $('#accountsSection').show();
        $('#accountTitle').show();

        $('#summarySection').hide();
        $('#summaryTitle').hide();
        $('#SummaryBackTo').hide();
        $('#accountLinkToAccounts').hide();

        UpdateBalances();
    });

    //set active or inactive abonents
    $('#activeonly').change(function () {
        $.ajax({
            type: "POST",
            url: '/AccountSummary/SetActiveOnly?value=' + $(this).prop('checked'),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadDepartments('');
                }
            }
        });
    });

    //redirect to batch payments
    $('#btnBatchFile, #btnBatchFileMenu').on('click', () => { window.open('/Payments/File', '_parent'); });
    $('#btnBatch, #btnBatchMenu').on('click', () => { window.open('/Payments/Manual', '_parent'); });
    $('#btnChargingOneTimeService').on('click', () => { window.open('/AccountSummary/OneTimeServiceImport', '_parent'); });

    /*attach events for export*/
    $('#ExportEXCEL, #ExportEXCELMenu').on('click', function () { Export("xlsx"); });
    $('#ExportHTML, #ExportHTMLMenu').on('click', function () { Export("html"); });
    $('#ExportCSV, #ExportCSVMenu').on('click', function () { Export("csv"); });
    $('#ExportPDF, #ExportPDFMenu').on('click', function () { Export("pdf"); });

    //charge month
    $('#btnChargeMonth, #btnChargeMonthMenu').on('click', () => {
        $('#chargeMonthTitle').show();
        $('#rechargeMonthTitle').hide();
        $('#clenaMonthTitle').hide();
        $('#clenaMonthInvoicesTitle').hide();

        $('#pSuccessCharge').show();
        $('#pSuccessReCharge').hide();
        $('#pSuccessClean').hide();
        $('#pSuccessCleanInvoice').hide();

        monthMode = 0;
        AddNodes();
    });

    //recharge month
    $('#btnReChargeMonth, #btnReChargeMonthMenu').on('click', () => {
        $('#chargeMonthTitle').hide();
        $('#rechargeMonthTitle').show();
        $('#clenaMonthTitle').hide();
        $('#clenaMonthInvoicesTitle').hide();

        $('#pSuccessCharge').hide();
        $('#pSuccessReCharge').show();
        $('#pSuccessClean').hide();
        $('#pSuccessCleanInvoice').hide();

        $('#chargeServices').prop('checked', true);

        monthMode = 1;
        AddNodes();
    });

    //clean month
    $('#btnCleanMonth, #btnCleanMonthMenu').on('click', () => {
        $('#chargeMonthTitle').hide();
        $('#rechargeMonthTitle').hide();
        $('#clenaMonthTitle').show();
        $('#clenaMonthInvoicesTitle').hide();

        $('#pSuccessCharge').hide();
        $('#pSuccessReCharge').hide();
        $('#pSuccessClean').show();
        $('#pSuccessCleanInvoice').hide();

        monthMode = 2;
        AddNodes();
    });

    //clean invoices
    $('#btnCleanMonthInvoices, #btnCleanMonthInvoicesMenu').on('click', () => {
        $('#clenaMonthInvoicesTitle').show();
        $('#chargeMonthTitle').hide();
        $('#rechargeMonthTitle').hide();
        $('#clenaMonthTitle').hide();

        $('#pSuccessCleanInvoice').show();
        $('#pSuccessCharge').hide();
        $('#pSuccessReCharge').hide();
        $('#pSuccessClean').hide();

        monthMode = 3;
        AddNodes();
    });

    //start month action
    $('#StartMonthAction').on('click', () => {
        $('#editMonthmodal').modal('hide');
        ShowActionProgress(true);

        switch (monthMode) {
            case 0:
                ChargeMonth();
                break;
            case 1:
                ReChargeMonth();
                break;
            case 2:
                CleanMonth();
                break;
            case 3:
                CleanInvoices();
                break;
        }
    });

    //show modal to recalculate predicitons
    $('#btnRecalculatePredictions, #btnRecalculatePredictionsMenu').on('click', () => { $('#RecalculatePredictionModal').modal('show'); });
    $('#btnConfirmRecalculatePrediciton').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/AI/Prediction/Rerun',
            traditional: true,
            success: function (response) {
                if (response !== null) {
                    if (response.success === true) {
                        $('#RecalculateSuccessModal').modal('show');
                    }
                    else {
                        $('#RecalculateErrorModal').modal('show');
                    }
                }
            }
        });
    });

    //check for open
    CheckForEdit();

    LoadDepartments('');
});