﻿$(document).ready(() => {
    let loadPerChunk = 50;
    let loader = null;

    function GetDepartment(left, e, parent, hd) {
        //create department row
        var tr = document.createElement('tr');
        tr.setAttribute('data-id', e.ID);
        tr.setAttribute('data-isdepartment', 'true');
        tr.setAttribute('data-departmentid', e.ID);
        tr.setAttribute('data-departmentparentid', e.ParentID);
        tr.setAttribute('data-loaded', 'false');
        tr.setAttribute('data-opened', 'false');
        tr.setAttribute('data-parentID', parent);
        tr.setAttribute('data-items', '0');
        tr.setAttribute('data-departmentsloaded', 'false');

        var tdDesc = document.createElement('th');
        tdDesc.setAttribute('data-name', 'Description');
        tdDesc.className = 'Tree';

        var span1 = document.createElement('span');
        span1.setAttribute('data-id', e.ID);
        span1.className = 'expandButton';
        span1.innerHTML = '<i data-id="' + e.ID + '" class="fa fa-plus"></i>';
        span1.style.marginLeft = (left * 1 + 15) + 'px';


        //event for open next children
        $(span1).on('click', function () {
            ExpandChildren(e.ID);
        });

        var span2 = document.createElement('span');
        span2.className = 'descSpan';
        span2.innerHTML = e.Name;
        span2.style.marginLeft = '5px';

        //row description
        tdDesc.appendChild(span1);
        tdDesc.appendChild(span2);

        tr.appendChild(tdDesc);
        tr.appendChild(createTD('Number', "", hd[1], true));
        tr.appendChild(createTD('Rate', "", hd[2], true));
        tr.appendChild(createTD('NumberCount', "", hd[3], true));
        tr.appendChild(createTD('ID', e.ID, hd[4], true));
        tr.appendChild(createTD('Description', "", hd[5], true));
        tr.appendChild(createTD('Contract', "", hd[6], true));
        tr.appendChild(createTD('Balance', "", hd[7], true));
        tr.appendChild(createTD('Information', "", hd[8], true));
        tr.appendChild(createTD('AllNumbers', "", hd[9], true));
        tr.appendChild(createTD('ContractDate', "", hd[10], true));
        tr.appendChild(createTD('DateOn', "", hd[11], true));
        tr.appendChild(createTD('DateOff', "", hd[12], true));
        tr.appendChild(createTD('AccountID', "", hd[13], true));
        tr.appendChild(createTD('NumberDescription', "", hd[14], true));

        tr.style.display = 'none';

        return tr;
    }

    function GetIcon(id) {
        //get icon for animate
        return $('i[data-id="' + id + '"]');
    }

    function GetSapnIcon(id) {
        //get icon for animate
        return $('span[data-id="' + id + '"]');
    }

    function LoadAbonents(parent, last) {
        if (loader !== null)
            loader.abort();

        let d = $('#tariscope-ab tr[data-id="' + parent + '"]');

        let loadedForBranch = d.attr('data-items') * 1;

        loader = $.ajax({
            type: "POST",
            async: 'async',
            url: '/AccountSummary/GetAbonents/' + parent + '/?Skip=' + loadedForBranch + '&Load=' + loadPerChunk,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    let left = GetSapnIcon(parent).css('margin-left').replace('px', '');
                    let id = last;

                    response.abonents.forEach((abonent) => {
                        $('#tariscope-ab tr[data-id="' + id + '"]')[0].closest('tr').after(GetAbonent(left, abonent, parent, true, response.hd));
                        id = abonent.ID;
                        loadedForBranch++;
                    });

                    OpenChildren(parent);

                    d.attr('data-items', loadedForBranch);

                    if (response.abonents.length !== 0) {
                        LoadAbonents(parent, id);
                    }
                    else {
                        d.attr('data-loaded', 'true');
                    }
                }
            }
        });
    }

    function LoadChildren(e) {
        //load children of selected branch
        $.ajax({
            type: "POST",
            async: 'async',
            url: '/AccountSummary/GetDepartments/' + e,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    let left = GetSapnIcon(e).css('margin-left').replace('px', '');
                    let id = e;

                    //add departments
                    let d = $('#tariscope-ab tr[data-id="' + e + '"]');
                    if (d.attr('data-departmentsloaded') === 'false')
                        response.departmetns.forEach((department) => {
                            $('#tariscope-ab tr[data-id="' + id + '"]')[0].closest('tr').after(GetDepartment(left, department, e, response.hd));
                            id = department.ID;
                        });
                    d.attr('data-departmentsloaded', 'true');

                    //load abonents
                    loadedForBranch = 0;
                    LoadAbonents(e, id);

                    OpenChildren(e);
                    GetIcon(e).css('transform', 'rotate(45deg)');
                }
            }
        });
    }

    function OpenChildren(id) {
        //open loaded or closed children
        var collection = $('#tariscope-ab tr[data-parentID="' + id + '"]');
        collection.each(function (index) {
            $(collection[index]).show();
        });
    }

    function CloseChildren(id) {
        if (loader !== null)
            loader.abort();

        //close openen children
        var collection = $('#tariscope-ab tr[data-parentID="' + id + '"]');
        collection.hide();

        var childdepartments = [];

        collection.each((index) => {

            if ($(collection[index]).data('opened') === true) {
                CloseChildren($(collection[index]).attr('data-id'));
            }

            if ($(collection[index]).data('isdepartment') === true) {
                childdepartments.push($(collection[index]));
            }

            //$(collection[index]).slideUp('fast');
        });

        //close opened subchildren
        childdepartments.map((e) => {
            CloseChildren(e.data('departmentid'))
        });

        GetIcon(id).css('transform', 'rotate(0)');
    }

    function ExpandChildren(id) {
        var ID = id + ''; //always must be string
        var parent = $('#tariscope-ab tr[data-departmentid="' + ID + '"]')[0];

        //load
        if ($(parent).attr('data-opened') === 'false' && $(parent).attr('data-loaded') === 'false') {
            LoadChildren(ID);

            $(parent).attr('data-opened', 'true');
        }
        //open children
        else if ($(parent).attr('data-opened') === 'false' && $(parent).attr('data-loaded') === 'true') {
            $(parent).attr('data-opened', 'true');

            OpenChildren(ID);
            GetIcon(ID).css('transform', 'rotate(45deg)');
        }
        //hide children
        else {
            $(parent).attr('data-opened', 'false');

            GetIcon(ID).css('transform', 'rotate(0)');
            CloseChildren(ID);
        }
    }

    //expand children
    $('.expandButton').click(function () { ExpandChildren($(this).data('id')); });
});