﻿$(document).ready(() => {
    let SelectedProvider = null;
    let providerForImport = null;

    function LoadProviders() {
        $('#NextStep').prop('disabled', true);
        $('#ProvidersBody').load('/Providers/Search', () => {
            $('#tariscope-pr tbody').on('click', 'tr', function () {
                if ($(this).hasClass('selected')) {
                    $(this).removeClass('selected');
                    SelectedProvider = null;
                }
                else {
                    SelectedProvider = $(this).find('td[data-name="ID"]').text();
                    $('#tariscope-pr tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }

                $('#NextStep').prop('disabled', SelectedProvider == null);
            });
        });
    }

    function UpdateProvidersForImportButtonsUI() {
        /*update ui for buttons when not selected any provider for import import button are disabled*/
        if (providerForImport === null) {
            $("#modalButtonImport").attr("disabled", true);
        }
        else {
            $("#modalButtonImport").attr("disabled", false);
        }
    }

    function SendData() {
        ShowSpinner(true);

        var formData = new FormData();

        formData.append('SelectedProvider', SelectedProvider);
        formData.append('AccessCode', $('#AccessCode').val());
        formData.append('DeviceID', $('#DeviceID').val());

        $.ajax({
            type: "POST",
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            url: '/DeviceWizard/Step4_v/',
            success: function (response) {
                if (response !== null && response.success === true) { GoNext(); }
                else { ShowError(response.Errors); }
            }
        });
    }

    //setup current step number
    $('#CurrentStep').val(4);

    //go to the next step
    $('#NextStep').on('click', SendData);

    //show modal to create provider
    $('#CreateProvider').on('click', function () {
        $('#emptyAdd').attr('hidden', true);
        $('#editPRName').val('');
        $('#editPRDesc').val('');

        $('#modalButtonEdit').attr('disabled', true);
        $('#editPRModal').modal('show');
    });

    //show error when empty profider name
    $('#editPRName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyAdd').slideDown('fast');
            $('#modalButtonEdit').prop('disabled', true);
        }
        else {
            $('#emptyAdd').slideUp('fast');
            $('#modalButtonEdit').prop('disabled', false);
        }
    });

    //create a new provider
    $('#modalButtonEdit').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/Providers/EditProvider/?id=0' + '&name=' + encodeURIComponent($('#editPRName').val()) + '&desc=' + encodeURIComponent($('#editPRDesc').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadProviders();
                    $('#editPRModal').modal('hide');
                }
            }
        });
    });

    //show modal to import providers online
    $('#ImportOnline').on('click', function () {
        ShowSpinner(true);
        providerForImport = null;
        UpdateProvidersForImportButtonsUI();

        $('#providersForImportTable').load('/Providers/LoadOnline', () => {
            ShowSpinner(false);

            $('#tariscope-primport tbody').on('click', 'tr', function () {
                if ($(this).hasClass('selected')) {
                    $(this).removeClass('selected');
                    providerForImport = null;
                }
                else {
                    providerForImport = $(this).find('td[data-name="URL"]').text();
                    $('#tariscope-primport tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }

                UpdateProvidersForImportButtonsUI();
            });

            $('#webImportPRModal').modal('show');
        });
    });

    //call ImportOnlineGo action for import selected provider form web
    $('#modalButtonImport').on('click', function () {
        $('#webImportPRModal').modal('hide');
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProvidesAndRates/StartImport/?URL=' + encodeURIComponent(providerForImport),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadProviders();
                }
                else {
                    console.log('cannon import provider form online')
                }
                ShowSpinner(false);
            }
        });
    });

    //show cancel modal
    $('#CancelWizard').on('click', () => { $('#CancelWizardmodal').modal('show'); });

    LoadProviders();
});