﻿$(document).ready(() => {
    let coralFieldTypes = {
        "DATE": 1,
        "TIME": 2,
        "ELAP": 3,
        "TKG": 4,
        "TK": 5,
        "MTR": 6,
        "ST": 7,
        "ACCT": 8,
        "IN": 9,
        "DIAL": 10,
        "XFERCALL": 11,
        "EXEPRIV": 12,
        "CPN": 13,
        "PLACEHOLDER": 100,
        "TRUNK1": 101,
        "TRUNK2": 102
    }

    let fields = [];
    let selectedFieldIndex = -1;
    let selectedFieldName = '';
    let isEdit = false;

    function FillFieldArray() {
        fields = [];
        let inputs = $('#realFFFields input');

        for (let input of inputs)
            fields.push(input.id.replace('fff_', ''))
    }

    function FillParamsTables() {
        $('#realFFFields').html('');
        $('#bodyFFfieldsSection').html('');

        for (let i = 0; i < fields.length; i++) {
            $('#realFFFields').append('<input id="fff_' + fields[i] +
                '" name="OnlineParms[' + i + ']"' +
                ' value="' + (coralFieldTypes[fields[i]] === undefined ? (-1) : coralFieldTypes[fields[i]]) + '"/>');

            $('#bodyFFfieldsSection').append('<tr><td>' + (+i + 1) + '</td><td data-name="Name" data-index=' + i + ' style="padding-left: 10px !important;">' + fields[i] + '</td></tr>');
        }
    }

    function FillFieldsSelect() {
        $('#coralTypesSelect').html('');

        let availableFields = Object.getOwnPropertyNames(coralFieldTypes).filter(field => !fields.includes(field));

        if (!availableFields.includes("PLACEHOLDER"))
            availableFields.push("PLACEHOLDER")

        console.log(fields)
        console.log(availableFields)

        for (let i = 0; i < availableFields.length; i++) {
            $('#coralTypesSelect').append('<option>' + availableFields[i] + '</option>');
        }
    }

    function SetDontProc() {
        if ($('#DontProc').prop('checked')) {
            $('#DontProcExtension').removeClass('disDiv');
        }
        else {
            $('#DontProcExtension').addClass('disDiv');
        }
    }

    function UpdateButtonsFileFormat() {
        if (selectedFieldIndex === -1) {
            $("#btnEdit-History").attr("disabled", true);
            $("#btnDelete-History").attr("disabled", true);
            $("#btnSwapUp").attr("disabled", true);
            $("#btnSwapDown").attr("disabled", true);
        }
        else {
            $("#btnEdit-History").attr("disabled", false);
            $("#btnDelete-History").attr("disabled", false);
            $("#btnSwapUp").attr("disabled", false);
            $("#btnSwapDown").attr("disabled", false);
        }
    }

    function AttachEventToTableWithFileFormatfields() {
        selectedFieldIndex = -1;
        selectedFieldName = '';

        $('#tariscope-fileformatfields tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedFieldIndex = -1;
            }
            else {
                selectedFieldIndex = $(this).find('td[data-name="Name"]').attr('data-index');
                selectedFieldName = $(this).find('td[data-name="Name"]').text();
                $('#tariscope-fileformatfields tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtonsFileFormat();
        });
        UpdateButtonsFileFormat();
    }

    //update dont proc field
    $('#DontProc').change(SetDontProc);

    $("#btnSwapUp").on('click', () => {
        if (selectedFieldIndex != 0) {
            let swapVar = fields[selectedFieldIndex];
            fields[selectedFieldIndex] = fields[+selectedFieldIndex - 1];
            fields[+selectedFieldIndex - 1] = swapVar;

            FillParamsTables();

            selectedFieldIndex = -1;
            selectedFieldName = '';
            UpdateButtonsFileFormat();
        }
    });

    $("#btnSwapDown").on('click', () => {
        if (selectedFieldIndex != fields.length - 1) {
            let swapVar = fields[selectedFieldIndex];
            fields[selectedFieldIndex] = fields[+selectedFieldIndex + 1];
            fields[+selectedFieldIndex + 1] = swapVar;

            FillParamsTables();

            selectedFieldIndex = -1;
            selectedFieldName = '';
            UpdateButtonsFileFormat();
            
        }
    });

    $("#btnDefaultFields").on('click', () => {
        fields = JSON.parse($('#defaultFieldsJSON').val());
        FillParamsTables();
    });

    //show modal for add a new field
    $('#btnAdd-History').on('click', () => {
        $('#fieldsTableSection').slideUp('fast');
        $('#fsHideFields').addClass('disDiv');
        isEdit = false;

        $('#btnConfirmAddField').unbind();

        FillFieldsSelect()

        //confirm add a new field
        $('#btnConfirmAddField').on('click', () => {
            let name = $('#coralTypesSelect').val().replace(' ', '_');
            let index = fields.length;

            //add field
            $('#realFFFields').append('<input id="fff_' + name +
                '" name="OnlineParms[' + index + ']"' +
                ' value="' + (coralFieldTypes[name] === undefined ? (-1) : coralFieldTypes[name]) + '"/>');

            //add a table row
            $('#bodyFFfieldsSection').append('<tr><td>' + (+index + 1) + '</td><td data-name="Name" data-index=' + index + ' style="padding-left: 10px !important;">' + name + '</td></tr>');
            fields.push(name);

            $('#btnCloseAddField').click();
        });

        $('#addFieldSection').slideDown('fast');
    });

    //close add/edit field (cancel)
    $('#btnCloseAddField').on('click', () => {
        $('#fieldsTableSection').slideDown('fast');
        $('#fsHideFields').removeClass('disDiv');
        $('#addFieldSection').slideUp('fast');
    });

    //show modal for delete field
    $('#btnDelete-History').on('click', () => {
        $('#fieldsTableSection').slideUp('fast');
        $('#fsHideFields').addClass('disDiv');
        $('#deleteFieldSection').slideDown('fast');
    });

    //close delete field (cancel)
    $('#btnCloseDeleteField').on('click', () => {
        $('#fieldsTableSection').slideDown('fast');
        $('#fsHideFields').removeClass('disDiv');
        $('#deleteFieldSection').slideUp('fast');
    });

    //confirm delete field
    $('#btnConfirmDeleteField').on('click', () => {

        fields.splice(selectedFieldIndex, 1);
        FillParamsTables();

        selectedFieldIndex = -1;
        selectedFieldName = '';
        UpdateButtonsFileFormat();

        $('#btnCloseDeleteField').click();
    });

    AttachEventToTableWithFileFormatfields();
    SetDontProc();
    FillFieldArray();
});