﻿var selectedIssue = null;

$(document).ready(() => {
    let timeout = 700;

    selectedIssue = $('#issueID').text();

    function Export(t) {
        ShowSpinner(true);

        console.log("call Export('" + t + "')");

        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/PersonalAreaIssues/ExportChat/?ID=' + selectedIssue + '&type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/PersonalAreaIssues/DownloadExportChat/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }

                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function LoadMessages() {
        //load new messages from DB
        $.ajax({
            type: "POST",
            url: `/PersonalArea/Service/Issues/Chat/${$('#issueID').text()}/LoadMessage/${$('#LastId').val()}`,
            success: function (response) {
                if (response !== null) {

                    if (response.reload === true) {
                        location.reload();
                    }

                    if (response.success === true) {
                        let id = $('#LastId').val();
                        $('#LastId').val(response.LastID);
                        $(response.messages).insertAfter($('[data-id="' + id + '"]').last());
                        ScrollDown();

                        if ((response.messages + '').includes('MyMessage')) {
                            $('#sound')[0].play();
                        }
                    }

                    setTimeout(LoadMessages, timeout);
                }
            }
        });
    }

    function Resize() {
        //resize chat body

        let fullHeight = window.innerHeight;
        let headerHeidgt = $('.navbar').height();
        let topChatHeigh = $('.HeaderBody').height();
        let bottomChatHeight = $('.TypeBody').height();
        let bottomPageHeight = $('.main-footer').height();

        let bodyHeight = fullHeight - headerHeidgt - topChatHeigh - bottomChatHeight - bottomPageHeight * 3 - 70;

        $('.ChatBody').height(bodyHeight + 'px');
    }

    function ScrollDown() {
        //scrolling down page
        $(".ChatBody").animate({ scrollTop: $(".ChatBody").prop("scrollHeight") }, 500);
    }

    //when window resize - resize chat
    window.onresize = () => { Resize(); };

    //show attached file name
    $("#FileInput").change(() => {
        $('#attachementName').text(document.getElementById("FileInput").files[0].name);
        $('#attachementNameContainer').slideDown('fast');
        setTimeout(Resize, 250);
    });

    function SimpleText() {
        //type only text
        $.ajax({
            type: "POST",
            url: `/PersonalArea/Service/Issues/Chat/${$('#issueID').text()}/TypeMessage/?Message=${encodeURIComponent($('#issueMessage').val())}`,
            success: function (response) {
                if (response !== null) {
                    $('#issueMessage').val('');
                    $('#TypeBody').removeClass('disDiv');
                }
            }
        });
    }

    function TextWithFile(file) {
        //type text plus file

        ShowSpinner(true);

        var formData = new FormData();
        formData.append(file.name, file);
        formData.append('Message', $('#issueMessage').val());

        $.ajax({
            type: 'POST',
            async: true,
            url: `/PersonalArea/Service/Issues/Chat/${$('#issueID').text()}/TypeMessagePlus`,
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            error: function (jqxhr, status, errorThrown) {
                console.log('jqxhr:');
                console.log(jqxhr);
                console.log('status:');
                console.log(status);
                console.log('errorThrown:');
                console.log(errorThrown);

            },
            success: function (response) {
                ShowSpinner(false);
                $('#FileInput').val('');
                $('#issueMessage').val('');
                $('#TypeBody').removeClass('disDiv');
                $('#attachementNameContainer').slideUp('fast');
                setTimeout(Resize, 250);
                if (response.success !== true) {
                    $('#uploadError').text(response.msg);
                    $('#modalUploadError').modal('show');
                }
            }
        });
    }

    //send message
    $('#SendMsg').on('click', () => {
        $('#TypeBody').addClass('disDiv');

        let e = document.getElementById('FileInput');

        if (e !== null) {
            let file = document.getElementById("FileInput").files[0];

            if (file) { TextWithFile(file); }
            else { SimpleText(); }

        }
        else { SimpleText(); }
    });

    //open dialog for select file
    $('#AddAttachment').on('click', () => {
        $('#FileInput').val('');
        $('#FileInput').click();
    });

    //unattach file
    $('#deleteAttachment').on('click', () => {
        $('#FileInput').val('');
        $('#attachementNameContainer').slideUp('fast');
        setTimeout(Resize, 250);
    });

    //confirm close issue
    $('#ConfirmCloseIssue').on('click', () => {
        $.ajax({
            type: "POST",
            url: `/PersonalArea/Service/Issues/Chat/${$('#issueID').text()}/Close/?Reason=${encodeURIComponent($('#closeReason').val())}`,
            success: function (response) {
                if (response !== null && response.success === true) {
                    location.reload();
                }
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //show modal for close issue
    $('#btnClose').on('click', () => {
        $('#closeReason').val('');
        $('#closeError').hide();
        $('#ConfirmCloseIssue').prop('disabled', false);
        $('#CloseWithoutComment').prop('checked', true);
        $('#CloseReasonSection').hide();
        $('#modalCloseIssue').modal('show');
    });

    //show error when close reason is empty
    $('#closeReason').on('input', function () {

        if ($('#CloseWithoutComment').prop('checked') === true) {
            $('#ConfirmCloseIssue').attr('disabled', false);
            return;
        }

        if (!$(this).val() || !$(this).val().trim()) {
            $('#closeError').slideDown('fast');
            $('#ConfirmCloseIssue').attr('disabled', true);
        }
        else {
            $('#closeError').slideUp('fast');
            $('#ConfirmCloseIssue').attr('disabled', false);
        }
    });

    //show/hide comment section
    $('#CloseWithoutComment').change(() => {
        if ($('#CloseWithoutComment').prop('checked') === true) {
            $('#ConfirmCloseIssue').attr('disabled', false);
            $('#closeReason').val('');
            $('#CloseReasonSection').slideUp('fast');
            $('#closeError').slideUp('fast');
        }
        else {
            $('#ConfirmCloseIssue').attr('disabled', true);
            $('#closeReason').val('');
            $('#CloseReasonSection').slideDown('fast');
        }
    });

    Resize();
    ScrollDown();

    if ($('#closed').val() * 1 !== 1)
        setTimeout(LoadMessages, timeout);
});