﻿$(document).ready(() => {
    let selectedRate = [];
    let selectedRateForMulti = [];

    function Export(t) {
        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");

        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/ServiceRate/Export/' + $('#RatePlane option:selected').val() + '/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success  === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/ServiceRate/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }

                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function RemoveFromArray(array, element) {
        //remove element form array
        const index = array.indexOf(element);

        if (index !== -1) {
            array.splice(index, 1);
        }
    }

    function UpdateRateButtonsUI() {
        if (selectedRate.length  === 0) {
            $("#btnEdit").attr("disabled", true);
            $("#btnCopy").attr("disabled", true);
            $("#btnCopyFrom").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
            $("#btnClean").attr("disabled", true);
            $("#btnMultiply").attr("disabled", true);
        }
        else if (selectedRate.length  === 1) {
            $("#btnEdit").attr("disabled", $('#RatePlane option:selected').val()  === 0);
            $("#btnCopy").attr("disabled", $('#RatePlane option:selected').val()  === 0);
            $("#btnCopyFrom").attr("disabled", $('#RatePlane option:selected').val()  === 0);
            $("#btnDelete").attr("disabled", $('#RatePlane option:selected').val()  === 0);
            $("#btnClean").attr("disabled", false);
            $("#btnMultiply").attr("disabled", $('#RatePlane option:selected').val()  === 0);
        }
        else {
            $("#btnCopy").attr("disabled", true);
            $("#btnEdit").attr("disabled", $('#RatePlane option:selected').val()  === 0);
            $("#btnCopyFrom").attr("disabled", $('#RatePlane option:selected').val()  === 0);
            $("#btnDelete").attr("disabled", $('#RatePlane option:selected').val()  === 0);
            $("#btnClean").attr("disabled", false);
            $("#btnMultiply").attr("disabled", $('#RatePlane option:selected').val()  === 0);
        }

        //disable add if concret plane not selected
        $("#btnAdd").attr("disabled", $('#RatePlane option:selected').val() * 1 === 0);
    }

    function AttachEventsToTableWithRates() {
        /*table events*/
        $('#tableWithRates tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                if ($('#multiselect').is(':checked')) {
                    RemoveFromArray(selectedRate, $(this).find('td[data-name="ID"]').text());
                    RemoveFromArray(selectedRateForMulti, $(this).find('td[data-name="SettingsID"]').text());
                }
                else {
                    selectedRate = [];
                    selectedRateForMulti = [];
                }
            }
            else {
                if (!$('#multiselect').is(':checked')) {
                    selectedRate = [];
                    selectedRateForMulti = [];
                    $('#tableWithRates tr.selected').removeClass('selected');
                }
                selectedRateForMulti.push($(this).find('td[data-name="SettingsID"]').text());
                selectedRate.push($(this).find('td[data-name="ID"]').text());
                $(this).addClass('selected');
            }
            UpdateRateButtonsUI();
        });

        UpdateRateButtonsUI();

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/ServiceRate/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        UpdateTableWithRates($('#tbSearch').val());
                    }
                }
            });
        });
    }

    function UpdateTableWithRates(e) {
        //load table by search string
        $('#rtTable').load('/ServiceRate/Get/' + $('#RatePlane option:selected').val() + '/?Search=' + encodeURIComponent(e), AttachEventsToTableWithRates);
    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            UpdateTableWithRates($('#tbSearch').val());
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //when select other plane load rates for other
    $('#RatePlane').change(function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ServiceRate/SaveSelectedRate/' + $('#RatePlane option:selected').val(),
            traditional: true
        });
        UpdateTableWithRates($('#tbSearch').val());
        selectedRate = [];
        UpdateRateButtonsUI();
    });

    //save state of multiselect option to cockie
    $('#switchMultiselect').on('click', function () {

        var state = !$('#multiselect').is(':checked') ? 'checked' : 'e';

        $.ajax({
            type: "POST",
            async: true,
            url: '/ServiceRate/SaveMultiselectState/?state=' + state,
            traditional: true
        });
    });

    //save state of show all dates
    $('#switchShowAllDates').on('click', function () {

        var state = !$('#ShowAllDates').is(':checked') ? 'checked' : 'e';

        $.ajax({
            type: "POST",
            async: true,
            url: '/ServiceRate/SaveShowAllDates/?state=' + state,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success  === true) {
                    UpdateTableWithRates($('#tbSearch').val());
                }
            }
        });
    });

    /*attach events for select column*/
    $('#MenuSelectColumn input').on('click', function (event) {
        var visible = $(event.target).prop('checked');
        var colName = $(event.target).attr('data-value');

        $.ajax({
            type: "POST",
            url: '/ServiceRate/SetTableColumnVisability/?colName=' + colName + "&visible=" + visible,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success  === true) {
                    //reload
                    selectedRate = [];
                    UpdateTableWithRates($('#tbSearch').val());
                    UpdateRateButtonsUI();
                }
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //show modal for copy rate from other plane
    $('#btn-tools').on('click', 'button[data-name="CopyFrom"]', function () {
        $('#RatePlaneCopyFrom').val($('#RatePlaneCopyFrom option:first').val());
        $('#confirmCopyFrom').modal('show');
    });

    //confirm copy to other plane
    $('#RateCopyFrom').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ServiceRate/CopyTo/' + $('#RatePlane option:selected').val() + '/' + $('#RatePlaneCopyFrom option:selected').val() + '/?ids=' + selectedRate.toString(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success  === true) {
                    UpdateTableWithRates($('#tbSearch').val());
                    selectedRate = [];
                    UpdateRateButtonsUI();
                    $('#confirmCopyFrom').modal('hide');
                }
            }
        });
    });

    // disable button for multiply when factor empty
    $('#multiFactor').on('input', function (e) {
        $('#RateMulty').attr('disabled', $('#multiFactor').val() === '');
    });

    //show modal for multiply selected rate
    $('#btn-tools').on('click', 'button[data-name="Multiply"]', function () {
        $('#multiFactor').val('0');
        $('#confirmMultiply').modal('show');
    });

    //confirm multiply rates
    $('#RateMulty').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ServiceRate/Multiply/' + $('#RatePlane option:selected').val() + '/' + $('#multiFactor').val() + '/?ids=' + selectedRate.toString(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success  === true) {
                    UpdateTableWithRates($('#tbSearch').val());
                    selectedRate = [];
                    UpdateRateButtonsUI();
                    $('#confirmMultiply').modal('hide');
                }
            }
        });
    });

    //show modal for clean selected rate
    $('#btn-tools').on('click', 'button[data-name="Clean"]', function () {
        $('#confirmClear').modal('show');
    });

    //confirm clear last settings
    $('#RateClear').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ServiceRate/CleanRate/' + $('#RatePlane option:selected').val() + '/?ids=' + selectedRate.toString(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success  === true) {
                    UpdateTableWithRates($('#tbSearch').val());
                    selectedRate = [];
                    UpdateRateButtonsUI();
                    $('#confirmClear').modal('hide');
                }
            }
        });
    });

    //show modal for delete selected rate
    $('#btn-tools').on('click', 'button[data-name="Delete"]', function () {
        $('#confirmDelete').modal('show');
    });

    //confirm remove plane
    $('#PlaneDelete').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ServiceRate/DeletePlane/?ids=' + selectedRate.toString(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success  === true) {
                    UpdateTableWithRates($('#tbSearch').val());
                    selectedRate = [];
                    UpdateRateButtonsUI();
                    $('#confirmDelete').modal('hide');
                }
            }
        });
    });

    //confirm remove rate
    $('#RateDelete').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ServiceRate/DeleteRate/' + $('#RatePlane option:selected').val() + '/?ids=' + selectedRate.toString(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success  === true) {
                    UpdateTableWithRates($('#tbSearch').val());
                    selectedRate = [];
                    UpdateRateButtonsUI();
                    $('#confirmDelete').modal('hide');
                }
            }
        });
    });

    //show modal add new rate
    $('#btn-tools').on('click', 'button[data-name="Add"]', function () {
        window.open('/ServiceRate/AddRate/' + $('#RatePlane').val(), '_parent');
    });

    //show modal add new rate
    $('#btn-tools').on('click', 'button[data-name="Edit"]', function () {
        if (selectedRate.length > 1) {
            if ($('#ShowAllDates').is(':checked'))//show multi edit preview
                window.open('/ServiceRate/MultiEditRate/' + $('#RatePlane').val() + '/?ids=' + selectedRateForMulti.toString(), '_parent');
            else//show error
                $('#messageModal').modal('show');
        }
        else//show single edit preview
            window.open('/ServiceRate/EditRate/' + $('#RatePlane').val() + '/' + selectedRate[0], '_parent');
    });

    //show modal for add new cope of selected
    $('#btn-tools').on('click', 'button[data-name="Copy"]', function () {
        window.open('/ServiceRate/CopyRate/' + $('#RatePlane').val() + '/' + selectedRate[0], '_parent');
    });

    UpdateTableWithRates('');
});