﻿$(document).ready(() => {
    let selectedABPlans = [];

    function initdatetimepickers() {
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),
            locale: $('#LocaleThread').val(),
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true,
            format: 'L'
        };

        $('#datetimepickerFromABPlan').datetimepicker(options);
    }

    function RemoveFromArray(array, element) {
        //remove element form array
        const index = array.indexOf(element);

        if (index !== -1) {
            array.splice(index, 1);
        }
    }

    function UpdateABPlansButtonUI() {
        if (selectedABPlans.length === 0) {
            $('#btnEditabplan').prop('disabled', true);
            $('#btnDeleteabplan').prop('disabled', true);
        }
        else if (selectedABPlans.length === 1) {
            $('#btnEditabplan').prop('disabled', false);
            $('#btnDeleteabplan').prop('disabled', false);
        }
        else {
            $('#btnEditabplan').prop('disabled', true);

            $('#btnDeleteabplan').prop('disabled', false);
        }
    }

    function AttachEventsToABPlans() {
        var header = document.getElementById("PlansHead");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        selectedABPlans = [];

        $('#tariscope-plan tbody').on('click', 'tr', function (e) {
            if (e.shiftKey) {//select via shift
                var newIndex = $(this).index();

                var table = $('#tariscope-plan');

                //init first row
                if (rowIndex === null)
                    rowIndex = $(this).index();

                tempIndex = rowIndex;

                //clear prev selected
                selectedABPlans = [];

                $('#tariscope-plan tr.selected').removeClass('selected');

                var direction = newIndex >= rowIndex;

                if (direction) {//select down
                    while (tempIndex <= newIndex) {
                        tempIndex += 1;

                        var tr = $('tr:eq(' + tempIndex + ')', table);

                        if (tr.css('display') !== 'none') {
                            tr.addClass('selected');
                            RemoveFromArray(selectedABPlans, tr.find('td[data-name="ID"]').text());
                            selectedABPlans.push(tr.find('td[data-name="ID"]').text());
                        }
                    }
                }
                else {//select up
                    while (tempIndex > (newIndex - 1)) {
                        var tr2 = $('tr:eq(' + (tempIndex + 1) + ')', table);

                        if (tr2.css('display') !== 'none') {
                            tr2.addClass('selected');
                            RemoveFromArray(selectedABPlans, tr2.find('td[data-name="ID"]').text());
                            selectedABPlans.push(tr2.find('td[data-name="ID"]').text());
                        }

                        tempIndex -= 1;
                    }
                }
            }
            else {//single select
                rowIndex = $(this).index();

                selectedABPlans = [];

                if ($(this).hasClass('selected')) {
                    $('#tariscope-plan tr.selected').removeClass('selected');
                }
                else {
                    $('#tariscope-plan tr.selected').removeClass('selected');
                    selectedABPlans.push($(this).find('td[data-name="ID"]').text());
                    $(this).addClass('selected');
                }
            }

            UpdateABPlansButtonUI();
        });

        UpdateABPlansButtonUI();
    }

    function LoadABPlans() {
        $('#plansTable').load('/Subscribers/GetAbonentPlans/' + $('#AbonentID').val(), AttachEventsToABPlans);
    }

    //back to abonent
    $('#btnBackToAbonentFromABPlans').on('click', () => {
        $('#additionalSection').slideUp('fast');
        $('#editSection').slideDown('fast');

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetRateName/' + $('#AbonentID').val(),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#AbonentCurrentPlan').val(response.name);
                }
            }
        });
    });

    //show modal to add a new plan
    $('#btnAddabplan').on('click', () => {
        $('#saveABPlanbtn').unbind();
        $('#editABPlantitle').text($('#newABPlanTitle').val());
        $('#datetimepickerFromABPlan').data("DateTimePicker").setDate(new Date());

        //add plan
        $('#saveABPlanbtn').on('click', () => {
            $('#editABPlanmodal').modal('hide');
            ShowSpinner(true);

            var formData = new FormData();
            formData.append('from', $('#datetimepickerFromABPlan').data('date'));
            formData.append('plan', $('#abPlane').val());

            $.ajax({
                type: 'POST',
                async: true,
                url: '/Subscribers/AddAbonentPlan/' + $('#AbonentID').val(),
                data: formData,
                datatype: 'application/octet-stream',
                contentType: false,
                processData: false,
                traditional: true,
                success: function (response) {
                    ShowSpinner(false);
                    LoadABPlans();
                }
            });
        });

        $('#editABPlanmodal').modal('show');
    });

    //show modal for delete abonent plan
    $('#btnDeleteabplan').on('click', () => {
        $('#deleteAbonentabplanConfirm').prop('disabled', false);
        $('#deleteAbonentabplan').modal('show');
    });

    //confirm delete dn
    $('#deleteAbonentabplanConfirm').on('click', () => {
        $('#deleteAbonentabplan').modal('hide');
        ShowSpinner(true);

        $.ajax({
            method: 'POST',
            data: { ids: selectedABPlans },
            dataType: "json",
            url: '/Subscribers/DeleteAbonentPlan/',
            success: function (response) {
                ShowSpinner(false);
                LoadABPlans();
            }
        });
    });

    //show modal for edit plan
    $('#btnEditabplan').on('click', () => {
        $('#saveABPlanbtn').unbind();
        $('#editABPlantitle').text($('#editABPlanTitle').val());

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetAbonentPlan/' + $('#AbonentID').val() + '/' + selectedABPlans[0],
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#abPlane').val(response.plan);
                    $('#datetimepickerFromABPlan').data("DateTimePicker").setDate(new Date(response.from));

                    //update plan
                    $('#saveABPlanbtn').on('click', () => {
                        $('#editABPlanmodal').modal('hide');
                        ShowSpinner(true);

                        var formData = new FormData();
                        formData.append('from', $('#datetimepickerFromABPlan').data('date'));
                        formData.append('plan', $('#abPlane').val());

                        $.ajax({
                            type: 'POST',
                            async: true,
                            url: '/Subscribers/UpdateAbonentPlan/' + selectedABPlans[0],
                            data: formData,
                            datatype: 'application/octet-stream',
                            contentType: false,
                            processData: false,
                            traditional: true,
                            success: function (response) {
                                if (response !== null && response.success === true) {
                                    ShowSpinner(false);
                                    LoadABPlans();
                                }
                            }
                        });
                    });

                    $('#editABPlanmodal').modal('show');
                }
            }
        });
    });

    LoadABPlans();
    initdatetimepickers();
});

