﻿$(document).ready(() => {
    var selectedCategory = null;
    var collaps = null;

    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/Categories/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/Categories/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function UpdateButtons() {
        if (selectedCategory === null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
        }
    }

    function ExpandParent(el) {
        let node = $(el).treegrid('getParentNode');
        if (node !== null) {
            $(node).treegrid('expand');
            ExpandParent(node);
        }
    }

    function AttachEventsToTable() {
        $('#tariscope-ctgrs tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedCategory = null;
            }
            else {
                selectedCategory = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-ctgrs tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtons();
        });
        UpdateButtons();

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/Categories/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        LoadUsers($('#tbSearch').val());
                    }
                }
            });
        });

        if (collaps !== null) {
            let el = $('.treegrid-' + collaps);
            try { el.treegrid('expand'); } catch (e) { console.log(e); } 
            ExpandParent(el);
            collaps = null;
        }
    }

    function LoadUsers(e) {
        selectedCategory = null;
        $('#categoriesTable').load('/Categories/Get/?search=' + encodeURIComponent(e), AttachEventsToTable);
    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            LoadUsers($('#tbSearch').val());
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //open modal for delete category
    $('#btnDelete').on('click', () => { $('#confirmDelete').modal('show'); });

    //confirm deleting category
    $('#DeleteConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Categories/Delete/' + selectedCategory,
            traditional: true,
            success: function (response) {
                $('#confirmDelete').modal('hide');
                ShowSpinner(false);
                if (response !== null && response.success === true) {
                    if (!$('#tbSearch').val()) {
                        collaps = response.id;
                    }
                    LoadUsers($('#tbSearch').val());
                }
                else {
                    $('#CannotDeleteModal').modal('show');
                }
            }
        });
    });

    //Open modal for add category
    $('#btnAdd').on('click', () => {
        $('#titleEdit').hide();
        $('#titleAdd').show();
        $('#emptyName').hide();

        $('#categoryID').val('0');
        $('#categoryName').val('');
        $('#categoryDescription').val('');

        $('#saveCategory').prop('disabled', true);

        $('#editCategory').modal('show');
    });

    //show error when empty category name
    $('#categoryName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyName').slideDown('fast');
            $('#saveCategory').prop('disabled', true);
        }
        else {
            $('#emptyName').slideUp('fast');
            $('#saveCategory').prop('disabled', false);
        }
    });

    //save category
    $('#saveCategory').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Categories/Save/' + $('#categoryID').val() + '/' + (selectedCategory === null ? 0 : selectedCategory) + '/?Name=' + encodeURIComponent($('#categoryName').val()) + '&Description=' + encodeURIComponent($('#categoryDescription').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    if (!$('#tbSearch').val()) {
                        collaps = response.id;
                    }

                    $('#editCategory').modal('hide');
                    LoadUsers($('#tbSearch').val());
                }
            }
        });
    });

    //show modal for edit category
    $('#btnEdit').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Categories/GetCategory/' + selectedCategory,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#titleEdit').show();
                    $('#titleAdd').hide();
                    $('#emptyName').hide();

                    $('#categoryID').val(response.model.ID);
                    $('#categoryName').val(response.model.Name);
                    $('#ctgName').text(response.model.Name);
                    $('#categoryDescription').val(response.model.Description);

                    $('#saveCategory').prop('disabled', false);

                    $('#editCategory').modal('show');
                }
            }
        });
    });

    LoadUsers('');
});