﻿$(document).ready(function () {

    var selectedServicesID = null;
    var selectedServicesHistoryID = null;

    function Export(t) {
        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/CustomerServices/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/CustomerServices/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function UpdateCurrentFeeAmount() {
        $.ajax({
            type: "POST",
            url: '/CustomerServices/GetCurrentFeeAmount/' + $('#serviceForEdit').val(),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#currentFeeAmount').html(response.fee);
                }
            }
        });
    }

    function DisableIfIsAuto() {
        /*disable fields if service is auto*/
        if ($("#listPeriod option:selected").first().val() == -3) {
            $('#currencyGroup').addClass('disDiv');
            $('#feeGroup').addClass('disDiv');
            $('#nameGroup').addClass('disDiv');
            $('#periodGroup').addClass('disDiv');
            $('#tarifsGroupd').addClass('disDiv');
            //$('#othersGroup').addClass('disDiv');
        }

        if ($('#listPeriod').val() == 1) {
            $('#UseDateModifiersSection').removeClass('disDiv');
        }
        else {
            $('#UseDateModifiersSection').addClass('disDiv');
            $('#UseDateModifiers').prop('checked', false);
        }
    }

    function DisableFeeFields() {
        /*disable or enable fee amount fields*/
        if ($("#tarifsList option:selected").first().val() != 1) {
            $('#currencyGroup').addClass('disDiv');
            $('#feeGroup').addClass('disDiv');
        }
        else {
            $('#currencyGroup').removeClass('disDiv');
            $('#feeGroup').removeClass('disDiv');
        }
    }

    function ShowRenameServiceModal() {
        /*attach event to text box with name*/
        /*show alert message when name is empty*/
        $('#renameServiceName').on('input', function (e) {
            if ($('#renameServiceName').val() == "") {
                $('#emptyRename').attr('hidden', false);
                $('#modalButtonRename').attr('disabled', true);
            }
            else {
                $('#emptyRename').attr('hidden', true);
                $('#modalButtonRename').attr('disabled', false);
            }
        });

        /*showing rename modal dialog*/
        $.ajax({
            type: "POST",
            url: '/CustomerServices/GetServiceName/' + selectedServicesID,
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#emptyRename').attr('hidden', true);
                    $('#modalButtonRename').attr('disabled', false);
                    $('#renameServiceName').val(response.Name);
                    $('#renameServicemodal').modal('show');
                }
            }
        });
    }

    function RenameService() {
        /*renaming service and update table with services*/
        $.ajax({
            type: "POST",
            url: '/CustomerServices/RenameService/?id=' + selectedServicesID + '&newName=' + encodeURIComponent($('#renameServiceName').val()),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    UpdateTable($('#tbSearch').val());
                    $('#renameServicemodal').modal('hide');
                }
            }
        });
    }

    function DeleteService() {
        /*deleting service and update table with services*/
        $.ajax({
            type: "POST",
            url: '/CustomerServices/DeleteService/' + selectedServicesID,
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    UpdateTable($('#tbSearch').val());
                    $('#confirmDelete').modal('hide');
                }
                else {
                    $('#cannotDelete').attr('hidden', false);
                }
            }
        });
    }

    function UpdateMainButtonsUI() {
        /*update ui for buttons when not selected any service some buttons disabled*/
        if (selectedServicesID == null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
            $("#btnRename").attr("disabled", true);
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
            $("#btnRename").attr("disabled", false);
        }
    }

    function LoadTable() {
        /*first load table*/

        /*attach input event to search textbox*/
        var typingTimer;                //timer identifier
        var doneTypingInterval = 750;  //time in ms, 0.75 second for example
        var $input = $('#tbSearch');

        //on keyup, start the countdown
        $input.on('keyup', function () {
            clearTimeout(typingTimer);
            typingTimer = setTimeout(function () {
                UpdateTable($('#tbSearch').val());
            }, doneTypingInterval);
        });
        //on keydown, clear the countdown
        $input.on('keydown', function () { clearTimeout(typingTimer); });

        /*attach event to checkboxes for select column for displaying*/
        $('#MenuSelectColumn input').on('click', function (event) {

            var visible = $(event.target).prop('checked');
            var colName = $(event.target).attr('data-value');

            $.ajax({
                type: "POST",
                url: '/CustomerServices/SetTableColumnVisability?colName=' + colName + "&visible=" + visible,
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        selectedServicesID = null;
                        UpdateMainButtonsUI();
                        $('#servicesTable').load(encodeURI('/CustomerServices/Search/?s=' + $('#tbSearch').val()), AttachEventsMainTable);
                    }
                }
            });
        });

        /*load table with services*/
        $('#servicesTable').load('/CustomerServices/Search/', AttachEventsMainTable);

        /*attach event to Rename button*/
        $('#btn-tools').on('click', 'button[data-name="Rename"]', ShowRenameServiceModal);

        /*attach event to delete button*/
        $('#modalButtonRename').on('click', RenameService);

        /*attach events for deleting service*/
        $('#btn-tools').on('click', 'button[data-name="Delete"]', function () {
            $('#cannotDelete').attr('hidden', true);
            $('#confirmDelete').modal('show');
        });
        $('#DeleteConfirm').on('click', DeleteService);

        /*attach event to Add button*/
        $('#btn-tools').on('click', 'button[data-name="Add"]', function () {
            /*show load msg*/
            ShowSpinner(true);
            $('#ServicesPreview').load('/CustomerServices/AddServices/', AttachEventsOnEdit);
        });

        /*attach event to Edit button*/
        $('#btn-tools').on('click', 'button[data-name="Edit"]', function () {
            /*show load msg*/
            ShowSpinner(true);
            $('#ServicesPreview').load('/CustomerServices/EditServices/' + selectedServicesID, AttachEventsOnEdit);
        });

        /*The event is attached to the btnImport button*/
        $('#btnImport').on('click', () => { window.open('/CustomerServices/FromFile', '_parent'); });
    }

    function UpdateTable(e) {
        /*update table by search string*/
        $('#servicesTable').load(encodeURI('/CustomerServices/Search/?s=' + e), AttachEventsMainTable);
    }

    function ClickRow(e) {
        if (e.hasClass('selected')) {
            e.removeClass('selected');
            selectedServicesID = null;
        }
        else {
            selectedServicesID = e.find('td[data-name="ID"]').text();
            $('#tariscope-services tr.selected').removeClass('selected');
            e.addClass('selected');
        }

        UpdateMainButtonsUI();
    }

    function AttachEventsMainTable() {
        var header = document.getElementById("servicesHead");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        /*table events*/
        $('#tariscope-services tbody').on('click', 'tr', function () { ClickRow($(this)); });
        $('#tariscope-services tbody').on('dblclick', 'tr', function () {
            ClickRow($(this));
            if (selectedServicesID != null)
                $('#btnEdit').click();
        });

        /*attach events for export*/
        $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
        $('#ExportHTML').on('click', function () { Export("html"); });
        $('#ExportCSV').on('click', function () { Export("csv"); });
        $('#ExportPDF').on('click', function () { Export("pdf"); });

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/CustomerServices/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        UpdateTable($('#tbSearch').val());
                    }
                }
            });
        });
    }

    function UpdateHistoryButtonsUI() {
        /*update ui for buttons when not selected any service history some buttons disabled*/
        if (selectedServicesHistoryID == null) {
            $("#btnEdit-History").attr("disabled", true);
            $("#btnDelete-History").attr("disabled", true);
        }
        else {
            $("#btnEdit-History").attr("disabled", false);
            $("#btnDelete-History").attr("disabled", false);
        }
    }

    function AttachEventsHistoryTable() {
        /*table events*/
        $('#tariscope-service-history tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedServicesHistoryID = null;
            }
            else {
                selectedServicesHistoryID = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-service-history tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }
            UpdateHistoryButtonsUI();
        });

        //update fee amount
        UpdateCurrentFeeAmount();
    }

    function initDateTimePicker() {

        var dateNow = new Date();
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: navigator.language,
            locale: navigator.language,
            useCurrent: false
        };

        $('#datetimepicker').datetimepicker(options);
    }

    function LoadHistoryTable() {
        $('#historyTable').load('/CustomerServices/GetHistoryTable/' + $('#serviceForEdit').val(), AttachEventsHistoryTable);
    }

    function AttachEventsOnEdit() {
        $('#cancelEdit').on('click', LoadPreview);

        /*add history (open modal)*/
        $('#editHistoryToolButtons').on('click', 'button[data-name="Add"]', function () {
            $('#addModalHistoryHeader').attr('hidden', false);
            $('#editModalHistoryHeader').attr('hidden', true);

            try { $('#datetimepicker').data("DateTimePicker").setDate(moment(new Date()).format('DD/MM/YYYY')); } catch (e) { console.log(e); }

            $('#datetimepickerValue').val(new Date().toLocaleString());
            $('#HistoryItemID').val('0');
            $('#HistoryItemFeeAmount').val('0');

            $('#editHistoryModal').modal('show');
        });

        /*edit history (open modal)*/
        $('#editHistoryToolButtons').on('click', 'button[data-name="Edit"]', function () {
            $('#addModalHistoryHeader').attr('hidden', true);
            $('#editModalHistoryHeader').attr('hidden', false);

            $('#HistoryItemID').val(selectedServicesHistoryID);

            $.ajax({
                type: "POST",
                url: '/CustomerServices/GetHistoryItem/?ServiceID=' + $('#serviceForEdit').val() + '&ID=' + $('#HistoryItemID').val(),
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        /*try { $('#datetimepicker').data("DateTimePicker").setDate(response.FromDate); } catch (e) { console.log(e); } */
                        $('#datetimepickerValue').val(response.FromDate);
                        $('#HistoryItemFeeAmount').val(response.FeeAmount);
                        $('#editHistoryModal').modal('show');
                    }
                }
            });
        });

        /*delete history (open modal)*/
        $('#editHistoryToolButtons').on('click', 'button[data-name="Delete"]', function () {
            $('#HistoryItemID').val(selectedServicesHistoryID);
            $('#confirmDeleteHistory').modal('show');
        });

        /*add/edit history*/
        $('#btnAddEditHistory').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/CustomerServices/EditHistoryItem/?ServiceID=' + $('#serviceForEdit').val() + '&ID=' + $('#HistoryItemID').val() + '&Fee=' + $('#HistoryItemFeeAmount').val() + '&Date=' + $('#datetimepickerValue').val(),
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        LoadHistoryTable();
                        selectedServicesHistoryID = null;
                        UpdateHistoryButtonsUI();
                        $('#editHistoryModal').modal('hide');
                    }
                }
            });
        });

        /*delete history*/
        $('#DeleteConfirmHistory').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/CustomerServices/DeleteHistoryItem/?ServiceID=' + $('#serviceForEdit').val() + '&ID=' + $('#HistoryItemID').val(),
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        LoadHistoryTable();
                        selectedServicesHistoryID = null;
                        UpdateHistoryButtonsUI();
                        $('#confirmDeleteHistory').modal('hide');
                    }
                }
            });
        });

        //submit button
        $('#SubmitButton').on('click', () => {
            if (!$('#serviceName').val() || !$('#serviceName').val().trim()) {
                $('#emptyModal').modal('show');
                return;
            }

            ShowSpinner(true);

            setTimeout(() => {
                $("input[id^=TAX]:checkbox:not(:checked)").parents('tr').remove();
                $("input[name^=TAX][type=hidden][value=false]").remove();
                $('#SubmitButton').parents('form')[0].submit();
            }, 250);
        });

        //change rate id
        $('#tarifsList').change(DisableFeeFields);

        //change period of service
        $('#listPeriod').change(() => {
            if ($('#listPeriod').val() == 1) {
                $('#UseDateModifiersSection').removeClass('disDiv');
            }
            else {
                $('#UseDateModifiersSection').addClass('disDiv');
                $('#UseDateModifiers').prop('checked', false);
            }
        });

        LoadHistoryTable();         //load fee amount history
        initDateTimePicker();       //init datetimepicker
        DisableFeeFields();         //disable fee amount field if tarif is not fixed
        DisableIfIsAuto();          //disable some fields if service is auto
        UpdateCurrentFeeAmount();   //load current fee amount

        /*hide load msg*/
        ShowSpinner(false);
    }

    function LoadPreview() {
        /*load preview*/
        $('#ServicesPreview').load('/CustomerServices/GetPreview/', LoadTable);
    }

    //load index preview with table with services
    LoadPreview();
});