#!/bin/bash

#/etc/systemd/system
output="/etc/systemd/system/TS.MAIN.service"

echo "[Unit]" >> $output
echo "Description=Tariscope daemon" >> $output
echo "[Service]" >> $output
echo "WorkingDirectory=$PWD" >> $output
echo "ExecStart=/usr/bin/dotnet $PWD/SoftPi.Tariscope.WebAdministration.dll" >> $output
echo "Restart=always" >> $output
echo "RestartSec=10" >> $output
echo "KillSignal=SIGINT" >> $output
echo "SyslogIdentifier=$service" >> $output
echo "User=root" >> $output
echo "Environment=ASPNETCORE_ENVIRONMENT=Production" >> $output
echo "Environment=DOTNET_PRINT_TELEMETRY_MESSAGE=false" >> $output
echo "[Install]" >> $output
echo "WantedBy=multi-user.target" >> $output

sudo systemctl daemon-reload
sudo service TS.MAIN start
