﻿$(document).ready(()=>{

    var availableCultures = {
        "GB": "en-US",
        "DE": "de-DE",
        "UA": "uk-UA",
        "RU": "ru-RU"
    }

    var availableCultureTitles = {
        "GB": "English",
        "DE": "Germany",
        "UA": "Українська",
        "RU": "Русский"
    }

    function clarifyCulture(culture) {
        return availableCultures[culture];
    }

    $('#flagstrap').first().data('selected-country', $.cookie('culture').substring(3));

    $('#flagstrap').flagStrap({
        countries: availableCultureTitles,
        inputName: 'country',
        buttonSize: "btn-md",
        buttonType: "btn-link",
        labelMargin: "5px",
        placeholder: false,
        scrollable: false,
        scrollableHeight: "250px",
        onSelect: function (value, element) {

            var culture = clarifyCulture(value);
            console.log("value = " + value);
            console.log("element =" + element);
            $.ajax({
                type: "POST",
                url: '/culture/changeculture/?culture=' + culture,
                success: (data, textStatus, xhr) => {
                    if (xhr.status == 200)
                        location.reload();
                }
            });
        }
    });

});