﻿$(document).ready(function () {
    function CheckAuthPanel() {
        //show or hide panel body for smtp auth info
        if ($('#NeedAuth').prop('checked'))
            $('#NeedAuthPanelBody').slideDown('fast');
        else
            $('#NeedAuthPanelBody').slideUp('fast');
    }

    function ShowModalsForSaving(response) {
        //show modals for saveing #1
        if (response != null && response.success == true) {
            $('#pSuccess').text($('#msgSavedSuccess').val());
            $('#Successdmodal').modal('show');
        }
        else {
            $('#pError').text($('#msgSavedError').val());
            $('#Errordmodal').modal('show');
        }
    }

    function ShowModalsForSending(response) {
        //show modals for sending
        if (response != null && response.success == true) {
            $('#pSuccess').text($('#msgMailSuccess').val());
            $('#Successdmodal').modal('show');
        }
        else {
            $('#pError').text($('#msgMailError').val());
            $('#Errordmodal').modal('show');
        }

        $('#buttonsSection').removeClass('disDiv');
    }

    function GetUrl() {
        //get url arguments
        return '?SmtpServer=' + encodeURIComponent($('#smtpServer').val()) +
            '&SmtpPort=' + encodeURIComponent($('#smtpPort').val()) +
            '&NeedAuth=' + $('#NeedAuth').prop('checked') +
            '&UseTLS=' + $('#UseTLS').prop('checked') +
            '&UserName=' + encodeURIComponent($('#smtpLogin').val()) +
            '&Password=' + encodeURIComponent($('#smtpPassword').val()) +
            '&SenderAddress=' + encodeURIComponent($('#senderAddress').val()) +
            '&SenderName=' + encodeURIComponent($('#senderName').val()) +
            '&ToAddress=' + encodeURIComponent($('#mailDefAddress').val()) +
            '&Subject=' + encodeURIComponent($('#mailSubject').val()) +
            '&MessageTemplate=' + encodeURIComponent($('#mailText').val());
    }

    function SendAjax(url, modal) {
        //send url and show modals
        $.ajax({
            type: "POST",
            url: url + GetUrl(),
            async: true,
            success: function (response) {
                if (modal == 1)
                    ShowModalsForSaving(response);
                else
                    ShowModalsForSending(response);
            }
        });
    }

    function Save() {
        //send mail configuration to server
        SendAjax("NotificationsAndMailing/SaveProfile/", 1);
    }

    function SendTest() {
        //send test mail after saving configuration
        $('#buttonsSection').addClass('disDiv');
        SendAjax("NotificationsAndMailing/SendTestMail/", 2);
    }

    //show panel for auth smtp
    $('#NeedAuth').change(CheckAuthPanel);

    //click event for save button
    $('#btnSave').on('click', Save);

    //send test mail
    $('#btnSendTest').on('click', SendTest);

    CheckAuthPanel();
});