﻿(function ($) {
    $.tariscope = {};
    var dateTime = {};
    var table = {};
    var modal = {};
    var enums = {};

    $.tariscope.dateTime = dateTime;
    $.tariscope.table = table;
    $.tariscope.modal = modal;
    $.tariscope.enums = enums;

    /////////////////////Start DateTime//////////////////////////

    dateTime.getCurrentDate = function () {
        var today = new Date();
        var dd = today.getDate().toString();
        var date = dd.length != 1 ? dd : '0' + dd;
        var mm = (today.getMonth() + 1).toString();
        var month = mm.length != 1 ? mm : '0' + mm;
        var year = today.getFullYear();

        return year + '-' + month + '-' + date;
    };

    dateTime.ConvertToDate = function (str) {
        var date = new Date(str);
        var dd = date.getDate().toString();
        var day = dd.length != 1 ? dd : '0' + dd;
        var mm = (date.getMonth() + 1).toString();
        var month = mm.length != 1 ? mm : '0' + mm;
        var year = date.getFullYear();

        return year + '-' + month + '-' + day;
    };

    dateTime.ConvertToTime = function (str) {
        var date = new Date(str);
        var hh = date.getHours().toString();
        var hours = hh.length != 1 ? hh : '0' + hh;
        var mm = (date.getMinutes()).toString();
        var minutes = mm.length != 1 ? mm : '0' + mm;
        var ss = date.getSeconds().toString();
        var seconds = ss.length != 1 ? ss : '0' + ss;

        return hours + ':' + minutes + ':' + seconds;
    };

    dateTime.minDate = function () {
        return new Date("1900-01-01");
    };

    dateTime.maxDate = function () {
        return new Date("3000-01-01");
    };

    /////////////////////End DateTime//////////////////////////

    $.tariscope.isOnlyNumerics = function (str) {
        return str.match(/^\d+$/);
    };

    /////////////////////Start Table//////////////////////////

    table.sumColumnByDataName = function (name, tableId) {
        var sum = 0;
        $('#' + tableId + ' td[data-name="' + name + '"]').each(function () {
            var value = $(this).text();
            if (!isNaN(value) && value.length != 0) {
                sum += parseFloat(value);
            }
        });
        return Math.round(sum * 100) / 100;
    };

    /////////////////////End Table//////////////////////////

    /////////////////////Start Modal//////////////////////////
    modal.getWaitHtml = function () {
        return '<div class="wait" style="width:90px; height:96px;"></div>' +
              ' <h3 style="margin-top: 20px; color: #ffffff">Please wait</h3>' +
              '<button id="wait-dialog-close" class="btn btn-warning hidden" data-dismiss="modal" area-hidden="true"></button>'
    }

    /////////////////////End Modal//////////////////////////

    ////////////////////Start array extensions//////////////////////////
    Array.prototype.clean = function (deleteValue) {
        for (var i = 0; i < this.length; i++) {
            if (this[i] == deleteValue) {
                this.splice(i, 1);
                i--;
            }
        }
        return this;
    };
    ////////////////////End array extensions//////////////////////////


    ////////////////////Start enums///////////////////////////////////

    enums.EnumFilterPeriod = {
        'NoFilter': 0, 'Today': 1, 'Yesterday': 2, 'ThisWeek': 3,
        'PreviousWeek': 4, 'ThisMonth': 5, 'PreviousMonth': 6, 'ThisYear': 7,
        'PreviousYear': 8, 'CustomMonth': 9, 'CustomYear': 10, 'CustomPeriod': 11
    }

    ////////////////////End enums/////////////////////////////////////

})(jQuery);