﻿$(document).ready(() => {
    var append = false;
    var logID = null;
    var updateID = null;
    var UpdateLog = true;
    var focused = true;

    function ScrollDown() {
        //scrolling down page
        $("#LogContainer").animate({ scrollTop: $("#LogContainer")[0].scrollHeight }, 500);
    }

    function RefreshLog() {
        //refresh log
        append = false;
        $('#LogContainer').empty();
        ReadLog();
    }

    function ReadLog() {
        if (UpdateLog && focused)
            $.ajax({
                type: "POST",
                async: true,
                url: `/Logger/Read/${$('#LogSessionID').val()}/${$('#LogType').val()}/${$('#LogName').val()}/?Append=${append}`,
                success: function (response) {
                    if (response !== null && response.success === true) {

                        var items = 0;
                        response.lines.forEach(function (e) {
                            var item = $('<p class="logLine">' + e + '</p>');
                            $('#LogContainer').append($(item));
                            items++;
                        });

                        if (!append || items > 0)
                            ScrollDown();

                        append = true;

                        IsEmpty();
                        logID = setTimeout(ReadLog, 2000);
                    }
                }
            });

    }

    function IsEmpty() {
        if ($('#LogContainer').is(':empty')) {
            $('#EmptyAlert').show();
        }
        else {
            $('#EmptyAlert').hide();
        }
    }

    function SetHeight() {
        windowHeight = window.innerHeight -
            $('.main-header').outerHeight() -
            $('.content-header').outerHeight() -
            $('.box-header').outerHeight() -
            $('.main-footer').outerHeight();

        if (windowHeight < 400)
            windowHeight = 400;

        $('#LogContainer').css('max-height', windowHeight + 'px');
    }

    function RunSetHight() {
        SetHeight();
        setTimeout(RunSetHight, 1000);
    }

    function ExpandLeftMenu() {
        if ($('#LogType').val() == "Observer") {
            try {
                if (ObserversIsLoaded) {
                    ShowObservers('ObserverMenu', true);
                    ShowObserversContent('ObserverMenu_' + $('#LogName').val().replace(' ', '_'));
                }
                else {
                    setTimeout(ExpandLeftMenu, 200);
                }
            } catch (e) {
                setTimeout(ExpandLeftMenu, 200);
            }
        }
    }

    //refresh list
    $('#btn-tools').on('click', 'button[data-name="Refresh"]', function () {
        clearTimeout(logID);
        clearTimeout(updateID);
        updateID = setTimeout(RefreshLog, 1100);
    });

    //show modal for clear log
    $('#btn-tools').on('click', 'button[data-name="Clear"]', function () { $('#confirmClearLog').modal('show'); });

    //clear log file
    $('#btnClearLog').on('click', () => {
        $.ajax({
            type: "POST",
            url: `/Logger/Clear/${$('#LogType').val()}/${$('#LogName').val()}`,
            success: function (response) {
                if (response !== null && response.success === true) {
                    clearTimeout(logID);
                    append = false;
                    setTimeout(RefreshLog, 1100);
                    $('#confirmClearLog').modal('hide');
                }
            }
        });
    });

    //download
    $('#btnLogDownload').on('click', () => {
        window.open(`/Logger/Download/${$('#LogType').val()}/${$('#LogName').val()}`, '_blank');
    });

    //back from a log
    $('#btnBack').on('click', () => {
        history.go(-1);
        return false;
        location.reload(true);
    });

    //got focus
    document.addEventListener('visibilitychange', function (ev) {
        let old = focused;
        focused = document.visibilityState == 'visible';

        if (!old && focused) {
            ReadLog();
        }
        else {
            clearTimeout(logID);
        }
    });

    //log pause
    $('#btnLogPause').on('click', () => {
        UpdateLog = false;
        $('#btnLogPause').prop('disabled', true);
        $('#btnLogRun').prop('disabled', false);
    });

    //log play
    $('#btnLogRun').on('click', () => {
        UpdateLog = true;
        $('#btnLogPause').prop('disabled', false);
        $('#btnLogRun').prop('disabled', true);
        ReadLog();
    });

    //resize window
    $(window).resize(SetHeight);

    ReadLog();
    RunSetHight();
    ExpandLeftMenu();
});