#!/bin/bash 

while getopts p:s: flag
do
    case "${flag}" in
        p) profile=${OPTARG};;
        s) service=${OPTARG};;
    esac
done

#/etc/systemd/system
output="/etc/systemd/system/$service.service"

echo "hello2 $service" >> $output
echo $PWD >> $output

echo "[Unit]" > $output
echo "Description=Tariscope microservice daemon" >> $output
echo "[Service]" >> $output
echo "WorkingDirectory=$PWD" >> $output
echo "ExecStart=/usr/bin/dotnet $PWD/Tariscope.Observer.dll /name=$profile" >> $output
echo "Restart=always" >> $output
echo "RestartSec=10" >> $output
echo "KillSignal=SIGINT" >> $output
echo "SyslogIdentifier=$service" >> $output
echo "User=root" >> $output
echo "Environment=ASPNETCORE_ENVIRONMENT=Production" >> $output
echo "Environment=DOTNET_PRINT_TELEMETRY_MESSAGE=false" >> $output
echo "[Install]" >> $output
echo "WantedBy=multi-user.target" >> $output

sudo systemctl daemon-reload
sudo service $service start