﻿var backupSourceSQL = true;
var selectedFile = null;

function UpdateRestoreButtonsUI() {
    //update ui for restore backup buttons
    if (backupSourceSQL) {
        $("#btnIncludeSQL").attr("disabled", selectedFile === null);
        $("#btnExcludeSQL").attr("disabled", selectedFile === null);
        $("#btmMoveTopSQL").attr("disabled", selectedFile === null);
        $("#btnMoveDownSQL").attr("disabled", selectedFile === null);
    }

}

function UpdateRestoreButtonsUIPC() {
    //update ui for restore backup buttons
    if (backupSourceSQL === false) {
        $("#btnExcludePC").attr("disabled", selectedFile === null);
        $("#btmMoveTopPC").attr("disabled", selectedFile === null);
        $("#btnMoveDownPC").attr("disabled", selectedFile === null);
    }

}

function AttachEventsToTableWithBackups(e, r) {
    $('#tariscope-databasebackups-files tbody').on('click', 'tr', function () {
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
            selectedFile = null;
        }
        else {
            selectedFile = $(this).find('td[data-name="ID"]').text();
            $('#tariscope-databasebackups-files tr.selected').removeClass('selected');
            $(this).addClass('selected');
        }

        if (backupSourceSQL)
            UpdateRestoreButtonsUI();
        else
            UpdateRestoreButtonsUIPC();
    });

    if (r === true)
        selectedFile = null;
    else
        $($('#tariscope-databasebackups-files tbody tr[data-id="' + selectedFile + '"]')[0]).addClass('selected');

    if (backupSourceSQL)
        UpdateRestoreButtonsUI();
    else
        UpdateRestoreButtonsUIPC();
}

function LoadBackupFiles(e, r) {
    if (backupSourceSQL)
        $('#SQLBackupsContainer').load('/Database/GetTableWithBackups/?path=' + encodeURIComponent(e) + '&reload=' + r, function () { AttachEventsToTableWithBackups(e, r); });
    else
        $('#SQLBackupsContainerPC').load('/Database/GetTableWithBackupsPC/?reload=' + r, function () { AttachEventsToTableWithBackups(e, r); });;
}

function SetBackupSourceSQL(e) {
    backupSourceSQL = e;

    LoadBackupFiles($('#ServerBakLocation').val(), true);
}

$(document).ready(function () {
    var tableMode = true; //true - database info, false - proccesses

    function initDateTimepickers() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepickerFrom').datetimepicker(daytimeOpitions);
        $('#datetimepickerTo').datetimepicker(daytimeOpitions);
    }

    function initDateTimepickersDelete() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepickerFromDelete').datetimepicker(daytimeOpitions);
        $('#datetimepickerToDelete').datetimepicker(daytimeOpitions);
    }

    function initDateTimepickersRecharge() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepickerFromBGREcharge').datetimepicker(daytimeOpitions);
        $('#datetimepickerToBGREcharge').datetimepicker(daytimeOpitions);
    }

    function ShowSpinnerInfor(show) {
        /*
         * function for showing spinner message when load edit preview
         * sometimes it is to long
         */
        if (show) {
            $("#loadMeInformation").modal({
                backdrop: "static",
                keyboard: false,
                show: true
            });
        }
        else {
            $("#loadMeInformation").modal('hide');

            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();

            setTimeout(function () { $('body').css('padding-right', 0) }, 1000);
        }
    }

    function Export(t) {
        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");

        var filename = tableMode ? "Export_database_information" : "Export_database_connections";

        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/Database/Export/?type=' + t + '&mode=' + tableMode,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/Database/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t + '&filename=' + encodeURIComponent(filename), '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }

                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function LoadInfo() {
        //load table with infor
        //set mode
        tableMode = true;
        //set title??
        $('#switchText').html($('#switchToConn').val());
        //enable/disable buttons
        $('#btnRefresh').attr('disabled', tableMode);
        $('#btnConn').attr('disabled', !tableMode);
        $('#btnInfo').attr('disabled', tableMode);
        $('.tooltip').remove();
        //hide old table
        $('#tariscope-databaseconns').animate({ opacity: 0 }, 150, function () {
            //load new table
            $('#containerForTables').load("/Database/GetInfo", function () {
                //show new table
                $('#tariscope-databaseinfo').animate({ opacity: 1 }, 150);
                $('#setCollVissBtn').prop('disabled', true);
            });
        });
    }

    function LoadInfo2() {
        //load info without any animation
        $('#containerForTables').load("/Database/GetInfo", function () {
            $('#tariscope-databaseinfo').css("opacity", 1);
        });
    }

    function LoadConn() {
        //load table with connections
        tableMode = false;
        $('#switchText').html($('#switchToInfo').val());
        $('#btnRefresh').attr('disabled', tableMode);
        $('#btnInfo').attr('disabled', tableMode);
        $('#btnConn').attr('disabled', !tableMode);
        $('.tooltip').remove();
        $('#tariscope-databaseinfo').animate({ opacity: 0 }, 150, function () {
            $('#containerForTables').load("/Database/GetConnections", function () {
                $('#tariscope-databaseconns').animate({ opacity: 1 }, 150);
                $('#setCollVissBtn').prop('disabled', false);
            });
        });
    }

    function LoadConn2() {
        //load table with connections without animation
        $('#containerForTables').load("/Database/GetConnections", function () {
            $('#tariscope-databaseconns').css("opacity", 1);
        });
    }

    function SetProgress(e) {
        //set progress for anything
        $('#restoreProgress').css('width', e + '%');
    }

    function GetRestoringStatus() {
        //get information about restore process
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            url: '/Database/GetRestoreStatus/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    if (response.RestoreCompleted) {//completed restoring
                        ShowSpinnerInfor(false);
                        if (response.RestoreCompletedSuccessfully === true) {//successfully restoring
                            if (tableMode)
                                LoadInfo2();
                            else
                                LoadConn2();

                            $('#pSuccess').text(response.RestoreMessage);
                            $('#Successdmodal').modal('show');
                        }
                        else {//error restoring
                            $('#pError').text(response.RestoreMessage);
                            $('#Errordmodal').modal('show');
                        }
                    }
                    else {
                        //show percent
                        if ((response.RestoreMessage + '').includes("percent")) {
                            SetProgress(response.RestoreMessage.match(/\d+/g)[0]);
                        }

                        //get next status
                        setTimeout(GetRestoringStatus, 1000);
                    }
                }
            }
        });
    }

    function GetMovingStatus() {
        //get information about restore process
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            url: '/Database/GetMoveStatus/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    if (response.MoveCompleted) {//completed moving
                        ShowSpinnerInfor(false);
                        if (response.MoveCompletedSuccessfully === true) {//successfully moving
                            if (tableMode)
                                LoadInfo2();
                            else
                                LoadConn2

                            $('#pSuccess').text(response.MoveMessage);
                            $('#Successdmodal').modal('show');
                        }
                        else {//error restoring
                            $('#pError').text(response.MoveMessage);
                            $('#Errordmodal').modal('show');
                        }
                    }
                    else {
                        //get next status
                        setTimeout(GetMovingStatus, 1000);
                    }
                }
            }
        });
    }

    function ShowCustomDBField(e) {
        //show or hide field for set custom db saving path
        switch (e) {
            case 1:
                $('#DBPath').val('');
                $('#DBPathSection').slideUp();
                break;
            default:
                break;
            case 2:
                $('#DBPath').prop('readonly', true);
                $('#DBPath').val($('#ServerBakLocation').val());
                $('#DBPathSection').slideDown();
                break;
            case 3:
                $('#DBPath').prop('readonly', false);
                $('#DBPath').val('');
                $('#DBPathSection').slideDown();
                break;
        }

    }

    function LoadDatabaseFiles() {
        //load table with database files
        $('#DatabaseMoveContainer').load('/Database/GetDatabaseFilesTable/?name=' + encodeURIComponent($('#DatabaseMoveTables').val()));
    }

    function GetArchiveStatus(tempkey) {
        $.ajax({
            type: "POST",
            async: true,
            url: '/Database/GetArchiverStatus/?TempKey=' + encodeURIComponent(tempkey),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    if (response.OperationIsEnd === false)
                        setTimeout(() => { GetArchiveStatus(tempkey); }, 1000);
                    else {
                        ShowSpinner(false);

                        $('#archiverSection').show();

                        if (response.NowDeleter === true) {
                            $('#deleterSection').show();
                            $('#deleterSection').text(response.Deleter_Msg);
                        }
                        else {
                            $('#deleterSection').hide();
                        }
                        
                        $('#archiveCompleted').modal('show');
                        setTimeout(() => {
                            $('#donwloadIcon').slideDown('fast');
                            window.open('/Database/DownloadArchive/?file=' + encodeURIComponent(response.File), '_blank');
                        }, 500);
                    }
                }
            }
        });
    }

    function GetDeleteStatus(tempkey) {
        $.ajax({
            type: "POST",
            async: true,
            url: '/Database/GetDeleterStatus/?TempKey=' + encodeURIComponent(tempkey),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    if (response.OperationIsEnd === false)
                        setTimeout(() => { GetDeleteStatus(tempkey); }, 1000);
                    else {
                        ShowSpinner(false);

                        $('#archiverSection').hide();

                        $('#deleterSection').show();
                        $('#deleterSection').text(response.Deleter_Msg);

                        $('#archiveCompleted').modal('show');
                    }
                }
            }
        });
    }

    function GetRestoreStatus(tempkey) {
        $.ajax({
            type: "POST",
            async: true,
            url: '/Database/GetRestorerStatus/?TempKey=' + encodeURIComponent(tempkey),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    if (response.OperationIsEnd === false)
                        setTimeout(() => { GetRestoreStatus(tempkey); }, 1000);
                    else {
                        ShowSpinner(false);

                        $('#archiverSection').hide();

                        $('#deleterSection').show();
                        $('#deleterSection').text(response.Restorer_Msg);

                        $('#archiveCompleted').modal('show');
                    }
                }
            }
        });
    }

    //event for switch tables
    $('#btnInfo').on('click', LoadInfo);
    $('#btnConn').on('click', LoadConn);

    //refresh table with connections
    $('#btnRefresh').on('click', function () {
        $('#containerForTables').load("/Database/GetConnections", function () {
            $('#tariscope-databaseconns').css("opacity", 1);
        });
    });

    //show modal for restore database
    $('#btnRestore').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            url: '/Database/GetServerBakLocation',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#ServerBakLocation').val(response.path);
                }
                $('#emptyDBName').slideUp();
                $('#btnRestoreConfirm').prop('disabled', false);
                $('#RestoreBDName').val('Tariscope');
                $('#DBStoreLocationSource').val('1');
                ShowCustomDBField(1);
                $('#restoreDBmodal').modal('show');
                LoadBackupFiles(response.path, true);
            }
        });
    });

    //show modal for move database
    $('#btnMoveDB').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            url: '/Database/GetDatabases',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    //add database named
                    $('#DatabaseMoveTables').empty();
                    response.databases.forEach(function (e) {
                        $('#DatabaseMoveTables').append($("<option></option>").attr("value", e).text(e));
                    });

                    //apply selected
                    $('#DatabaseMoveTables').val(response.selected);

                    //show window and load files to table
                    $('#MoveDBConfirm').prop('disabled', true);
                    $('#DatabaseNewDestination').val('');
                    $('#moveDBmodal').modal('show');
                    LoadDatabaseFiles();
                }
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //show or hide section with custom path input
    $('#DBStoreLocationSource').change(function () {
        ShowCustomDBField($(this).val() * 1);
    });

    //start edit server bak location
    $('#btnEditServerBakLocation').on('click', function () {
        $('#ServerBakLocation').prop('readonly', false);
        $('#btnSaveServerBakLocation').show();
        $('#btnEditServerBakLocation').hide();
    });

    //end edit server bak location
    $('#btnSaveServerBakLocation').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            url: '/Database/SaveNewLocation/?path=' + encodeURIComponent($('#ServerBakLocation').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#ServerBakLocation').prop('readonly', true);
                    $('#btnSaveServerBakLocation').hide();
                    $('#btnEditServerBakLocation').show();
                    LoadBackupFiles($('#ServerBakLocation').val(), true);
                }
            }
        });
    });

    //include selected file
    $('#btnIncludeSQL').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            url: '/Database/IncludeBackupSQL/' + selectedFile,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadBackupFiles($('#ServerBakLocation').val(), false);
                }
            }
        });
    });

    //include selected file
    $('#btnBackup').on('click', () => { window.open('/Database/Backups', '_parent'); });

    //exclude selected file
    $('#btnExcludeSQL').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            url: '/Database/ExcludeBackupSQL/' + selectedFile,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadBackupFiles($('#ServerBakLocation').val(), false);
                }
            }
        });
    });

    //move top selected restore item
    $('#btmMoveTopSQL').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            url: '/Database/MoveTopBackupSQL/' + selectedFile,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadBackupFiles($('#ServerBakLocation').val(), false);
                }
            }
        });
    });

    //move down selected restore item
    $('#btnMoveDownSQL').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            url: '/Database/MoveDownBackupSQL/' + selectedFile,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadBackupFiles($('#ServerBakLocation').val(), false);
                }
            }
        });
    });

    //show or hide error when empty db name
    $('#RestoreBDName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyDBName').slideDown('fast');
            $('#btnRestoreConfirm').prop('disabled', true);
            $('#btnSaveDatabasename').prop('disabled', true);
        }
        else {
            $('#emptyDBName').slideUp('fast');
            $('#btnRestoreConfirm').prop('disabled', false);
            $('#btnSaveDatabasename').prop('disabled', false);
        }
    });

    //start restoring
    $('#btnRestoreConfirm').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            url: '/Database/MakeRestore/?database=' + encodeURIComponent($('#RestoreBDName').val()) + "&force=" + encodeURIComponent($('#DBPath').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#restoreDBmodal').modal('hide');
                    $('#restore').slideDown();
                    $('#move').slideUp();
                    $('#upload').slideUp();
                    $('#restoreProgress').css('width', '5%');
                    ShowSpinnerInfor(true);
                    GetRestoringStatus();
                }
            }
        });
    });

    //save new db name
    $('#btnSaveDatabasename').on('click', function () {
        $('#RestoreBDName').prop('readonly', true);
        $('#editDBNameAlert').slideUp('fast');
        $('#btnSaveDatabasename').hide();
        $('#btnEditdatabasename').show();
    });

    //show alert and open for edit field with db name
    $('#btnEditdatabasename').on('click', function () {
        $('#RestoreBDName').prop('readonly', false);
        $('#editDBNameAlert').slideDown('fast');
        $('#btnSaveDatabasename').show();
        $('#btnEditdatabasename').hide();
    });

    //open filepicker
    $('#btnIncludePC').on('click', function () {
        $('#FileInput').val('');
        $('#FileInput').click();
    });

    //uploading files into server (with progress)
    $("#FileInput").change(function () {

        $('#restoreDBmodal').modal('hide');

        $('#restore').slideUp();
        $('#move').slideUp();
        $('#upload').slideDown();
        SetProgress(0);

        var data = document.getElementById("FileInput").files[0];
        var formData = new FormData();
        formData.append(data.name, data);

        ShowSpinnerInfor(true);

        $.ajax({
            type: 'POST',
            async: true,
            url: '/Database/Upload/',
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            xhr: function () {
                var xhr = new window.XMLHttpRequest();
                xhr.upload.addEventListener("progress", function (e) {
                    if (e.lengthComputable) { SetProgress(Math.round((e.loaded / e.total) * 100)); }
                }, false);
                return xhr;
            },
            error: function (jqxhr, status, errorThrown) {
                console.log('jqxhr:');
                console.log(jqxhr);
                console.log('status:');
                console.log(status);
                console.log('errorThrown:');
                console.log(errorThrown);

            },
            success: function (response) {
                if (response.success === true) {
                    ShowSpinnerInfor(false);
                    LoadBackupFiles('', true);
                    setTimeout(function () { $('#restoreDBmodal').modal('show') }, 300);
                }
                else {
                    console.log(response.msg);
                }
            }
        });
    });

    //delete file loaded by user
    $('#btnExcludePC').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            url: '/Database/ExcludeBackupPC/' + selectedFile,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadBackupFiles('', true);
                }
            }
        });
    });

    //move top loaded files
    $('#btmMoveTopPC').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            url: '/Database/MoveTopBackupSQL/' + selectedFile,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadBackupFiles('', false);
                }
            }
        });
    });

    //move down loaded
    $('#btnMoveDownPC').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            url: '/Database/MoveDownBackupSQL/' + selectedFile,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadBackupFiles('', false);
                }
            }
        });
    });

    //load files for selected database
    $('#DatabaseMoveTables').change(LoadDatabaseFiles);

    //show or hide error when empty move db desctionation path
    $('#DatabaseNewDestination').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyMovePath').slideDown('fast');
            $('#MoveDBConfirm').prop('disabled', true);
        }
        else {
            $('#emptyMovePath').slideUp('fast');
            $('#MoveDBConfirm').prop('disabled', false);
        }
    });

    //start moving database
    $('#MoveDBConfirm').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            url: '/Database/MakeMove/?database=' + encodeURIComponent($('#DatabaseMoveTables').val()) + '&destination=' + encodeURIComponent($('#DatabaseNewDestination').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#moveDBmodal').modal('hide');
                    $('#restore').slideUp();
                    $('#move').slideDown();
                    $('#upload').slideUp();
                    SetProgress(100);
                    ShowSpinnerInfor(true);
                    GetMovingStatus();
                }
            }
        });
    });

    /*attach event to checkboxes for select column for displaying*/
    $('#MenuSelectColumn input').on('click', function (event) {

        var visible = $(event.target).prop('checked');
        var colName = $(event.target).attr('data-value');

        $.ajax({
            type: "POST",
            url: '/Database/SetTableColumnVisability?colName=' + colName + "&visible=" + visible,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadConn2();
                }
            }
        });
    });

    //disable autoswitch for carousels
    $('.carousel').carousel({
        interval: false
    });

    //change sapass
    $('#btnChangeSA').on('click', () => {
        $('#sapassSave').prop('disabled', true);
        $('#sapass').val('');
        $('#sapass2').val('');
        $('#emptysapassError').hide();
        $('#notequalsapassError').hide();
        $('#saPassUpdate').modal('show');
    });

    //show emprt error
    $('#sapass').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptysapassError').slideDown('fast');
            $('#sapassSave').prop('disabled', true);
        }
        else {
            $('#emptysapassError').slideUp('fast');
            $('#sapassSave').prop('disabled', false);
        }
    });

    //confirm sapasss save
    $('#sapassSave').on('click', () => {
        if ($('#sapass').val() == $('#sapass2').val()) {
            $('#saPassUpdate').modal('hide');
            ShowSpinner(true);
            $.ajax({
                type: "POST",
                url: '/Database/Sapass/?data=' + encodeURIComponent($('#sapass').val()),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        ShowSpinner(false);
                        $('#sapassAdvice').modal('show');
                    }
                }
            });
        }
        else {
            $('#notequalsapassError').slideDown('fast');
            setTimeout(() => { $('#notequalsapassError').slideUp('fast'); }, 3000);
        }
    });


    //==================archive================================================
    //hide show button for carousel for archive calls
    $("#ArchiveCallsCarousel").on('slid.bs.carousel', function () {
        let slideNum = $('#ArchiveCallsCarousel').find('div.active').index();

        if (slideNum > 0) $('#ArchiveCallsCarouselPrevBtn').show();
        else $('#ArchiveCallsCarouselPrevBtn').hide();

        if (slideNum >= 3) $('#ArchiveCallsCarouselNextBtn').hide();
        else $('#ArchiveCallsCarouselNextBtn').show();
    });

    //show or hide custom period
    $('#ArchivePeriodSelect').change(function () {
        if ($(this).val() * 1 === 2)
            $('#CustomArchivePeriodSection').slideDown('fast');
        else
            $('#CustomArchivePeriodSection').slideUp('fast');
    });

    //from/to dates checkboxes
    $('#FromEnabled').change(function () {
        try {
            $('#datetimepickerFrom').data("DateTimePicker").setDate($(this).prop('checked') === true ? new Date() : null);
        } catch (e) { console.log(e); }
    });
    $('#ToEnabled').change(function () {
        try {
            $('#datetimepickerTo').data("DateTimePicker").setDate($(this).prop('checked') === true ? new Date() : null);
        } catch (e) { console.log(e); }
    });

    //show modal for archive calls
    $('#btnArchiveCalls').on('click', () => {
        $('#deviceConcentratorForMakeArchive').load('/TariscopeViews/CallsTransfer/SelectDevice', () => {
            $('#ArchiveCallsCarousel').carousel(0);
            $('#ArchiveCallsCarouselPrevBtn').hide();
            $('#ArchiveCallsCarouselNextBtn').show();
            $('#CustomArchivePeriodSection').hide();

            $('#ArchivePeriodSelect').val('0');
            $('#DeleteCallsAfterArchive').prop('checked', true);

            initDateTimepickers();

            try {
                $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date());
                $('#datetimepickerTo').data("DateTimePicker").setDate(new Date());
            } catch (e) { console.log(e); }

            $('#FromEnabled').prop('checked', true);
            $('#ToEnabled').prop('checked', true);

            $('#archiveCallsmodal').modal('show');
        });
    });

    //make archive
    $('#ArchiveCallsCarouselMakeBtn').on('click', function () {
        let devElements = $('#deviceConcentratorForMakeArchive input[id^="SelectedDevice"');
        let devices = [];

        devElements.map((e) => {
            if ($(devElements[e]).prop('checked') === true)
                devices.push($(devElements[e]).attr('data-device') * 1);
        });

        if (devices.length === 0) {
            $('#zeroDeviceError').slideDown('fast');
            setTimeout(() => { $('#zeroDeviceError').slideUp('fast'); }, 2500);
            //show error here
        }
        else {
            $('#archiveCallsmodal').modal('hide');
            ShowSpinner(true);

            let from = $('#FromEnabled').prop('checked') === true ? $('#datetimepickerFrom').data('date') : '';
            let to = $('#ToEnabled').prop('checked') === true ? $('#datetimepickerTo').data('date') : '';

            $.ajax({
                type: "POST",
                async: true,
                url: '/Database/GoArchive/?Delete=' + encodeURIComponent($('#DeleteCallsAfterArchive').prop('checked')) +
                    '&Devices=' + encodeURIComponent(devices.join(',')) +
                    '&PeriodType=' + $('#ArchivePeriodSelect').val() +
                    '&From=' + from +
                    '&To=' + to,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        GetArchiveStatus(response.TempKey);
                    }
                }
            });
        }
    });

    //clear loaded devices
    $('#archiveCallsmodal').on('hidden.bs.modal', function () {
        $('#deviceConcentratorForMakeArchive').empty();
    });

    //===================delete=================================================
    //hide show button for carousel for archive calls
    $("#DeleteCallsCarousel").on('slid.bs.carousel', function () {
        let slideNum = $('#DeleteCallsCarousel').find('div.active').index();

        if (slideNum > 0) $('#DeleteCallsCarouselPrevBtn').show();
        else $('#DeleteCallsCarouselPrevBtn').hide();

        if (slideNum >= 2) $('#DeleteCallsCarouselNextBtn').hide();
        else $('#DeleteCallsCarouselNextBtn').show();
    });

    //show modal for delete calls
    $('#btnDeleteCalls').on('click', () => {
        $('#deviceConcentratorForDelete').load('/TariscopeViews/CallsTransfer/SelectDevice', () => {
            $('#DeleteCallsCarousel').carousel(0);
            $('#DeleteCallsCarouselPrevBtn').hide();
            $('#DeleteCallsCarouselNextBtn').show();
            $('#CustomDeletePeriodSection').hide();

            $('#DeletePeriodSelect').val('0');

            initDateTimepickersDelete();

            try {
                $('#datetimepickerFromDelete').data("DateTimePicker").setDate(new Date());
                $('#datetimepickerToDelete').data("DateTimePicker").setDate(new Date());
            } catch (e) { console.log(e); }

            $('#FromEnabledDelete').prop('checked', true);
            $('#ToEnabledDelete').prop('checked', true);

            $('#deleteCallsmodal').modal('show');
        });
    });

    //show or hide custom period
    $('#DeletePeriodSelect').change(function () {
        if ($(this).val() * 1 === 2)
            $('#CustomDeletePeriodSection').slideDown('fast');
        else
            $('#CustomDeletePeriodSection').slideUp('fast');
    });

    //delete
    $('#ArchiveCallsCarouselDeleteBtn').on('click', function () {
        let devElements = $('#deviceConcentratorForDelete input[id^="SelectedDevice"');
        let devices = [];

        devElements.map((e) => {
            if ($(devElements[e]).prop('checked') === true)
                devices.push($(devElements[e]).attr('data-device') * 1);
        });

        if (devices.length === 0) {
            $('#zeroDeleteDeviceError').slideDown('fast');
            setTimeout(() => { $('#zeroDeleteDeviceError').slideUp('fast'); }, 2500);
            //show error here
        }
        else {
            $('#deleteCallsmodal').modal('hide');
            ShowSpinner(true);

            let from = $('#FromEnabledDelete').prop('checked') === true ? $('#datetimepickerFromDelete').data('date') : '';
            let to = $('#ToEnabledDelete').prop('checked') === true ? $('#datetimepickerToDelete').data('date') : '';

            $.ajax({
                type: "POST",
                async: true,
                url: '/Database/GoDelete/?Devices=' + encodeURIComponent(devices.join(',')) +
                    '&PeriodType=' + $('#DeletePeriodSelect').val() +
                    '&From=' + from +
                    '&To=' + to,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        GetDeleteStatus(response.TempKey);
                    }
                }
            });
        }
    });

    //clear loaded devices
    $('#deleteCallsmodal').on('hidden.bs.modal', function () {
        $('#deviceConcentratorForDelete').empty();
    });

    //===================restore===============================================
    //show modal for delete calls
    $("#RestoreCallsCarousel").on('slid.bs.carousel', function () {
        let slideNum = $('#RestoreCallsCarousel').find('div.active').index();

        if (slideNum > 0) $('#DeleteCallsCarouselPrevBtn').show();
        else $('#RestoreCallsCarouselPrevBtn').hide();

        if (slideNum >= 2) $('#DeleteCallsCarouselNextBtn').hide();
        else $('#RestoreCallsCarouselNextBtn').show();
    });

    //show modal for restore calls
    $('#btnRestoreCalls').on('click', () => {
        $('#deviceConcentratorForRestore').load('/TariscopeViews/CallsTransfer/SelectDevice', () => {
            $('#RestoreCallsCarousel').carousel(0);
            $('#RestoreCallsCarouselPrevBtn').hide();
            $('#RestoreCallsCarouselNextBtn').show();

            //single select for devices
            $('input[id^="SelectedDevice_"]').change(function () {
                $('input[id^="SelectedDevice_"').prop('checked', false);
                $(this).prop('checked', true);
            });

            //event for devices

            $('#restoreCallsmodal').modal('show');
        });
    });

    //restore next button
    $('#RestoreCallsCarouselNextBtn').on('click', () => {
        let slideNum = $('#RestoreCallsCarousel').find('div.active').index() * 1;

        if (slideNum === 0) {
            let files = 0;

            //get file
            Array.from(document.getElementById("CallsFileInput").files).forEach(e => {
                files++;
            });

            if (files === 0) {//empty file
                $('#nofileError').slideDown('fast');
                setTimeout(() => { $('#nofileError').slideUp('fast'); }, 2500);

                return;
            }   
        }

        if (slideNum === 0 && $('#RewriteDevice').prop('checked') === true)
            $('#RestoreCallsCarousel').carousel(1);
        else {
            $('#RestoreCallsCarousel').carousel(2);
            $('#RestoreCallsCarouselNextBtn').hide();
        }

        $('#RestoreCallsCarouselPrevBtn').show();
    });

    //restore prev button
    $('#RestoreCallsCarouselPrevBtn').on('click', () => {
        let slideNum = $('#RestoreCallsCarousel').find('div.active').index() * 1;

        if (slideNum === 2 && $('#RewriteDevice').prop('checked') === true)
            $('#RestoreCallsCarousel').carousel(1);
        else {
            $('#RestoreCallsCarousel').carousel(0);
            $('#RestoreCallsCarouselPrevBtn').hide();
        }
    });

    //clear loaded devices
    $('#restoreCallsmodal').on('hidden.bs.modal', function () {
        $('#deviceConcentratorForRestore').empty();
    });

    $('#ArchiveCallsCarouselRestoreBtn').on('click', () => {
        let devElements = $('#deviceConcentratorForRestore input[id^="SelectedDevice"');
        let devices = [];

        let rewriteDevice = $('#RewriteDevice').prop('checked');
        let ignoreIdentity = $('#NotIDRestore').prop('checked');

        devElements.map((e) => {
            if ($(devElements[e]).prop('checked') === true)
                devices.push($(devElements[e]).attr('data-device') * 1);
        });

        let files = 0;

        //get file
        var formData = new FormData();
        Array.from(document.getElementById("CallsFileInput").files).forEach(e => {
            formData.append(e.name, e);
            files++;
        });

        if (rewriteDevice && devices.length === 0 && files === 0) {//empty file and device
            $('#noFileDeviceError').slideDown('fast');
            setTimeout(() => { $('#noFileDeviceError').slideUp('fast'); }, 2500);
        }
        else if (rewriteDevice && devices.length === 0) {//empty device
            $('#noDeviceError').slideDown('fast');
            setTimeout(() => { $('#noDeviceError').slideUp('fast'); }, 2500);
        }
        else if (files === 0) {//empty file
            $('#nofileError').slideDown('fast');
            setTimeout(() => { $('#nofileError').slideUp('fast'); }, 2500);
        }
        else {//send here and start restore
            $('#restoreCallsmodal').modal('hide');
            ShowSpinner(true);

            $.ajax({
                type: "POST",
                async: true,
                data: formData,
                datatype: 'application/octet-stream',
                contentType: false,
                processData: false,
                traditional: true,
                url: '/Database/GoRestore/?DeviceID=' + (rewriteDevice ? devices[0] : 0) + '&IgnoreIdentity=' + ignoreIdentity,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        GetRestoreStatus(response.TempKey);
                    }
                }
            });
        }
    });

    //file input
    var inputs = document.querySelectorAll('.file-input');
    for (var i = 0, len = inputs.length; i < len; i++) {
        customInput(inputs[i]);
    }
    function customInput(el) {
        const fileInput = el.querySelector('[type="file"]');
        const label = el.querySelector('[data-js-label]');

        fileInput.onchange = fileInput.onmouseout = function () {
            if (!fileInput.value) return;

            var value = fileInput.value.replace(/^.*[\\\/]/, '');
            el.className += ' -chosen';
            label.innerText = value;
        };
    }

    //clear loaded devices
    $('#archiveCompleted').on('hidden.bs.modal', function () {
        $('#donwloadIcon').hide();
    });

    //load first info (without animations)
    LoadInfo2();
});