﻿let selectedCodes = [];
let rowIndex;
let header;
let sticky;

function RemoveFromArray(array, element) {
    //remove element form array
    const index = array.indexOf(element);

    if (index !== -1) {
        array.splice(index, 1);
    }
}

function GetBackSelected() {
    for (let i = 0; i < selectedCodes.length; i++) {
        try {
            $('tr[data-id="' + selectedCodes[i] + '"]').addClass('selected');
        } catch (e) { console.log(e); }
    }
}

function IsTreeCodesView() {
    if ($('#tbSearch').val() !== "" || $('#SortCol').val() !== "")
        return false;

    return !$('#DisableTree').prop('checked');
}

function AttachEventsToTable() {
    $('th').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/PersonalArea/Service/Destinations/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#SortCol').val(response.CurrentSortColumnName);
                    Load();
                }
            }
        });
    });

    $('#tcodesTable').removeClass('disDiv');
}

function Load() {
    selectedCodes = [];
    $('#tcodesTable').addClass('disDiv');

    if (IsTreeCodesView()) {
        $('#tcodesTable').load("/PersonalArea/Service/Destinations/Tree/?ProviderID=" + $('#CallProviderID').val(), AttachEventsToTable);
        SetSticky();
    }
    else
        $('#tcodesTable').load("/PersonalArea/Service/Destinations/Table/0/50/?Search=" + encodeURIComponent($('#tbSearch').val()) + '&ProviderID=' + $('#CallProviderID').val());
}

function SetSticky() {
    header = document.getElementById("headRow");                 //for sticky head
    sticky = header.offsetTop;                                   //for sticky head

    //animate scroll top
    $('.go-top').on('click', function (event) {
        event.preventDefault();
        $('html, body').animate({ scrollTop: 0 }, 300);
    });

    //event for show go top button
    $(window).on("scroll", function () {
        //for go top button
        if ($(this).scrollTop() > 200) {
            $('.go-top').fadeIn(200);
        } else {
            $('.go-top').fadeOut(200);
        }

        //for sticky head
        if (window.pageYOffset > (sticky + 100)) {
            header.classList.add("sticky");
            $('#headRow').width($('#tcodesTable').width());
        } else {
            header.classList.remove("sticky");
        }
    });
}