﻿let isProvider = $('#CallProviderID').val() !== "";
let providerID = $('#CallProviderID').val();
let curentLang = getCookie('CurrentLanguage');

function getCookie(name) {
    let matches = document.cookie.match(new RegExp(
        "(?:^|; )" + name.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, '\\$1') + "=([^;]*)"
    ));
    return matches ? decodeURIComponent(matches[1]) : undefined;
}

function Rate(data, value) {
    return data === null ? value : data;
}

function Category(data, value1) {
    return data === null ? value1 : (data === '-' ? notOverride : data);
}

function CallType(data, call, value1) {
    return data === null ? value1 : (call * 1 === -1 ? notOverride : $("#adcCallType option[value='" + call * 1 + "']").text());
}

function BuildCode(code) {
    if (code[0] === "k")
        return "";
    else if (code[0] === "0")
        return code.substring(1);
    else
        return code;
}

function GetRow(code, isTree) {
    let tree = isTree ? 'data-id="' + code.ID + '" loaded="false" class="treegrid-' + code.ID + ' treegrid-parent-' + code.ParentId + '"' : 'data-id="' + code.ID + '"';

    let row = '<tr ' + tree  + '>';
    row += '<td data-name="Name"><span data-n="1">' + code.Name + '</span></td>';
    row += '<td data-name="Code">' + BuildCode(code.Code) + '</td>';

    if (isProvider) {
        if (code.CategoryName === null) {
            row += '<td colspan="3">' + notInstalled + '</td>';
        }
        else {
            row += '<td data-name="Tariff">' + Rate(code.RateName, notInstalled) + '</td>';
            row += '<td data-name="Category">' + Category(code.CategoryName, notInstalled) + '</td>';
            row += '<td data-name="CallType">' + CallType(code.CategoryName, code.CallType, notInstalled) + '</td>';
        }
        row += '<td data-name="ID" hidden>' + code.ID + '</td></tr>';
    }
    else {
        row += '<td data-name="FromDate">' + new Date(code.FromDate).toLocaleDateString(curentLang) + '</td>';
        row += '<td data-name="ToDate">' + new Date(code.ToDate).toLocaleDateString(curentLang) + '</td>';
        row += '<td data-name="ID">' + code.ID + '</td></tr>';
    }
    return row;
}