﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using Microsoft.Data.SqlClient;

/// <summary>

/// ''' Script may be used for Asterisk balance monitoring. Setup script as periodically executed in Tariscope observer scripts.

/// ''' Update Asterisk MySql database credentials.

/// ''' </summary>

/// ''' <remarks></remarks>

public class UpdateBalanceStatisticsScript : IScript
{
    private IScriptHost Host;

    const string MYSQL_HOST = "localhost";
    const string MYSQL_LOGIN = "root";
    const string MYSQL_PASSWORD = "";
    const string MYSQL_DB = "asterisk";

    private Dictionary<string, string> Replacements = new Dictionary<string, string>();
    public void Init(IScriptHost host)
    {
        this.Host = host;
        host.Close += OnClose;

        Replacements.Add("1044", "7199030");
        Replacements.Add("10102", "7199080");
        Replacements.Add("1030", "7199090");
        Replacements.Add("10106", "7199103");
        Replacements.Add("10107", "7199104");
        Replacements.Add("10104", "7199105");
        Replacements.Add("07669506", "7199106");
        Replacements.Add("10105", "7199107");
        Replacements.Add("10101", "7199108");
        Replacements.Add("10123", "7199141");
        Replacements.Add("10122", "7199159");
        Replacements.Add("10119", "7199201");
        Replacements.Add("10120", "7199204");
        Replacements.Add("10121", "7199295");
        Replacements.Add("10109", "7199301");
        Replacements.Add("10110", "7199302");
        Replacements.Add("10111", "7199303");
        Replacements.Add("10112", "7199304");
        Replacements.Add("10113", "7199305");
        Replacements.Add("10114", "7199306");
        Replacements.Add("10108", "7199307");
        Replacements.Add("10115", "7199308");
    }
    private void OnClose(ref bool Cancel)
    {
        return;
    }

    private List<SubscriberDnInfo> GetTariscopeSubscribers()
    {
        List<SubscriberDnInfo> SubscribersList = new List<SubscriberDnInfo>();
        using (SqlConnection cnTariscope = new SqlConnection(Host.DatabaseConnectionString))
        {
            cnTariscope.Open();
            string QueryTariscope = "SELECT D.ID, D.AbonentName, D.DN, D.FromDate, D.ToDate, " + "ISNULL((SELECT(SUM(ROUND(AH.Payment, 2)) - SUM(ROUND(AH.Charge, 2))) FROM dbo.AccountHistory AS AH WHERE AH.AbonentID = D.ID AND AH.ToDate < GETDATE()), 0) AS Balance " + "FROM dbo.ab_mc_dns AS D";
            using (var cmdTariscope = new SqlCommand(QueryTariscope, cnTariscope))
            {
                using (SqlDataReader rs = cmdTariscope.ExecuteReader())
                {
                    while (rs.Read())
                    {
                        string DN = rs.GetString(2);
                        if (Replacements.ContainsKey(DN))
                            DN = Replacements[DN];
                        SubscribersList.Add(new SubscriberDnInfo(rs.GetInt32(0), DN, rs.GetDateTime(3), rs.GetDateTime(4), rs.GetDecimal(5)));
                    }
                }
            }
        }
        return SubscribersList;
    }
    private static Dictionary<string, bool> GetMySqlExistEntries(SqlCommand cmd)
    {
        cmd.CommandText = "SELECT id, number,active FROM clients";
        SqlDataReader rs2 = cmd.ExecuteReader();
        Dictionary<string, bool> ExistEntries = new Dictionary<string, bool>();
        using (rs2)
            while (rs2.Read())
            {
                try
                {
                    ExistEntries.Add(rs2.GetString(1), rs2.GetBoolean(2));
                }
                catch
                {
                }
            }
        return ExistEntries;
    }
    private static void UpdateMySqlSubscriber(SqlCommand cmd, Dictionary<string, bool> ExistEntries, SubscriberDnInfo SubscriberDn)
    {
        string MySqlActionText = string.Empty;
        bool IsActive = DateTime.Now > SubscriberDn.FromDate && DateTime.Now < SubscriberDn.ToDate;
        string NowMySqlDateValue = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");

        if (ExistEntries.ContainsKey(SubscriberDn.DN))
        {
            // update
            if (IsActive && ExistEntries[SubscriberDn.DN] == false)
                // Active, but recorded as not active in MySql db. Need to update as active
                MySqlActionText = string.Format("update clients SET active=1, balance={1}, unblock_date='{2}' WHERE number='{0}'", SubscriberDn.DN, (int)SubscriberDn.Balance, NowMySqlDateValue);
            else if (!IsActive && ExistEntries[SubscriberDn.DN] == true)
                // Not active, but recorded as active in MySql db. Need to update as not active
                MySqlActionText = string.Format("update clients SET active=0, balance={1}, block_date='{2}' WHERE number='{0}'", SubscriberDn.DN, (int)SubscriberDn.Balance, NowMySqlDateValue);
            else
                // nothing changed, just update balance
                MySqlActionText = string.Format("update clients SET balance={1} WHERE number='{0}'", SubscriberDn.DN, (int)SubscriberDn.Balance);
        }
        else
            // insert
            MySqlActionText = string.Format("insert into clients (client_name, number,active,balance, block_date, unblock_date,init_date) values('{0}','{1}',{2},{3},'{4}','{5}','{6}')", SubscriberDn.DN, SubscriberDn.DN, IsActive ? 1 : 0, (int)SubscriberDn.Balance, IsActive ? "0000-00-00 00:00:00" : NowMySqlDateValue, !IsActive ? "0000-00-00 00:00:00" : NowMySqlDateValue, NowMySqlDateValue);
        cmd.CommandText = MySqlActionText;
        cmd.ExecuteNonQuery();
    }
    private void UpdateMySqlDatabaseContent(List<SubscriberDnInfo> SubscribersList)
    {
        Assembly MySql = Assembly.LoadFile(Path.Combine(Assembly.GetExecutingAssembly().Location, "mysql.data.dll"));
        Type MySqlConnection = MySql.GetType("MySql.Data.MySqlClient.MySqlConnection");
        Type MySqlCommand = MySql.GetType("MySql.Data.MySqlClient.MySqlCommand");

        SqlConnection cn = Activator.CreateInstance(MySqlConnection) as SqlConnection;
        cn.ConnectionString = string.Format("server={0};User Id={1};password={2};database={3}", MYSQL_HOST, MYSQL_LOGIN, MYSQL_PASSWORD, MYSQL_DB);
        cn.Open();
        SqlCommand cmd = Activator.CreateInstance(MySqlCommand) as SqlCommand;
        using (cmd)
        {
            cmd.Connection = cn;
            Dictionary<string, bool> ExistEntries = GetMySqlExistEntries(cmd);
            this.Host.AddEvent("Numbers count: " + ExistEntries.Count);
            foreach (SubscriberDnInfo SubscriberDn in SubscribersList)
            {
                this.Host.AddEvent("Update number: " + SubscriberDn.DN);
                UpdateMySqlSubscriber(cmd, ExistEntries, SubscriberDn);
            }
        }
        cn.Close();
    }
    public void Main(object Parameters)
    {
        try
        {
            this.Host.AddEvent("Preparing Subscribers list");
            List<SubscriberDnInfo> SubscribersList = GetTariscopeSubscribers();
            // Initialize Mysql driver
            this.Host.AddEvent("Updating MySql table");
            UpdateMySqlDatabaseContent(SubscribersList);
        }
        catch (Exception ex)
        {
            this.Host.AddEvent("Error:" + ex.ToString());
        }
    }
    private class SubscriberDnInfo
    {
        public int ID;
        public string DN;
        public decimal Balance;
        public DateTime FromDate;
        public DateTime ToDate;

        public SubscriberDnInfo()
        {
        }
        public SubscriberDnInfo(int ID, string DN, DateTime FromDate, DateTime ToDate, decimal Balance)
        {
            this.ID = ID;
            this.DN = DN;
            this.FromDate = FromDate;
            this.ToDate = ToDate;
            this.Balance = Balance;
        }
    }
}

// mysql> describe clients;
// +--------------+------------------+------+-----+---------------------+----------------+
// | Field        | Type             | Null | Key | Default             | Extra          |
// +--------------+------------------+------+-----+---------------------+----------------+
// | id           | int(11) unsigned | NO   | PRI | NULL                | auto_increment | 
// | client_name  | varchar(80)      | NO   | MUL |                     |                | 
// | address      | varchar(20)      | YES  |     | NULL                |                | 
// | number       | varchar(20)      | NO   |     |                     |                | 
// | init_date    | datetime         | NO   |     | 0000-00-00 00:00:00 |                | 
// | active       | tinyint(1)       | NO   |     | 0                   |                | 
// | balance      | int(10) unsigned | YES  |     | NULL                |                | 
// | block_date   | datetime         | NO   |     | 0000-00-00 00:00:00 |                | 
// | unblock_date | datetime         | NO   |     | 9999-01-01 00:00:00 |                | 
// +--------------+------------------+------+-----+---------------------+----------------+
