﻿var widgets = {};
var widgetsToAutoRefresh = {};
var clickedWidget = null;
var autorefresInterval = 5;

function GetLoader() {
    let str = '<span class="widgetSpinner"><span></span><span></span><span></span></span>';
    return str;
}

function SendRefreshRequest(id, uid = null, callback = null) {
    let url = '/Dashboard/GetContent/' + id + '/' + (uid === null ? widgets[id].UID : uid) + '?Title=' + encodeURIComponent(widgets[id].Title);
    $('#' + id).find('div.lt-body').load(url, callback);
}

function SendRequestAutoRefresh(id, uid) {
    let url = '/Dashboard/GetContent/' + id + '/' + (uid === null ? widgets[id].UID : uid) + '?Title=' + encodeURIComponent(widgets[id].Title);
    $('#' + id).find('div.lt-body').load(url, function () {
        setTimeout(() => { SendRequestAutoRefresh(id, uid); }, autorefresInterval * 200);
    });
}

function SendConfiguration(btnClicked, Json = null) {
    $('#orderSavingLabel').show();
    $('#widgetConfigModal').modal('hide');

    var $form = $(btnClicked).parents('form');
    var id = $('#widgetConfigModal #widgetID').val();
    var url1 = "/Dashboard/SaveConfiguration/" + id;
    var formData = new FormData();
    formData.append('model', JSON.stringify(Json !== null ? Json : jQFormSerializeArrToJson($form.serializeArray())));

    $.ajax({
        type: "POST",
        //url: $form.attr('action'),
        url: url1,
        data: formData,
        datatype: 'application/octet-stream',
        contentType: false,
        processData: false,
        traditional: true,
        success: function (response) {
            if (response !== null) {
                $('#orderSavingLabel').hide();
                UpdateWidget();
            }
        }
    });
}

function UpdateWidget(all = false, callback = null) {

    if (all) {
        $('.widget').filter('div[loader="true"]').find('div').html(GetLoader());

        for (key in widgets) {
            if (key !== "clean") {
                SendRefreshRequest(key);
            }
        }
    }
    else {
        if (clickedWidget === null)
            return;

        $('div[id="' + clickedWidget + '"][loader="true"]').find('div').html(GetLoader());

        SendRefreshRequest(clickedWidget);
    }

    if (callback !== null)
        callback();
}

function jQFormSerializeArrToJson(formSerializeArr) {
    var jsonObj = {};
    var list = {};

    jQuery.map(formSerializeArr, function (n, i) {
        if (n.name !== '__RequestVerificationToken' && jsonObj[n.name] === undefined) {
            if (n.name.includes('[') && n.name.includes(']')) {//for lists

                let name = n.name.substring(0, n.name.indexOf('['));
                if (list[name] === undefined)
                    list[name] = [];

                list[name].push(n.value);

            }
            else//for other
                jsonObj[n.name] = n.value;
        }
    });

    //load lists to json
    for (key in list) {
        jsonObj[key] = list[key];
    }

    return jsonObj;
}

$(document).ready(() => {
    function GetClass({ size = "xs", width = 1, height = 1, left = 0, top = 0 }) {
        let str = ' ';
        str += ' lt-' + size + '-x-' + left;
        str += ' lt-' + size + '-y-' + top;
        str += ' lt-' + size + '-w-' + width;
        str += ' lt-' + size + '-h-' + height;

        return str;
    }

    function GetSizeObject(name, size) {
        let data = {};
        data['size'] = name;
        data['width'] = size.Width;
        data['height'] = size.Height;
        data['left'] = size.Left;
        data['top'] = size.Top;

        return data;
    }

    function CreateWidget(id, { xs = null, sm = null, md = null, lg = null, dragable = true }, forAdd = false, hasLoader = true) {
        let cl = 'widget lt';
        cl += GetClass(GetSizeObject("xs", xs));
        cl += GetClass(GetSizeObject("sm", sm));
        cl += GetClass(GetSizeObject("md", md));
        cl += GetClass(GetSizeObject("lg", lg));
        cl += (dragable ? ' activeWidget' : ' staticWidget');

        let loader = GetLoader();

        let content = '<div class="lt-body note">' + loader + '</div>';
        let widget = $('<div id="' + id + '" draggable="' + dragable + '" class="' + cl + '" loader=' + hasLoader +'>' + content + '</div>');

        if (forAdd) {
            $('#gridForAdd').append(widget);
        }
        else {
            $('#grid').append(widget);
        }
    }

    function RefreshWidgetData(id = null, uid = null) {
        if (id === null) {
            for (key in widgets) {
                if (key !== "clean") {
                    SendRefreshRequest(key);
                }
            }
        }
        else {
            SendRefreshRequest(id, uid);
        }
    }

    function LoadWidgets() {
        widgetsToAutoRefresh = {};

        $.ajax({
            type: "POST",
            url: '/Dashboard/Load',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    for (key in response.widgets) {

                        if (key !== "clean") {

                            let data = {};
                            data['xs'] = response.widgets[key].SizeXS;
                            data['sm'] = response.widgets[key].SizeSM;
                            data['md'] = response.widgets[key].SizeMD;
                            data['lg'] = response.widgets[key].SizeLG;
                            data['dragable'] = response.widgets[key].Draggable;

                            widgets[response.widgets[key].ID] = {
                                UID: response.widgets[key].UID,
                                Removable: response.widgets[key].Removable,
                                Draggable: response.widgets[key].Draggable,
                                HasConfiguration: response.widgets[key].HasConfiguration,
                                Title: response.widgets[key].Title
                            };

                            if (response.widgets[key].IsAlwaysAutoRefresh === true) {
                                widgetsToAutoRefresh[response.widgets[key].ID] = response.widgets[key].UID;
                            }

                            CreateWidget(response.widgets[key].ID, data, false, response.widgets[key].HasUpdateAnimation);
                        }
                    }
                    RefreshWidgetData();
                    AttachEventToWidgets();
                    RunTimeout();
                }
            }
        });
    }

    function GetWidgetSize(id) {
        let e = $('#' + id);
        let data = {};
        data['id'] = id;
        data['uid'] = widgets[id * 1].UID;
        data['title'] = widgets[id * 1].Title;
        data['removable'] = widgets[id * 1].Removable;
        data['draggable'] = widgets[id * 1].Draggable;

        if (e.length > 0) {
            var regex = /\lt-+(xs|sm|md|lg)-+(x|y|w|h)-+(\d+$)/
            let sizes = $(e).prop('class').split(' ');

            for (key in sizes) {
                if (key !== 'clear') {
                    var match = regex.exec(sizes[key]);

                    if (match !== null) {
                        if (data[match[1]] === null || data[match[1]] === undefined)
                            data[match[1]] = {};

                        data[match[1]][match[2]] = match[3];
                    }
                }
            }
            return data;
        }
    }

    function AttachEventToWidgets() {
        if ($('#nonFullScreenMark').length === 0)
            return;

        $('.widget').unbind();
        $('.widget').dblclick(function (e) {

            let elem = $(this)
            clickedWidget = $(elem).prop('id');

            if ($(this).parent().prop('id') === 'gridForAdd')
                return;

            if (clickedWidget * 1 === 0) {

                $('#UpdateWidget').hide();
                $('#ResizeWidget').hide();
                $('#ConfigWidget').hide();
                $('#DeleteWidget').hide();
                $('#PinWidget').hide();
                $('#UnPinWidget').hide();
                $('#RenameWidget').hide();
                $('#DeleteWidgetSplitter').hide();
            }
            else {
                $('#UpdateWidget').show();
                $('#ResizeWidget').show();
                $('#DeleteWidgetSplitter').show();
                $('#RenameWidget').show();

                if (widgets[clickedWidget].HasConfiguration)
                    $('#ConfigWidget').show();
                else
                    $('#ConfigWidget').hide();

                if (widgets[clickedWidget].Removable)
                    $('#DeleteWidget').show();
                else
                    $('#DeleteWidget').hide();

                if (widgets[clickedWidget].Draggable) {
                    $('#PinWidget').show();
                    $('#UnPinWidget').hide();
                }
                else {
                    $('#PinWidget').hide();
                    $('#UnPinWidget').show();
                }
            }

            $('#ContextMenu').css('left', e.clientX);
            $('#ContextMenu').css('top', e.clientY);
            $('#ContextMenu').css('display', 'block');
        });
    }

    function SaveOrder(withreload, callback = false) {
        $('#orderChangedLabel').hide();
        $('#orderSavingLabel').show();

        $('#grid').addClass('disDiv');

        let data = [];
        let divs = $('#grid').children('div');
        divs.each(e => {
            let id = $(divs[e]).prop('id') * 1;
            if (id !== 0)
                data.push(GetWidgetSize(id));
        });

        var formData = new FormData();
        formData.append('data', JSON.stringify(data));

        $.ajax({
            type: "POST",
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            url: '/Dashboard/SaveOrder/',
            success: function (response) {
                if (response !== null && response.success === true) {
                    if (withreload)
                        location.reload();
                    else {
                        $('#grid').removeClass('disDiv');
                        $('#orderSavingLabel').hide();
                        if (callback !== null)
                            callback();
                    }


                }
            }
        });
    }

    function UpdateSizePrevice(x, y) {
        let preview = [
            [$('#prS1'), $('#prS2'), $('#prS3')],
            [$('#prS4'), $('#prS5'), $('#prS6')],
            [$('#prS7'), $('#prS8'), $('#prS9')]
        ];

        $('.square').removeClass('redSquare');

        for (var i = 0; i < x; i++)
            for (var j = 0; j < y; j++) {
                preview[j][i].addClass('redSquare');
            }
    }

    function GeneratewidgetForAdd() {
        let value = $('#widgetsForAdd').val();
        $('#gridForAdd').empty();
        $('#widgetTitle').val($('#widgetsForAdd option:selected').text());

        if (value !== '') {
            $('#widgetsForAdd').addClass('disDiv');

            $.ajax({
                type: "POST",
                url: '/Dashboard/GetEmpty/' + value,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        let data = new Object();
                        data.xs = response.widget.SizeXS;
                        data.sm = response.widget.SizeSM;
                        data.md = response.widget.SizeMD;
                        data.lg = response.widget.SizeLG;
                        data.dragable = response.widget.Draggable;

                        CreateWidget(response.widget.ID, data, true, response.widget.HasUpdateAnimation);
                        widgets[response.widget.ID] = {
                            UID: response.widget.UID,
                            Removable: response.widget.Removable,
                            Draggable: response.widget.Draggable,
                            HasConfiguration: response.widget.HasConfiguration,
                            Title: $('#widgetTitle').val()
                        };
                        RefreshWidgetData(response.widget.ID, response.widget.UID);
                        AttachEventToWidgets();
                        $('#widgetsForAdd').removeClass('disDiv');
                    }
                }
            });
        }
    }

    function Autorefresh() {
        if ($('#refreshWidgets').val() === 'true') {
            let interval = $('#refreshInterval').val() * 1000;

            console.log('Start to refresh. Time: ' + new Date().toLocaleTimeString() + '. Timeout: ' + interval);

            UpdateWidget(true, () => { setTimeout(Autorefresh, interval); });
        }
    }

    function RunTimeout() {
        setTimeout(Autorefresh, $('#refreshInterval').val() * 1000);
    }

    function ShowWidgetAbout(UID) {
        $.ajax({
            type: "POST",
            url: '/Dashboard/GetWidgetInfo/' + UID,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#aboutName').text(response.Name);
                    $('#aboutVersion').text(response.Version);
                    $('#aboutAuthor').text(response.Author);
                    $('#aboutDescription').text(response.Description);

                    $('#aboutWidgetmodal').modal('show');
                }
            }
        });
    }

    function CloseLeftSideMenu() {
        if ($('#CloseLeftSide').prop('checked'))
            $('#MenuHamburger').click();
    }

    function AutoRefreshAutorefreshed() {
        for (key in widgetsToAutoRefresh) {
            SendRequestAutoRefresh(key, widgetsToAutoRefresh[key]);
        }
    }

    //open settings
    $('#settingsBtn').on('click', () => {
        $('.settings').slideDown('fast');
        $('.addwidget').slideUp('fast');
        $('.access').slideUp('fast');
    });

    //cancel, close settings
    $('#cancelSettingsButton').on('click', () => {
        $('.settings').slideUp('fast');
    });

    //open add widget settings
    $('#createwidgetBtn').on('click', () => {
        $('#widgetsForAdd').val('');
        $('#gridForAdd').empty();
        $('.addwidget').slideDown('fast');
        $('.access').slideUp('fast');
        $('.settings').slideUp('fast');
    });

    //show access settings
    $('#settingsAccessBtn').on('click', () => {
        $('.access').slideDown('fast');
        $('.addwidget').slideUp('fast');
        $('.settings').slideUp('fast');
    });

    //close access settings panel
    $('#submitChangeAccessButton').on('click', () => {
        $('.access').slideUp('fast');
    });

    //cancel, close add widget
    $('#submitAddButton').on('click', () => {
        $('.addwidget').slideUp('fast');
    });

    //show/hide for/add seciton
    $('#widgetsForAdd').change(GeneratewidgetForAdd);

    //show label when order a changed
    $('#grid').on('dragend.lt.grid', () => { $('#orderChangedLabel').show(); });

    //save dashboard order
    $('#saveOrder').on('click', function () {
        SaveOrder(true);
    });

    //click outside (close cm)
    $(window).click(() => { $('#ContextMenu').hide(); });

    //update widget
    $('#UpdateWidget').on('click', () => { UpdateWidget(false); });

    //cancel changed order
    $('#cancelChagesOrder').on('click', () => {
        $('#orderChangedLabel').hide();
        $('#grid').empty();
        widgets = {};
        LoadWidgets();
    });

    //show widget configuration
    $('#ConfigWidget').on('click', () => {
        if (clickedWidget === null)
            return;

        $('#widgetConfig').load('/Dashboard/GetConfiguration/' + clickedWidget + '/' + widgets[clickedWidget].UID, () => { $('#widgetConfigModal').modal('show'); });
    });

    //show modal for rename widget
    $('#RenameWidget').on('click', () => {
        if (clickedWidget === null)
            return;

        $('#newWidgetTitle').val(widgets[clickedWidget].Title);
        $('#renameWidgetmodal').modal('show');
    });

    //cancel rename
    $('#cancelSetTitle').on('click', () => { $('#renameWidgetmodal').modal('hide'); });

    //save a new name
    $('#setWidgetTitle').on('click', () => {
        if (clickedWidget === null)
            return;

        $('#renameWidgetmodal').modal('hide');

        $.ajax({
            type: "POST",
            url: '/Dashboard/Rename/' + clickedWidget + '/?NewName=' + encodeURIComponent($('#newWidgetTitle').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    widgets[clickedWidget].Title = response.Title;
                    RefreshWidgetData(clickedWidget);
                }
            }
        });
    });

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;   //time in ms, 0.75 second for example
    var $input = $('#widgetTitle');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            if ($('#gridForAdd').children().length > 0) {
                let id = $($('#gridForAdd').children()[0]).prop('id');
                widgets[id].Title = $('#widgetTitle').val();
                SendRefreshRequest(id);
            }
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //show modal to delete a widget
    $('#DeleteWidget').on('click', () => {
        $('#deleteConfirmbtn').prop('disabled', false);
        $('#cannotDeleteWidget').hide();
        $('#deleteWidgetmodal').modal('show');
    });

    //delete widget confirm
    $('#deleteConfirmbtn').on('click', () => {
        if (clickedWidget === null)
            return;

        $('#deleteConfirmbtn').prop('disabled', true);

        $.ajax({
            type: "POST",
            url: '/Dashboard/Delete/' + clickedWidget,
            traditional: true,
            success: function (response) {
                if (response !== null) {
                    if (response.success) {
                        $('#' + clickedWidget).remove();
                        $('#deleteWidgetmodal').modal('hide');
                    }
                    else {
                        $('#cannotDeleteWidget').slideDown('fast');
                    }
                }
            }
        });
    });

    //pin widget
    $('#PinWidget').on('click', () => {
        if (clickedWidget === null)
            return;

        widgets[clickedWidget].Draggable = false;
        $('#orderChangedLabel').show();
        $('#' + clickedWidget).addClass('staticWidget');
        $('#' + clickedWidget).attr('draggable', false);
        $('#' + clickedWidget).removeClass('activeWidget');
    });

    //unpin widget
    $('#UnPinWidget').on('click', () => {
        if (clickedWidget === null)
            return;

        widgets[clickedWidget].Draggable = true;
        $('#orderChangedLabel').show();
        $('#' + clickedWidget).addClass('activeWidget');
        $('#' + clickedWidget).attr('draggable', true);
        $('#' + clickedWidget).removeClass('staticWidget');
    });

    //show modal for resize
    $('#ResizeWidget').on('click', () => {
        if (clickedWidget === null)
            return;

        let data = GetWidgetSize(clickedWidget);
        let size = $('#grid').ltSize();

        let x = data[size].w;
        let y = data[size].h;

        $('#newWidgetSize').val(x + 'X' + y);
        UpdateSizePrevice(x * 1, y * 1);

        $('#resizeWidgetmodal').modal('show');
    });

    //update preview for size
    $('#newWidgetSize').change(() => {
        let value = $('#newWidgetSize').val().split('X');
        UpdateSizePrevice(value[0] * 1, value[1] * 1);
    });

    //change size confirm
    $('#confirmResize').on('click', () => {
        $('#resizeWidgetmodal').modal('hide');

        if (clickedWidget === null)
            return;

        let value = $('#newWidgetSize').val().split('X');

        setTimeout(() => {
            $('#grid').ltGrid('reposition', $('#' + clickedWidget).closest('.lt'), { w: value[0] * 1, h: value[1] * 1 });
            $('#orderChangedLabel').show();
        }, 300);
    });

    //delete widget in the trash
    $('#gridForDelete').on('dragend.lt.grid', () => { $('#gridForDelete').empty(); });

    //show about widget modal
    $('#AboutWidget').on('click', () => {
        if (clickedWidget === null)
            return;

        ShowWidgetAbout(widgets[clickedWidget].UID);
    });
    $('.widgetInfoaccess').on('click', function () {
        ShowWidgetAbout($(this).data('uid'));
    });

    //generate a new widget for add
    $('#addEmptyToField').on('click', GeneratewidgetForAdd);

    //refresh all widgets
    $('#UpdateAll').on('click', () => { UpdateWidget(true); });

    //save settings
    $('#submitSettingsButton').on('click', () => {
        $('.settings').slideUp('fast');

        let movement = $('#DisableWidgetMovement').prop('checked');
        let autosort = $('#AutoSortWidgets').prop('checked');
        let refresh = $('#RefreshWidgets').prop('checked');
        let closeleftside = $('#CloseLeftSide').prop('checked');
        let refreshInterval = $('#RefreshInterval').val() * 1;

        $.ajax({
            type: "POST",
            url: '/Dashboard/SaveBoardSettings/?Draggable=' + movement + '&Sort=' + autosort + '&Refresh=' + refresh + '&CloseLeftSide=' + closeleftside + '&RefreshInterval=' + refreshInterval,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    //Settings for movement
                    if (movement) {
                        $('#grid').removeClass('disableDashboard');
                    }
                    else {
                        $('#grid').addClass('disableDashboard');
                    }

                    //Settings for change autosort
                    if (autosort) {
                        $('#grid').ltGrid('option', 'compact', true);
                    }
                    else {
                        $('#grid').ltGrid('option', 'compact', false);
                    }

                    //Settings for autorefresh interval
                    if (refresh) {
                        $('#refreshWidgets').val('true');
                        $('#RefreshIntervalSection').removeClass('disDiv');
                        RunTimeout();
                    }
                    else {
                        $('#refreshWidgets').val('false');
                        $('#RefreshIntervalSection').addClass('disDiv');
                    }
                    $('#refreshInterval').val(refreshInterval);
                }
            }
        });
    });

    //cancel back to default board settings
    $('#cancelSettingsButton').on('click', () => {
        $('.settings').slideUp('fast');

        $.ajax({
            type: "POST",
            url: '/Dashboard/DefaultBoardSettings/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#DisableWidgetMovement').prop('checked', response.Draggable)
                    $('#AutoSortWidgets').prop('checked', response.AutoSort)
                    $('#RefreshWidgets').prop('checked', response.Refresh)
                    $('#CloseLeftSide').prop('checked', response.CloseLeftSide)
                    $('#RefreshInterval').val(response.RefreshInterval)
                    $('#refreshInterval').val(response.RefreshInterval)
                    $('#refreshWidgets').val(response.Refresh ? 'true' : 'false');

                    if (response.Refresh) {
                        $('#RefreshIntervalSection').removeClass('disDiv');
                    }
                    else {
                        $('#RefreshIntervalSection').addClass('disDiv');
                    }
                }
            }
        });
    });

    //enable/disable autorefresh interval filed
    $('#RefreshWidgets').change(() => {
        if ($('#RefreshWidgets').prop('checked')) {
            $('#RefreshIntervalSection').removeClass('disDiv');
        }
        else {
            $('#RefreshIntervalSection').addClass('disDiv');
        }
    });

    //changed widget access level
    $('.id-access').change(function () {
        $.ajax({
            type: "POST",
            url: '/Dashboard/WidgetAccess/' + $(this).data('uid') + '/?Level=' + $(this).prop('checked'),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success !== true) {
                    $(this).prop('checked', !$(this).prop('checked'));
                }
            }
        });
    });

    //show modal for delete forbidden
    $('#deleteforbiddenBtn').on('click', () => { $('#deleteForbiddenWidgets').modal('show'); });

    //confirm delete forbidden
    $('#deleteForbiddenConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Dashboard/RemoveForbidden',
            traditional: true
        });
    });

    //hide f11 advice if exist
    if ($('#f11Advice').length > 0)
        setTimeout(() => {
            $('#f11Advice').slideUp('fast');
        }, 3000);

    setTimeout(CloseLeftSideMenu, 500);
    LoadWidgets();
    setTimeout(AutoRefreshAutorefreshed, autorefresInterval * 1000);
});