﻿$(document).ready(() => {
    let interval = 2000;
    let timerID = null;
    let selectedCall = null;

    function ExpandLeftMenu() {
        try {
            if (ObserversIsLoaded) {
                ShowObservers('ObserverMenu', true);
                ShowObserversContent('ObserverMenu_' + $('#ProfileName').val().replace(' ', '_'));
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }

    }

    function UpdateButtons() {
        $('#btnDrop').prop('disabled', selectedCall === null);
    }

    function AttachEventsToTable() {
        if (selectedCall !== null) {
            let row = $('tr > td[data-name="ConnectionIdentifier"]:contains("' + selectedCall + '")').filter(function () {
                return $(this).text() === selectedCall;
            }).parent();

            if (row.length > 0) {
                $(row).addClass('selected');
            }
            else {
                selectedObs = null;
            }
        }

        $('#tariscope-acalls tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedCall = null;
            }
            else {
                selectedCall = $(this).find('td[data-name="ConnectionIdentifier"]').text();
                $('#tariscope-acalls tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtons();
        });

        UpdateButtons();


        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/Observers/ActiveCalls/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        clearTimeout(timerID);
                        Load();
                    }
                }
            });
        });

        timerID = setTimeout(Load, interval);
    }

    function Load() {
        $('#activeCallsTable').load('/Observers/LoadActiveCalls/' + encodeURIComponent($('#ProfileName').val()), AttachEventsToTable);
    }

    //try to drop call
    $('#btnDrop').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Observers/ActiveCalls/Drop/' + encodeURIComponent($('#ProfileName').val()) + '/' + encodeURIComponent(selectedCall),
            traditional: true
        });

        selectedCall = null;
    });

    Load();
    ExpandLeftMenu();
});