﻿$(document).ready(() => {
    let value = null;
    let acts = ['Actions_0_', 'Actions_1_', 'Actions_2_', 'Actions_3_', 'Actions_4_', 'Actions_5_', 'Actions_6_'];

    function initSelect2() {
        $('#Actions_' + value + '_').select2({
            theme: "bootstrap",
            templateSelection: function (data) {
                var $result = $('<p style="margin-top: 5px;">' + data.text + '</p>');
                return $result;
            }
        });
    }

    function UpdateSections() {
        value = $('#ActionType').val() * 1;

        $('#Actions_' + value + '_').show();
        $('.select2-container').hide();

        initSelect2();

        if (value === 4) {
            $('#connectIntervalSection').hide();
            $('#actionIntervalSection').show();
        }
        else if (value === 2 || value === 3) {
            $('#actionIntervalSection').hide();
            $('#connectIntervalSection').show();
        }
        else {
            $('#actionIntervalSection').hide();
            $('#connectIntervalSection').hide();
        }
    }

    function initdatetime() {
        //init datetimepicker
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),
            locale: $('#LocaleThread').val(),
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepicker').datetimepicker(options);
    }

    function ExpandLeftMenu() {
        try {
            if (ObserversIsLoaded) {
                ShowObservers('ObserverMenu', true);
                ShowObserversContent('ObserverMenu_' + $('#OBSName').val().replace(' ', '_'));
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }

    }

    function UpdatePreview() {
        for (var i = 0; i < acts.length; i++) {
            if ($(`#${acts[i]}`).val()) {
                $(`#${acts[i]}1`).show();
                $(`#${acts[i]}2`).hide();
            }
            else {
                $(`#${acts[i]}2`).show();
                $(`#${acts[i]}1`).hide();
            }
        }
    }

    function SetEventForPreview() {
        for (var i = 0; i < acts.length; i++) {
            $(`#${acts[i]}`).change(UpdatePreview);
        }
    }

    //resize window
    window.onresize = () => { initSelect2(); };

    //update sections
    $('#ActionType').change(UpdateSections);

    //open modal with editor for script
    $('#btnEditScenario').on('click', () => {
        let path = $('#Actions_' + value + '_').val();

        if (!(!path || !path.trim())) {
            $('#editScriptName').text(path.replace(/^.*[\\\/]/, ''));
            $('#modalEditorBody').load('/Observers/GetEditor/?path=' + encodeURIComponent(path), () => {

                window.SQLEditor.on("change", () => {
                    $('#btnSaveScript').show();
                });

                $('#btnSaveScript').hide();
                $('#editmodal').modal('show');
            });
        }
    });

    //save edited filter
    $('#btnSaveScript').on('click', () => {
        let path = $('#Actions_' + value + '_').val();

        $.ajax({
            type: "POST",
            url: '/Observers/SaveScript/?path=' + encodeURIComponent(path),
            traditional: true,
            data: { code: window.SQLEditor.getValue() },
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#scriptSavedLbl').slideDown('fast');
                    setTimeout(() => { $('#scriptSavedLbl').slideUp('fast'); }, 2500);
                    $('#btnSaveScript').hide();
                }
            }
        });
    });

    SetEventForPreview();
    UpdatePreview();
    UpdateSections();
    initdatetime();
    ExpandLeftMenu();
});