﻿function GetEmptyRow(id) {
    return '<tr data-id="0" class="treegrid-0 treegrid-parent-' + id + ' hide"><td class="emptyRow" colspan="' + (isProvider ? 6 : 5) + '">' + $('#loadingLabel').val() + '</td></tr>';
}

$(document).ready(() => {
    function InitTree() {
        $('.tree').treegrid({
            expanderExpandedClass: 'glyphicon glyphicon-minus',
            expanderCollapsedClass: 'glyphicon glyphicon-plus',
            initialState: 'collapsed',
            onExpand: OnExpandNode
        });
    }

    function OnExpandNode() {
        let id = $(this).data('id');
        let top = $('tr[data-id="' + id + '"]');

        if ($(top).attr('loaded') === 'false') {
            $.ajax({
                type: "POST",
                async: true,
                url: '/PersonalArea/Service/Destinations/Childs/' + id + (isProvider ? '/?ProviderID=' + providerID : ''),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        response.childs.forEach(e => {
                            if ($('.treegrid-' + e.ID).length === 0) {
                                $('.tree').treegrid('attachNode', GetRow(e, true), true);
                                $('.tree').treegrid('attachNode', GetEmptyRow(e.ID), false);
                                $('tr[data-id="' + e.ID + '"]').treegrid('initState');
                            }
                        });
                        $('tr[class="treegrid-0 treegrid-parent-' + id + '"]').remove();
                    }

                    $('tr[class="treegrid-0 treegrid-parent-' + id + '"]').find('td').text($('#emptyLabel').val());
                    $(top).attr('loaded', 'true');
                }
            });
        }
    }

    InitTree();
});