﻿$(document).ready(() => {
    let selectedReport = null;
    let selectedSavedReport = null;
    FixedHeader();

    function FixedHeader() {
        var header = document.getElementById("reportheader");                 //for sticky header
        var sticky = header.offsetTop;
        $(window).on("scroll", function () {
            //for sticky header
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });
    }

    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/Reporting/Export/?type=' + t + '&FolderName=' + encodeURIComponent($("#reportGroup").val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/Reporting/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function UpdateButtonsSavedUI() {
        if (selectedSavedReport === null) {
            $("#btnOpen").attr("disabled", true);
            $("#btnDownlopad").attr("disabled", true);
            $("#btnDelte").attr("disabled", true);
        }
        else {
            $("#btnOpen").attr("disabled", false);
            $("#btnDownlopad").attr("disabled", false);
            $("#btnDelte").attr("disabled", false);
        }
    }

    function AttachEventsToSavedTable() {
        selectedSavedReport = null;

        $('#tariscope-saved-reports tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedSavedReport = null;
            }
            else {
                selectedSavedReport = $(this).find('td[data-name="FilePath"]').text();
                $('#tariscope-saved-reports tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtonsSavedUI();
        });
        UpdateButtonsSavedUI();
    }

    function UpdateButtonsUI() {
        let isShare = $('#reportGroup').val() === "-3";

        $("#btnRun").attr("disabled", selectedReport === null);

        if (isShare) {
            $("#btnShare").attr("disabled", true);
            $("#btnUnShare").attr("disabled", selectedReport === null);
        }
        else {
            $("#btnShare").attr("disabled", selectedReport === null);
            $("#btnUnShare").attr("disabled", true);
        }
    }

    function RowClick(e) {
        if (e.hasClass('selected')) {
            e.removeClass('selected');
            selectedReport = null;
        }
        else {
            selectedReport = e.find('th[data-name="FilePath"]').text();
            $('#tariscope-reports tr.selected').removeClass('selected');
            e.addClass('selected');
        }

        UpdateButtonsUI();
    }

    function AttachEventsToTable() {
        selectedReport = null;

        $('#tariscope-reports tbody').on('click', 'tr', function () { RowClick($(this)); });
        $('#tariscope-reports tbody').on('dblclick', 'tr', function () {
            RowClick($(this));
            if (selectedReport != null)
                $('#btnRun').click();
        });

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/Reporting/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        LoadReports();
                    }
                }
            });
        });

        UpdateButtonsUI();
        ShowSpinner(false);
    }

    function LoadReports() {
        $('#reportsTable').load("/Reporting/Search/?FolderName=" + encodeURIComponent($("#reportGroup").val()) + "&SearchParam=" + encodeURIComponent($("#tbSearch").val()), AttachEventsToTable);
    }

    function GetReports() {
        ShowSpinner(true);
        //get saved selected group last time
        $.ajax({
            type: "POST",
            url: '/Reporting/GetSavedGroup/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $("#reportGroup").val(response.group);
                    LoadReports();
                }
            }
        });
    }

    function LoadHistory(callback = null) {
        $('#prevReportsContainer').load('/Reporting/History', () => {
            AttachEventsToSavedTable();
            if (callback !== null)
                callback();
            $('#savedReport').modal('show');
        });
    }

    var typingTimer;                //timer identifier
    var doneTypingInterval = 700;   //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            LoadReports();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //load reports if changed group
    $('#reportGroup').change(() => {
        ShowSpinner(true);
        LoadReports();
    });

    //open modal for build report
    $('#btnRun').on('click', () => {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/Reporting/GetReportData/?ReportFile=' + encodeURIComponent(selectedReport),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#reportTitleName').text(response.report.Data.Name);
                    $('#reportName').text(response.report.Data.Name);
                    $('#reportDescription').text(response.report.Description);
                    $('#reportOwnerName').text(response.report.Author);
                    $('#reportDate').text(response.report.LastModificateDate);
                    $('#reportImageBase64').attr('src', 'data:image/jpeg;base64,' + response.report.Screenshot);

                    $('#ReportStartupSection').load('/Reporting/GetReportData/?ReportFile=' + encodeURIComponent(selectedReport), () => {
                        $('#reportScreenShow').show();
                        $('#reportScreenHide').hide();
                        $('#reportImageBase64').hide();

                        ShowSpinner(false);

                        SetButtonToValidate('btnRunReport');

                        $('#reportsSection').hide();
                        $('#reportRunSection').show();
                    }); 
                }
                else {
                    ShowSpinner(false);
                    console.log('Report null');
                }
            }
        });
    });

    //show screenshot
    $('#reportScreenShow').on('click', () => {
        $('#reportScreenShow').hide();
        $('#reportScreenHide').show();
        $('#reportImageBase64').slideDown('fast');
    });

    //hide screenshot
    $('#reportScreenHide').on('click', () => {
        $('#reportScreenShow').show();
        $('#reportScreenHide').hide();
        $('#reportImageBase64').slideUp('fast');
    });

    //run report
    $('#btnRunReport').on('click', () => {
        let vars = GetVariablesJsonString();

        $('#reportsSection').show();
        $('#reportRunSection').hide();
        ShowSpinner(true);

        let model = new FormData();

        model.append("ReportFilePath", selectedReport);
        model.append("JsonVars", vars);
        model.append("FileFormat", $('#reportCurrentType').val());
        model.append("IsLandscape", $('#reportCurrentOrient').val() * 1 == 1);
        model.append("MarginL", $('#reportCurrentMarignLeft').val());
        model.append("MarginR", $('#reportCurrentMarignRight').val());
        model.append("MarginT", $('#reportCurrentMarignTop').val());
        model.append("MarginB", $('#reportCurrentMarignBottom').val());
        model.append("PageFormat", $('#reportCurrentPageFormat').val());

        $.ajax({
            type: "POST",
            url: '/Reporting/RunReport/',
            data: model,
            processData: false,
            contentType: false,
            traditional: true,
            success: function (response) {
                ShowSpinner(false);
                if (response !== null && response.success === true) {
                    $('#ReportInQueueModal').modal('show');
                }
            }
        });
    });

    //cancel run
    $('#btnCancelRunReport').on('click', () => {
        $('#ReportStartupSection').empty();
        $('#reportsSection').show();
        $('#reportRunSection').hide();
    });

    //open history
    $('#btnHistory').on('click', () => {
        ShowSpinner(true);
        LoadHistory(() => { ShowSpinner(false); });
    });

    //delete saved
    $('#btnDelte').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Reporting/DeleteHistoryItem/?FileName=' + encodeURIComponent(selectedSavedReport),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadHistory(null);
                }
            }
        });
    });

    //download saved
    $('#btnDownlopad').on('click', () => {
        window.open('/Reporting/Download/' + encodeURIComponent(selectedSavedReport), '_blank');
    });

    //delete all
    $('#btnDeleteAll').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Reporting/DeleteAllHistoryItems/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadHistory(null);
                }
            }
        });
    });

    //open saved report
    $('#btnOpen').on('click', () => {
        window.location = "/Reporting/Open?FileName=" + encodeURIComponent(selectedSavedReport);
    });

    //open modal for confirm share report
    $('#btnShare').on('click', () => {
        $('#alredyPublick').hide();
        $('#ShareConfirm').prop('disabled', false);
        $('#confirmShare').modal('show');
    });

    //confirm share
    $('#ShareConfirm').on('click', () => {
        let model = new FormData();

        model.append("ReportFilePath", selectedReport);

        $.ajax({
            type: "POST",
            url: '/Reporting/ShareReport/',
            data: model,
            processData: false,
            contentType: false,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#confirmShare').modal('hide');
                }
                else {
                    $('#alredyPublick').slideDown('fast');
                    $('#ShareConfirm').prop('disabled', true);
                }
            }
        });
    });

    //show modal for confirm unshare report
    $('#btnUnShare').on('click', () => { $('#confirmUnShare').modal('show'); });

    //confirm unshare
    $('#UnShareConfirm').on('click', () => {
        let model = new FormData();

        model.append("ReportFilePath", selectedReport);

        $.ajax({
            type: "POST",
            url: '/Reporting/UnShareReport/',
            data: model,
            processData: false,
            contentType: false,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadReports();
                    $('#confirmUnShare').modal('hide');
                }
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //get page format
    $('#btnPageFormat').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Reporting/GetPageFormat/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#reportOrient').val(response.ori);
                    $('#reportMarignLeft').val(response.mLeft);
                    $('#reportMarignRight').val(response.mRight);
                    $('#reportMarignTop').val(response.mTop);
                    $('#reportMarignbottom').val(response.mBottom);
                    $('#reportPageFormat').val(response.format);

                    $('#savedPageFormatReport').modal('show');
                }
            }
        });
    });

    //save page format
    $('#savePageFormat').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Reporting/SetPageFormat/' + $('#reportOrient').val() + '/' + $('#reportMarignLeft').val() + '/' + $('#reportMarignRight').val() + '/' + $('#reportMarignTop').val() + '/' + $('#reportMarignbottom').val() + '/' + $('#reportPageFormat').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#savedPageFormatReport').modal('hide');
                }
            }
        });
    });

    $('#reportFile').on('change', () => {
        let data = new FormData();
        let file = ($('#reportFile'))[0].files[0];

        if (file) {
            data.append('reportFile', file)

            ShowSpinner(true);

            $.ajax({
                type: "POST",
                url: '/Reporting/GetFileData/',
                traditional: true,
                data: data,
                datatype: 'json',
                contentType: false,
                processData: false,
                success: function (response) {
                    if (response !== null && response.success === true) {

                        selectedReport = response.report.Data.FilePath;

                        $('#reportTitleName').text(response.report.Data.Name);
                        $('#reportName').text(response.report.Data.Name);
                        $('#reportDescription').text(response.report.Description);
                        $('#reportOwnerName').text(response.report.Author);
                        $('#reportDate').text(response.report.LastModificateDate);
                        $('#reportImageBase64').attr('src', 'data:image/jpeg;base64,' + response.report.Screenshot);

                        $('#ReportStartupSection').load('/Reporting/GetReportData/?ReportFile=' + encodeURIComponent(selectedReport), () => {
                            $('#reportScreenShow').show();
                            $('#reportScreenHide').hide();
                            $('#reportImageBase64').hide();

                            ShowSpinner(false);

                            SetButtonToValidate('btnRunReport');

                            $('#reportsSection').hide();
                            $('#reportRunSection').show();
                        });
                    }
                    else {
                        ShowSpinner(false);
                        console.log('Report null');
                    }
                }
            });
        }
    });

    $('#btnImportFile').on('click', () => {
        $('#reportFile').click();
    });

    GetReports();
});