﻿$(document).ready(function () {
    let selectedSvc = null;

    function initDateTimepickers() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepickerFrom').datetimepicker(daytimeOpitions);
        $('#datetimepickerTo').datetimepicker(daytimeOpitions);
    }

    function UpdateSvcButtonsUI() {
        if (selectedSvc !== null) {
            $('#btnEditSvc').prop('disabled', false);
            $('#btnDeleteSvc').prop('disabled', false);
        }
        else {
            $('#btnEditSvc').prop('disabled', true);
            $('#btnDeleteSvc').prop('disabled', true);
        }
    }

    function AttachEventsToSvc() {
        selectedSvc = null;

        $('#tariscope-service-in-bundles tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedSvc = null;
            }
            else {
                selectedSvc = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-service-in-bundles tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateSvcButtonsUI();
        });

        UpdateSvcButtonsUI();
    }

    function LoadService() {
        $('#svcTable').load('/Services/Bundles/GetSvcInBundle/' + $('#bundleID').val(), AttachEventsToSvc);
    }

    //show modal for add service int bundle
    $('#btnAddSvc').on('click', () => {
        $('#addsvc').show();
        $('#editsvc').hide();

        $('#svcID').val('0');

        if ($('#bundleID').val() * 1 !== 0) { $('#svcWillBeCharged').show(); }
        else { $('#svcWillBeCharged').hide(); }

        $('#svcWillBeEdited').hide();

        $($('#svcSource')).val($('option:first', $('#svcSource')).val());
        $('#svcSource').prop('disabled', false);
        $('#svcAmount').val('1');

        try {
            $('#datetimepickerFrom').data("DateTimePicker").setDate(null);
            $('#datetimepickerTo').data("DateTimePicker").setDate(null);
        } catch (e) { console.log(e); }

        $('#FromEnabled').prop('checked', false);
        $('#ToEnabled').prop('checked', false);

        $('#addServiceBundlemodal').modal('show');
    });

    //from/to dates checkboxes
    $('#FromEnabled').change(function () {
        try {
            $('#datetimepickerFrom').data("DateTimePicker").setDate($(this).prop('checked') === true ? new Date() : null);
        } catch (e) { console.log(e); }
    });
    $('#ToEnabled').change(function () {
        try {
            $('#datetimepickerTo').data("DateTimePicker").setDate($(this).prop('checked') === true ? new Date() : null);
        } catch (e) { console.log(e); }
    });

    //send service to server
    $('#addEditSvc').on('click', () => {
        $('#addServiceBundlemodal').modal('hide');
        ShowSpinner(true);

        let model = new FormData();

        model.append("ID", $('#svcID').val());
        model.append("BundleID", $('#bundleID').val() * 1);
        model.append("ServiceID", $('#svcSource').val() * 1);
        model.append("Amount", $('#svcAmount').val() * 1);
        model.append("FromEnabled", $('#FromEnabled').prop('checked'));
        model.append("ToEnabled", $('#ToEnabled').prop('checked'));
        model.append("ConnectionDate", $('#datetimepickerFrom').data('date'));
        model.append("DisconnectDate", $('#datetimepickerTo').data('date'));

        $.ajax({
            type: "POST",
            url: '/Services/Bundles/SendSvc/',
            data: model,
            processData: false,
            contentType: false,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    LoadService();
                }
            }
        });
    });

    //show modal for delete service form bundle
    $('#btnDeleteSvc').on('click', () => {
        $('#confirmDelete').modal('show');
    });

    //confirm deleting svc from bundle
    $('#DeleteConfirm').on('click', () => {
        $('#confirmDelete').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/Services/Bundles/DeleteSvc/' + $('#bundleID').val() + '/' + selectedSvc,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    LoadService();
                }
            }
        });
    });

    //open modal for edit svc
    $('#btnEditSvc').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Services/Bundles/GetSvc/' + $('#bundleID').val() + '/' + selectedSvc,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log(response.item);

                    $('#addsvc').hide();
                    $('#editsvc').show();

                    $('#svcID').val(response.item.ID);

                    $('#editsvcName').text(response.item.Name);

                    if ($('#bundleID').val() * 1 !== 0) { $('#svcWillBeEdited').show(); }
                    else { $('#svcWillBeEdited').hide(); }

                    $('#svcWillBeCharged').hide();

                    $($('#svcSource')).val(response.item.ServiceID);
                    $('#svcSource').prop('disabled', true);
                    $('#svcAmount').val(response.item.Amount);

                    try {
                        $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date(response.item.ConnectionDate));
                        $('#datetimepickerTo').data("DateTimePicker").setDate(new Date(response.item.DisconnectDate));
                    } catch (e) { console.log(e); }

                    $('#FromEnabled').prop('checked', response.item.FromEnabled);
                    $('#ToEnabled').prop('checked', response.item.ToEnabled);

                    $('#addServiceBundlemodal').modal('show');
                }
            }
        });
    });

    //cancel add/edit
    $('#btnCancel').on('click', () => {
        window.location = "/Services/Bundles";
    });

    initDateTimepickers();
    LoadService();
});