﻿$(document).ready(() => {
    let fields = [];
    let fieldsDate = [];

    function initdatetime() {
        //init datetimepicker
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),
            locale: $('#LocaleThread').val(),
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true,
            format: 'L'
        };

        $('#datetimepickerMultiple').datetimepicker(options);
        $('#datetimepickerTo').datetimepicker(options);
        $('#datetimepickerFrom').datetimepicker(options);
        $('#datetimepickerContract').datetimepicker(options);

        $('#datetimepickerMultiple').data("DateTimePicker").setDate(new Date());
    }

    function AddToFileds(name) {
        console.log(name + ' was edited.');
        if (name !== undefined && fields.indexOf(name) === -1)
            fields.push(name);
    }

    function AddToDTFileds(name) {
        console.log(name + ' was edited.');
        if (name !== undefined && fieldsDate.indexOf(name) === -1)
            fieldsDate.push(name);
    }

    function CloseEditSection() {
        $('#editTitle').hide();
        $('#accountTitle').show();
        $('#accountsSection').slideDown('fast');
        $('#additionalSection').slideUp('fast');

        UpdateFreeData();
    }

    //back to list
    $('#btnBackToAbonentFromMulti').on('click', () => {
        if (fields.length > 0 || fieldsDate.length > 0) {
            $('#unsavedModal').modal('show');
        }
        else {
            CloseEditSection();
        }
    });

    //exit without saving
    $('#exitWithourSaving').on('click', () => {
        $('#unsavedModal').modal('hide');
        CloseEditSection();
    });

    //all text imputs
    $('input[type="text"]').on('input', function () {
        AddToFileds($(this).attr('name'));
    });

    //all selectes
    $('select').change(function () {
        AddToFileds($(this).attr('name'));
    });

    //all textareas imputs
    $('textarea').on('input', function () {
        AddToFileds($(this).attr('name'));
    });

    //date checkpoxes
    $('#FromEnabled').change(() => {
        if ($('#FromEnabled').prop('checked') === true) {
            $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date());
            $('#datetimepickerFrom').removeClass('disDiv');
        }
        else {
            $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date(1900, 0));
            $('#datetimepickerFrom').addClass('disDiv');
        }

        AddToDTFileds('connectdate');
    });
    $('#ToEnabled').change(() => {
        if ($('#ToEnabled').prop('checked') === true) {
            $('#datetimepickerTo').data("DateTimePicker").setDate(new Date());
            $('#datetimepickerTo').removeClass('disDiv');
        }
        else {
            $('#datetimepickerTo').data("DateTimePicker").setDate(new Date(3000, 0));
            $('#datetimepickerTo').addClass('disDiv');
        }

        AddToDTFileds('disconnectdate');
    });
    $('#ContractEnabled').change(() => {
        if ($('#ContractEnabled').prop('checked') === true) {
            $('#datetimepickerContract').data("DateTimePicker").setDate(new Date());
            $('#datetimepickerContract').removeClass('disDiv');
        }
        else {
            $('#datetimepickerContract').data("DateTimePicker").setDate(new Date(1900, 0));
            $('#datetimepickerContract').addClass('disDiv');
        }

        AddToDTFileds('contractdate');
    });

    //dt changer
    $('#datetimepickerFrom').on('dp.change', () => { AddToDTFileds('connectdate'); });
    $('#datetimepickerTo').on('dp.change', () => { AddToDTFileds('disconnectdate'); });
    $('#datetimepickerContract').on('dp.change', () => { AddToDTFileds('contractdate'); });

    //save abonent
    $('#btnSaveMulti').on('click', () => {
        if (fields.length > 0 || fieldsDate.length > 0) {
            ShowSpinner(true);

            let editedFields = {};

            //inputs
            fields.forEach(e => {
                let val = $('input[name="' + e + '"]').val();

                if (val !== null && val !== undefined) {
                    editedFields['"' + e + '"'] = val;
                }
            });

            //selects
            fields.forEach(e => {
                let val = $('select[name="' + e + '"]').val();

                if (val !== null && val !== undefined) {
                    editedFields['"' + e + '"'] = val;
                }
            });

            //textareas
            fields.forEach(e => {
                let val = $('textarea[name="' + e + '"]').val();

                if (val !== null && val !== undefined) {
                    editedFields['"' + e + '"'] = val;
                }
            });

            var fd = new FormData();
            fd.append('AbonentPlaneFrom', $('#datetimepickerMultiple').data('date'));

            let f = JSON.stringify(editedFields);

            $.ajax({
                type: "POST",
                async: false,
                data: fd,
                datatype: 'application/octet-stream',
                contentType: false,
                processData: false,
                traditional: true,
                url: '/Subscribers/SaveMulti/?IDs=' + $('#idsforEdit').val() + '&fields=' + encodeURIComponent(f),
                success: function (response) {
                    if (response !== null && response.success === true) {
                        fields = [];
                        saved = true;

                        if (fieldsDate.length > 0) {

                            var formData = new FormData();

                            if (fieldsDate.indexOf('connectdate') !== -1) {
                                formData.append('connectdate', $('#datetimepickerFrom').data('date'));
                            }

                            if (fieldsDate.indexOf('disconnectdate') !== -1) {
                                formData.append('disconnectdate', $('#datetimepickerTo').data('date'));
                            }

                            if (fieldsDate.indexOf('contractdate') !== -1) {
                                formData.append('contractdate', $('#datetimepickerContract').data('date'));
                            }

                            $.ajax({
                                type: "POST",
                                data: formData,
                                datatype: 'application/octet-stream',
                                contentType: false,
                                processData: false,
                                traditional: true,
                                url: '/Subscribers/SaveDatesMulti/?IDs=' + $('#idsforEdit').val(),
                                success: function (response) {
                                    if (response !== null && response.success === true) {
                                        fieldsDate = [];
                                        ShowSpinner(false);
                                        $('#abonentSavedModal').modal('show');
                                    }
                                }
                            });
                        }
                        else {
                            ShowSpinner(false);
                            $('#abonentSavedModal').modal('show');
                        }
                    }
                }
            });
        }
    });

    initdatetime();
});