﻿$(document).ready(() => {
    let selectedRestr = null;

    function UpdateRestrButtonUI() {
        if (selectedRestr === null) {
            $('#btnEditRestrSection').prop('disabled', true);
            $('#btnDeleteRestrSection').prop('disabled', true);
            $('#btnRestrictManualySection').prop('disabled', true);
            $('#btnClearChargesSection').prop('disabled', true);
        }
        else {
            $('#btnEditRestrSection').prop('disabled', false);
            $('#btnDeleteRestrSection').prop('disabled', false);
            $('#btnRestrictManualySection').prop('disabled', false);
            $('#btnClearChargesSection').prop('disabled', false);
        }
    }

    function AttachEventsToRestr() {
        selectedRestr = null;

        $('#tariscope-abonent-restrs tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedRestr = null;
            }
            else {
                selectedRestr = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-abonent-restrs tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateRestrButtonUI();
        });

        UpdateRestrButtonUI();
    }

    function LoadRestrs() {
        $('#restrTable').load('/Subscribers/LoadRestrictionsTable/' + $('#restrSourceID').val() + '/?IsDepartment=' + ($('#restrSourceType').val() * 1 === 1), AttachEventsToRestr);
    }

    //set title
    $('#accountName').text($('#restrSourceName').val());
    $('#editTitle').show();
    $('#accountTitle').hide();

    //back to abonent
    $('#btnBackToAbonentFromRestr').on('click', () => {
        $('#editTitle').hide();
        $('#accountTitle').show();

        $('#additionalSection').slideUp('fast');
        $('#accountsSection').slideDown('fast');
    });

    //show modal for add restricted
    $('#btnAddRestrSection').on('click', () => {
        $('#saveRowRestrict').unbind();

        $('#restrictionCategorySelect').prop('disabled', false);
        $('#restrictionTypeSelect').prop('disabled', false);

        $('#editRowRestrictTitle').text($('#newAbrestr').val());
        $('#restrictionInfoPanel').hide();

        $('#restrictionCategorySelect').val($('option:first', $('#restrictionCategorySelect')).val());
        $('#restrictionTypeSelect').val($('option:first', $('#restrictionTypeSelect')).val());
        $('#restrictionClassinput').val('');
        $('#restrictionCreditinput').val('0');

        //add a new restriction
        $('#saveRowRestrict').on('click', () => {
            $.ajax({
                type: "POST",
                traditional: true,
                url: '/Subscribers/AddRestriction/' + $('#restrSourceID').val()
                    + '/' + $('#restrictionTypeSelect').val()
                    + '/' + $('#restrictionCategorySelect').val()
                    + '/' + $('#restrictionCreditinput').val()
                    + '/?IsDepartment=' + ($('#restrSourceType').val() * 1 === 1)
                    + '&RestrctionClass=' + encodeURIComponent($('#restrictionClassinput').val()),
                success: function (response) {
                    $('#editRowRestrictmodal').modal('hide');

                    if (response !== null && response.success === true) {
                        LoadRestrs();
                    }
                    else {
                        $('#cannotAddRestriction').modal('show');
                    }
                }
            });
        });

        $('#editRowRestrictmodal').modal('show');
    });

    //show modal for edit restricted
    $('#btnEditRestrSection').on('click', () => {
        $('#saveRowRestrict').unbind();

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetCredit/' + selectedRestr
                + '/?IsDepartment=' + ($('#restrSourceType').val() * 1 === 1),
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#editRowRestrictTitle').text($('#editAbrestr').val());
                    $('#restrictionInfoPanel').show();

                    $('#restrictionCategorySelect').prop('disabled', true);
                    $('#restrictionTypeSelect').prop('disabled', true);

                    $('#restrictionCategorySelect').val(response.cr.CategoryID === null ? 0 : response.cr.CategoryID);
                    $('#restrictionTypeSelect').val(response.cr.RestrictType);
                    $('#restrictionClassinput').val(response.cr.RestrictClass);
                    $('#restrictionCreditinput').val(response.cr.Credit);

                    $('#restrictionStatusinput').val(response.status);
                    $('#restrictionChargeinput').val(response.cr.Debit);
                    $('#restrictionAvailableinput').val(response.stats.Available);
                    $('#restrictionFromTotalinput').val(response.stats.Total);
                    $('#restrictionDistribinput').val(response.stats.Distributed);

                    //add a new restriction
                    $('#saveRowRestrict').on('click', () => {
                        $.ajax({
                            type: "POST",
                            traditional: true,
                            url: '/Subscribers/EditRestriction/' + selectedRestr
                                + '/' + $('#restrictionCreditinput').val()
                                + '/?IsDepartment=' + ($('#restrSourceType').val() * 1 === 1)
                                + '&RestrctionClass=' + encodeURIComponent($('#restrictionClassinput').val()),
                            success: function (response) {
                                $('#editRowRestrictmodal').modal('hide');

                                if (response !== null && response.success === true) {
                                    LoadRestrs();
                                }
                                else {
                                    $('#cannotAddRestriction').modal('show');
                                }
                            }
                        });
                    });

                    $('#editRowRestrictmodal').modal('show');
                }
            }
        });
    });

    //show modal for clear debit
    $('#btnClearChargesSection').on('click', () => { $('#debitClearModal').modal('show') });

    //clear debit confirm
    $('#clearDebitConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/ClearDebit/' + selectedRestr
                + '/?IsDepartment=' + ($('#restrSourceType').val() * 1 === 1),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#debitClearedModal').modal('show');
                    LoadRestrs();
                }
            }
        });
    })

    //show modal for switch restrict status
    $('#btnRestrictManualySection').on('click', () => { $('#switchRestrictStatusModal').modal('show'); });

    //confimr switch restrict status
    $('#switchRestrictStatusConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/SwitchRestrictStatus/' + selectedRestr
                + '/?IsDepartment=' + ($('#restrSourceType').val() * 1 === 1),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#switchedRestrictStatusModal').modal('show');
                    LoadRestrs();
                }
            }
        });
    });

    //show modal for delete credit
    $('#btnDeleteRestrSection').on('click', () => { $('#deleteCreditsmodal').modal('show'); });

    //confirm delete abonent credit
    $('#deleteCreditsConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/DeleteCredit/' + selectedRestr
                + '/?IsDepartment=' + ($('#restrSourceType').val() * 1 === 1),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#deleteCreditsmodal').modal('hide');
                    LoadRestrs();
                }
            }
        });
    });

    LoadRestrs();
});