﻿$(document).ready(() => {
    let selectedFile = null;
    let selectedScriptFile = null;
    let deviceID = null;
    let LastID = null;
    getScriptFilesName();

    function GetStatus() {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/ImportCalls/GetStatus/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    response.Status = JSON.parse(response.Status);

                    if (response.Status.Wait === false) {
                        $('#filesInfo').text(response.FilesLine);
                        $('#timeLeftInfo').text(response.ElapsedTimeLine);
                        $('#recordsInfo').text(response.RecordsLine);

                        $('#transferProgress').css('width', response.Status.Progress + '%');

                        $('#transferInfo').show();
                    }

                    if (response.Status.InAction === true || response.Status.Wait === true) {
                        setTimeout(GetStatus, 1000);
                    }
                    else {
                        if (response.Status.HasError === false) {
                            LastID = response.Status.LastID;

                            $('#pSuccess').text(response.ResultLine);
                            ShowTransferInfor(false);
                            $('#Successdmodal').modal('show');
                        }
                        else {
                            $('#pError').text(response.ResultLine);
                            ShowTransferInfor(false);
                            $('#Errordmodal').modal('show');
                        }
                    }
                }
            }
        });
    }

    function ShowSpinnerInfor(show) {
        /*
         * function for showing spinner message when load edit preview
         * sometimes it is to long
         */
        if (show) {
            $("#uploadCDRSmodal").modal({
                backdrop: "static",
                keyboard: false,
                show: true
            });
        }
        else {
            $("#uploadCDRSmodal").modal('hide');

            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();

            setTimeout(function () { $('body').css('padding-right', 0) }, 1000);
        }
    }

    function ShowTransferInfor(show) {
        /*
         * function for showing spinner message when load edit preview
         * sometimes it is to long
         */
        if (show) {
            $('#filesInfo').text('');
            $('#timeLeftInfo').text('');
            $('#recordsInfo').text('');
            $('#transferProgress').css('width', '0%');

            $('#transferInfo').hide();
            $("#processCDRSmodal").modal({
                backdrop: "static",
                keyboard: false,
                show: true
            });
        }
        else {
            $("#processCDRSmodal").modal('hide');

            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();

            setTimeout(function () { $('body').css('padding-right', 0) }, 1000);
        }
    }

    function AttachEventToTable() {
        //attach events to table
        selectedFile = null;

        $('#tariscope-files tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedFile = null;
            }
            else {
                selectedFile = $(this).find('td[data-name="FullName"]').text();
                $('#tariscope-files tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            $('#btnDelete').prop('disabled', selectedFile === null);
        });

        $('#btnDelete').prop('disabled', selectedFile === null);
    }

    function LoadFiles() {
        //load table with files
        $('#filesTable').load('/TariscopeViews/CallsTransfer/Get/', AttachEventToTable);//// here
    }

    //open dialog for upload files
    $('#btnAdd').on('click', () => {
        $('#FileInput').val('');
        $('#FileInput').click()
    });

    //uploading files into server (with progress)
    $("#FileInput").change(function () {
        $('#uploadProgress').css('width', '0%');

        var formData = new FormData();
        Array.from(document.getElementById("FileInput").files).forEach(e => {
            formData.append(e.name, e);
        });

        ShowSpinnerInfor(true);

        $.ajax({
            type: 'POST',
            async: true,
            url: '/TariscopeViews/ImportCalls/Upload/',
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            xhr: function () {
                var xhr = new window.XMLHttpRequest();
                xhr.upload.addEventListener("progress", function (e) {
                    if (e.lengthComputable) { $('#uploadProgress').css('width', Math.round((e.loaded / e.total) * 100) + '%'); }
                }, false);
                return xhr;
            },
            error: function (jqxhr, status, errorThrown) {
                console.log('jqxhr:');
                console.log(jqxhr);
                console.log('status:');
                console.log(status);
                console.log('errorThrown:');
                console.log(errorThrown);

            },
            success: function (response) {
                if (response.success === true) {
                    ShowSpinnerInfor(false);
                    LoadFiles();
                }
                else {
                    console.log(response.msg);
                }
            }
        });
    });

    //show dialog for delete file
    $('#btnDelete').on('click', () => { $('#confirmDelete').modal('show'); });

    //delete selected file confirm
    $('#DeleteConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/ImportCalls/DeleteCDR/?filename=' + encodeURIComponent(selectedFile),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#confirmDelete').modal('hide');
                    LoadFiles();
                }
            }
        });
    });

    //show dialog for delete all file
    $('#btnDeleteAll').on('click', () => { $('#confirmDeleteAll').modal('show'); });

    //confirm deleting all files
    $('#DeleteAllConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/ImportCalls/DeleteCDRAll',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#confirmDeleteAll').modal('hide');
                    LoadFiles();
                }
            }
        });
    });

    //show modal for select device
    $('[id="selectdeviceLink"]').on('click', () => {
        $('#modalContainer').load('/TariscopeViews/CallsTransfer/SelectDevice', () => {
            //attach events to checkboxes
            $('input[id^="SelectedDevice_"]').change(function () {
                $('input[id^="SelectedDevice_"').prop('checked', false);
                $(this).prop('checked', true);
            });

            //show modal
            $('#selectdevicemodal').modal('show');
        });
    });

    //get information about selected device
    $('#btnSelect').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/CallsTransfer/SetDevice/' + $('input[id^="SelectedDevice_"]:checked').attr('data-device'),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    deviceID = response.device.ID;

                    $('#nonelectedDevice').hide();
                    $('#selectedDevice').show();

                    $('#deviceName').text(response.device.Name);
                    $('#deviceType').text(response.device.Type);

                    $('#btnRun').prop('disabled', false);

                    $('#selectdevicemodal').modal('hide');
                }
            }
        });
    });

    //get filename from Scripts
    function getScriptFilesName() {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/ImportCalls/GetFilename',
            contentType: "application/json",
            dataType: 'json',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    var flag = false;
                    var data = response.filesName;
                    var s = $('<select id = "scriptID" />').addClass('btn btn-default dropdown-toggle');
                    if (localStorage.getItem("selValue") !== null && flag === false) {
                        $('<option />', { value: localStorage.getItem("selValue"), text: localStorage.getItem("selValue") }).appendTo(s);
                        position = data.indexOf(localStorage.getItem("selValue"));
                        if (~position) data.splice(position, 1);
                        flag = true;
                    }
                    $.each(data, function (k, v) {
                        $('<option />', { value: k, text: v }).appendTo(s);
                    });
                   
                    s.appendTo('div #dropDownFilesName');
                }
            },
            error: function () {
                alert("Error")
            }
        });
    };


    //start import
    $('#btnRun').on('click', () => {
        selectedScriptFile = $("#scriptID option:selected").text();
        localStorage.setItem("selValue", selectedScriptFile);
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/ImportCalls/Start/' + deviceID,
            traditional: true,
            data: { 'id': deviceID, 'selectedScriptFile': selectedScriptFile },
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinnerInfor(false);
                    ShowTransferInfor(true);
                    GetStatus();
                }
            }
        });
    });
    
    $('#showAddedCalls').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/SaveTransferedCallsView/' + deviceID + '/' + LastID,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    window.open('/TariscopeViews/Open/?Name=' + response.ViewName + '&Type=0&OwnerType=1&OwnerName=&Group=', '_parent');
                }
            }
        });
    });

    LoadFiles();
});