﻿$(document).ready(function () {
    let GlobalFilter = {
        period: $('#PeriodType').val(),
        year: $('#SelectedYear').val(),
        month: $('#SelectedMonthValue').val(),
        from: '',
        fromEnabled: $('#PeriodFromEnable').prop('checked'),
        to: '',
        toEnabled: $('#PeriodToEnable').prop('checked'),
        department: $('#SourceDepartment').length > 0 ? $('#SourceDepartment').val() : '-2'
    };

    let windowHeight;
    let clusterize;
    let rowIndex;

    let ClasterSize = 50;
    let Loadsize = ClasterSize * 5;
    let LoadedRows = 0;

    let SelectedRows = [];
    let SelectedField;
    let SelectedValue;
    let SelectedType;
    let SelectedRelated;

    let request = null;

    let requestForExport = null;

    let IsRecharge = false;

    let ctrlDown = false;
    let ctrlKey = 17;
    let cmdKey = 91;
    let xKey = 88;
    let cKey = 67;

    let SelectedOnly;

    //Arrays for number filter
    let selectedNumbers = [];

    function GetDate(name) {
        let dt = $('#' + name).data("DateTimePicker").getDate();
        let y = dt.year() + '';
        let m = dt.month() + 1;
        let d = dt.date();
        let h = dt.hours();
        let M = dt.minutes();
        let s = dt.seconds();

        if (m < 10)
            m = '0' + m;

        if (d < 10)
            d = '0' + d;

        if (h < 10)
            h = '0' + h;

        if (M < 10)
            M = '0' + M;

        if (s < 10)
            s = '0' + s;

        return `${y}${m}${d}${h}${M}${s}`;
    }

    function BuildUrl(method, fields = {}) {
        //const fields
        let url = '/TariscopeViews/' + method +
            '/?Name=' + encodeURIComponent($('#ViewName').val()) +
            '&Type=' + ConvertViewTypeModelToInt($('#ViewType').val()) +
            '&OwnerType=' + ConvertViewOnwerModelToInt($('#OwnerType').val()) +
            '&OwnerName=' + encodeURIComponent($('#ViewOwner').val()) +
            '&Group=' + encodeURIComponent($('#ViewGroup').val()) +
            '&Count=' + ClasterSize * 100;

        //custom fields
        for (key in fields) {
            url += `&${key}=${fields[key]}`;
        }

        return url;
    }

    function initDateTimepickers() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true,
            sideBySide: true
        };

        $('#datetimepickerFrom').datetimepicker(daytimeOpitions);
        $('#datetimepickerTo').datetimepicker(daytimeOpitions);

        $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date());
        $('#datetimepickerTo').data("DateTimePicker").setDate(new Date());
    }

    function Export(t) {

        if (requestForExport !== null) {
            console.log("Export in action, try later");
            return;
        }

        console.log("export to " + t);

        $('#exportingProgressError').hide();
        $('#exportingProgress').show();
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        requestForExport = $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/TariscopeViews/ExportData/?type=' + t +
                '&Name=' + encodeURIComponent($('#ViewName').val()) +
                '&ViewType=' + ConvertViewTypeModelToInt($('#ViewType').val()) +
                '&OwnerType=' + ConvertViewOnwerModelToInt($('#OwnerType').val()) +
                '&OwnerName=' + encodeURI($('#ViewOwner').val()) +
                '&Group=' + encodeURI($('#ViewGroup').val()),
            traditional: true,
            success: function (response) {
                $('#exportingProgress').hide();

                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/TariscopeViews/DownloadExportData/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                    $('#exportingProgressError').show();
                }

                requestForExport = null;
            },
            error: function (xhr, ajaxOptions, thrownError) {
                requestForExport = null;
                console.log(`${ajaxOptions} ${xhr.status} - ${thrownError}`);
                $('#exportingProgress').hide();
                $('#exportingProgressError').show();
            }
        });
    }

    function UpdateButtons() {
        if (SelectedField === null && SelectedValue === null && SelectedType === null && SelectedRows.length === 0) {
            $('button[data-selected="1"]').prop('disabled', true);
            $('button[data-selected="1"]').css('pointer-events', 'none');
            $('.menulist').find('a[data-menuhide="1"]').addClass('disDiv');
        }
        else {
            $('button[data-selected="1"]').prop('disabled', false);
            $('button[data-selected="1"]').css('pointer-events', 'auto');
            $('.menulist').find('a[data-menuhide="1"]').removeClass('disDiv');
        }


        if ($('#groupMark').length === 0) {//NOT GROUPED
            $('#btnDetailsAll').removeClass('disDiv');
            $('#btnFilterUnGroup').prop('disabled', true);
            $('#btnFilterUnGroup').css('pointer-events', 'none');

            $('#btnDetailsAllMenu').removeClass('disDiv');
            $('#btnDetailsAllBlankMenu').removeClass('disDiv');
            $('#btnFilterUnGroupMenu').addClass('disDiv');

            if (SelectedRows.length === 0) {
                $('#btnRecharge').prop('disabled', true);
                $('#btnRecharge').css('pointer-events', 'none');
                $('#btnDeleteSelected').prop('disabled', true);
                $('#btnDeleteSelected').css('pointer-events', 'none');
                $('#btnFilterRelated').prop('disabled', true);
                $('#btnFilterRelated').css('pointer-events', 'none');
                $('#btnDetailsSelected').addClass('disDiv');
                $('#btnDetailsSelectedBlank').addClass('disDiv');

                $('#btnRechargeMenu').addClass('disDiv');
                $('#btnDetailsSelectedMenu').addClass('disDiv');
                $('#btnDetailsSelectedBlankMenu').addClass('disDiv');
                $('#btnFilterRelatedMenu').addClass('disDiv');
                $('#btnDeleteSelectedMenu').addClass('disDiv');
            }
            else {
                $('#btnRecharge').prop('disabled', false);
                $('#btnRecharge').css('pointer-events', 'auto');
                $('#btnDeleteSelected').prop('disabled', false);
                $('#btnDeleteSelected').css('pointer-events', 'auto');
                $('#btnFilterRelated').prop('disabled', false);
                $('#btnFilterRelated').css('pointer-events', 'auto');
                $('#btnDetailsSelected').removeClass('disDiv');
                $('#btnDetailsSelectedBlank').removeClass('disDiv');

                $('#btnRechargeMenu').removeClass('disDiv');
                $('#btnDetailsSelectedMenu').removeClass('disDiv');
                $('#btnDetailsSelectedBlankMenu').removeClass('disDiv');
                $('#btnFilterRelatedMenu').removeClass('disDiv');
                $('#btnDeleteSelectedMenu').removeClass('disDiv');
            }

            if ($('#ViewType').val() !== "Calls") {
                $('#btnFilterRelated').prop('disabled', true);//related -> only calls
                $('#btnFilterRelated').css('pointer-events', 'none');
                $('#btnDeleteSelected').prop('disabled', true);//delete -> only calls
                $('#btnDeleteSelected').css('pointer-events', 'none');
                $('#btnRecharge').prop('disabled', true);//recharge -> only calls
                $('#btnRecharge').css('pointer-events', 'none');
                $('#btnDetailsSelected').addClass('disDiv');//details -> only calls
                $('#btnDetailsSelectedBlank').addClass('disDiv');//details -> only calls
                $('#btnDetailsAll').addClass('disDiv');//details -> only calls
                $('#btnRechargeTracing').prop('disabled', true);//recharge -> only calls
                $('#btnRechargeTracing').css('pointer-events', 'none');
                $('#btnDetailsAllBlank').addClass('disDiv');//details -> only calls
                $('#btnCategory').prop('disabled', true);//details -> only calls
                $('#btnCategory').css('pointer-events', 'none');

                $('#btnRechargeTracingMenu').addClass('disDiv');
                $('#btnRechargeMenu').addClass('disDiv');
                $('#btnDetailsSelectedMenu').addClass('disDiv');
                $('#btnDetailsSelectedBlankMenu').addClass('disDiv');
                $('#btnDetailsAllMenu').addClass('disDiv');
                $('#btnDetailsAllBlankMenu').addClass('disDiv');
                $('#btnFilterRelatedMenu').addClass('disDiv');
                $('#btnDeleteSelectedMenu').addClass('disDiv');
                $('#btnCategoryMenu').addClass('disDiv');
            }

            if ($('#ViewType').val() !== "Calls") {
                $('#btnRechargeAll').prop('disabled', true);//recharge -> only calls
                $('#btnRechargeAll').css('pointer-events', 'none');
                $('#btnRechargeAllMenu').addClass('disDiv');

                $('#btnCategoryAll').prop('disabled', true);
                $('#btnCategoryAll').css('pointer-events', 'none');
                $('#btnCategoryAllMenu').addClass('disDiv');                
            }
            else {
                $('#btnRechargeAll').prop('disabled', false);//recharge -> only calls
                $('#btnRechargeAll').css('pointer-events', 'auto');
                $('#btnRechargeAllMenu').removeClass('disDiv');

                $('#btnCategoryAll').prop('disabled', false);
                $('#btnCategoryAll').css('pointer-events', 'auto');
                $('#btnCategoryAllMenu').removeClass('disDiv');
            }


        }
        else {//GROUPED
            $('#btnFilterUnGroup').prop('disabled', false);
            $('#btnFilterUnGroup').css('pointer-events', 'auto');
            $('#btnFilterUnGroupMenu').removeClass('disDiv');

            $('#btnRecharge').prop('disabled', true);
            $('#btnRecharge').css('pointer-events', 'none');
            $('#btnDeleteSelected').prop('disabled', true);
            $('#btnDeleteSelected').css('pointer-events', 'none');
            $('#btnFilterRelated').prop('disabled', true);
            $('#btnFilterRelated').css('pointer-events', 'none');

            $('#btnRechargeAll').prop('disabled', true);
            $('#btnRechargeAll').css('pointer-events', 'none');
            $('#btnCategoryAll').prop('disabled', true);
            $('#btnCategoryAll').css('pointer-events', 'none');

            $('#btnDetailsSelected').addClass('disDiv');//details -> only calls
            $('#btnDetailsAll').addClass('disDiv');//details -> only calls

            $('#btnRechargeMenu').addClass('disDiv');
            $('#btnRechargeAllMenu').addClass('disDiv');
            $('#btnCategoryAllMenu').addClass('disDiv');
            $('#btnDetailsAllMenu').addClass('disDiv');
            $('#btnDetailsAllBlankMenu').addClass('disDiv');
            $('#btnDetailsSelectedMenu').addClass('disDiv');
            $('#btnDetailsSelected').addClass('disDiv');
            $('#btnDetailsSelectedBlankMenu').addClass('disDiv');
            $('#btnDetailsSelectedBlank').addClass('disDiv');
            $('#btnFilterRelatedMenu').addClass('disDiv');
            $('#btnDeleteSelectedMenu').addClass('disDiv');

        }

        if (SelectedRows.length === 0) {
            $('#btnFilterSort').prop('disabled', true);
            $('#btnFilterSort').css('pointer-events', 'none');
            $('#btnFilterUnSortSelected').prop('disabled', true);
            $('#btnFilterUnSortSelected').css('pointer-events', 'none');
            $('#btnFilterGroup').prop('disabled', true);
            $('#btnFilterGroup').css('pointer-events', 'none');

            $('#btnCopyCell').prop('disabled', true);
            $('#btnCopyCell').css('pointer-events', 'none');
            $('#btnCopyRow').prop('disabled', true);
            $('#btnCopyRow').css('pointer-events', 'none');

            $('#btnFilterSortMenu').addClass('disDiv');
            $('#btnFilterUnSortSelectedMenu').addClass('disDiv');
            $('#btnFilterGroupMenu').addClass('disDiv');
        }
        else {
            $('#btnFilterSort').prop('disabled', false);
            $('#btnFilterSort').css('pointer-events', 'auto');
            $('#btnFilterGroup').prop('disabled', false);
            $('#btnFilterGroup').css('pointer-events', 'auto');

            $('#btnCopyCell').prop('disabled', false);
            $('#btnCopyCell').css('pointer-events', 'auto');
            $('#btnCopyRow').prop('disabled', false);
            $('#btnCopyRow').css('pointer-events', 'auto');

            $('#btnFilterSortMenu').removeClass('disDiv');
            $('#btnFilterGroupMenu').removeClass('disDiv');

            if ($("i[data-sfield='" + SelectedField + "']").length === 0) {
                $('#btnFilterUnSortSelected').prop('disabled', true);
                $('#btnFilterUnSortSelected').css('pointer-events', 'none');
                $('#btnFilterUnSortSelectedMenu').addClass('disDiv');
            }
            else {
                $('#btnFilterUnSortSelected').prop('disabled', false);
                $('#btnFilterUnSortSelected').css('pointer-events', 'auto');
                $('#btnFilterUnSortSelectedMenu').removeClass('disDiv');
            }
        }

        if (SelectedRows.length > 1) {
            $('#btnFilterEq').prop('disabled', true);
            $('#btnFilterNotEq').prop('disabled', true);
            $('#btnFilterRelated').prop('disabled', true);
            $('#btnFilterSort').prop('disabled', true);
            $('#btnFilterUnSortSelected').prop('disabled', true);
            $('#btnFilterGroup').prop('disabled', true);

            $('#btnFilterEq').css('pointer-events', 'none');
            $('#btnFilterNotEq').css('pointer-events', 'none');
            $('#btnFilterRelated').css('pointer-events', 'none');
            $('#btnFilterSort').css('pointer-events', 'none');
            $('#btnFilterUnSortSelected').css('pointer-events', 'none');
            $('#btnFilterGroup').css('pointer-events', 'none');

            $('#btnCopyCell').prop('disabled', true);
            $('#btnCopyCell').css('pointer-events', 'none');
            $('#btnCopyRow').prop('disabled', true);
            $('#btnCopyRow').css('pointer-events', 'none');
            $('#btnCopyCellMenu').addClass('disDiv');
            $('#btnCopyRowMenu').addClass('disDiv');

            $('#btnFilterEqMenu').addClass('disDiv');
            $('#btnFilterNotEqMenu').addClass('disDiv');
            $('#btnFilterRelatedMenu').addClass('disDiv');
            $('#btnFilterSortMenu').addClass('disDiv');
            $('#btnFilterUnSortSelectedMenu').addClass('disDiv');
            $('#btnFilterGroupMenu').addClass('disDiv');
        }

        let current = $('#CurrentFilterIndex').val() * 1;
        let count = $('#CountFilters').val() * 1;

        if (current < 0) {
            $('#btnFilterPrev').prop('disabled', true);
            $('#btnFilterPrev').css('pointer-events', 'none');
            $('#btnFilterPrevMenu').addClass('disDiv');
        }
        else {
            $('#btnFilterPrev').prop('disabled', false);
            $('#btnFilterPrev').css('pointer-events', 'auto');
            $('#btnFilterPrevMenu').removeClass('disDiv');
        }

        if (current === (count - 1)) {
            $('#btnFilterNext').prop('disabled', true);
            $('#btnFilterNext').css('pointer-events', 'none');
            $('#btnFilterNextMenu').addClass('disDiv');
        }
        else {
            $('#btnFilterNext').prop('disabled', false);
            $('#btnFilterNext').css('pointer-events', 'auto');
            $('#btnFilterNextMenu').removeClass('disDiv');
        }

        if (count === 0) {
            $('#btnFilterClear').prop('disabled', true);
            $('#btnFilterClear').css('pointer-events', 'none');
            $('#btnFilterClearMenu').addClass('disDiv');
        }
        else {
            $('#btnFilterClear').prop('disabled', false);
            $('#btnFilterClear').css('pointer-events', 'auto');
            $('#btnFilterClearMenu').removeClass('disDiv');
        }

        if ($('#sortMark').length === 0) {
            $('#btnFilterUnSort').prop('disabled', true);
            $('#btnFilterUnSort').css('pointer-events', 'none');
            $('#btnFilterUnSortMenu').addClass('disDiv');
        }
        else {
            $('#btnFilterUnSort').prop('disabled', false);
            $('#btnFilterUnSort').css('pointer-events', 'auto');
            $('#btnFilterUnSortMenu').removeClass('disDiv');
        }

        if ($('#OwnerType').val() !== 'Your') {
            $('#btnSaveChanges').prop('disabled', true);
            $('#btnSaveChanges').css('pointer-events', 'none');
            $('#btnRename').prop('disabled', true);
            $('#btnRename').css('pointer-events', 'none');

            $('#btnSaveChangesMenu').addClass('disDiv');
            $('#btnRenameMenu').addClass('disDiv');
        }
        else {
            $('#btnSaveChanges').prop('disabled', false);
            $('#btnSaveChanges').css('pointer-events', 'auto');
            $('#btnRename').prop('disabled', false);
            $('#btnRename').css('pointer-events', 'auto');

            $('#btnSaveChangesMenu').removeClass('disDiv');
            $('#btnRenameMenu').removeClass('disDiv');
        }
    }

    function RemoveFromArray(array, element) {
        //remove element form array
        const index = array.indexOf(element);

        if (index !== -1) {
            array.splice(index, 1);
        }
    }

    function UpdateCount(rowlimited = false, loaded = false) {
        //update informaiton about rows count
        LoadedRows = clusterize.getRowsAmount();
        $('#totalLines').text(LoadedRows);

        $('#ForLoadMore').hide();

        if (loaded === true) {
            $('#loadedLabel').show();

            if (rowlimited === true) {
                $('#ForLoadMore').show();
            }
        }
        else {
            $('#loadedLabel').hide();

            if (rowlimited === true) {
                $('#ForLoadMore').hide();
            }
        }

        SetHeight();
    }

    function AttachEventsToTable() {

        clusterize = new Clusterize({
            scrollId: 'scrollArea',
            contentId: 'contentArea',
            rows_in_block: ClasterSize
        });

        //click to row or cell
        $('#contentArea').on('click', 'td', function (e) {
            if (e.shiftKey) {//select via shift
                var newIndex = $('tr[data-id="' + $(this).data('id') + '"]').index();

                var table = $('#tariscope-view');

                //init first row
                if (rowIndex === null)
                    rowIndex = $('tr[data-id="' + $(this).data('id') + '"]').index();

                tempIndex = rowIndex;

                //clear prev selected
                SelectedRows = [];
                SelectedField = null;
                SelectedValue = null;
                SelectedType = null;
                SelectedRelated = null;

                $('#tariscope-view tr.selected').removeClass('selected');
                $('#tariscope-view td.selected').removeClass('selected');

                var direction = newIndex >= rowIndex;

                if (direction) {//select down
                    while (tempIndex <= newIndex) {
                        tempIndex += 1;

                        var tr = $('tr:eq(' + tempIndex + ')', table);

                        if (tr.css('display') !== 'none') {
                            tr.addClass('selected');
                            RemoveFromArray(SelectedRows, tr.find('td[data-name="ID"]').text());
                            SelectedRows.push(tr.find('td[data-name="ID"]').text());
                        }
                    }
                }
                else {//select up
                    while (tempIndex > (newIndex - 1)) {
                        var tr2 = $('tr:eq(' + (tempIndex + 1) + ')', table);

                        if (tr2.css('display') !== 'none') {
                            tr2.addClass('selected');
                            RemoveFromArray(SelectedRows, tr2.find('td[data-name="ID"]').text());
                            SelectedRows.push(tr2.find('td[data-name="ID"]').text());
                        }

                        tempIndex -= 1;
                    }
                }

                if (SelectedRows.length >= 100) {
                    $('#toMuchSelecteModal').modal('show');
                }

            }
            else {//single select
                rowIndex = $('tr[data-id="' + $(this).data('id') + '"]').index();

                SelectedRows = [];
                SelectedField = null;
                SelectedValue = null;
                SelectedType = null;
                SelectedRelated = null;

                if ($(this).hasClass('selected')) {
                    $('#tariscope-view tr.selected').removeClass('selected');
                    $('#tariscope-view td.selected').removeClass('selected');
                }
                else {
                    $('#tariscope-view tr.selected').removeClass('selected');
                    $('#tariscope-view td.selected').removeClass('selected');

                    SelectedRows.push($(this).data('id'));

                    if ($(this).data('selector') === false) {
                        SelectedField = $(this).data('name');
                        SelectedValue = $(this).data('value');
                        SelectedType = $(this).data('type');
                        SelectedRelated = $(this).data('related-id');
                        $(this).addClass('selected');
                    }
                    else {
                        $('tr[data-id="' + $(this).data('id') + '"]').addClass('selected');
                    }
                }
            }

            UpdateButtons();
        });

        SetHeight();
        ShowSpinner(false);

        if (IsRecharge) {
            IsRecharge = false;
            $('#rechargeHasEndmodal').modal('show');
        }

        SelectedRows = [];
        SelectedField = null;
        SelectedValue = null;
        SelectedType = null;
        SelectedRelated = null;

        UpdateButtons();
        UpdateCount();
        LoadPartialCalls();
    }

    function LoadCalls() {
        $('#viewsRowsTable').load(BuildUrl('Read'), AttachEventsToTable);
    }

    function LoadPartialCalls() {
        request = $.ajax({
            type: "POST",
            async: true,
            url: BuildUrl('ReadPartial', {Start: LoadedRows}),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    clusterize.append(response.rows);
                    UpdateCount(response.showLimit, response.loaded);

                    if (response.loaded === false) {
                        LoadPartialCalls();
                    }
                }
            }
        });
    }

    function SetHeight() {
        windowHeight = window.innerHeight -
            $('.main-header').outerHeight() -
            $('.content-header').outerHeight() -
            $('.box-header').outerHeight() -
            $('#totalData').outerHeight() -
            $('.main-footer').outerHeight();

        if (windowHeight < 400)
            windowHeight = 400;

        $('.clusterize-scroll').css('max-height', windowHeight + 'px');
    }

    function GetRefreshInterval() {
        let interval = new URL(window.location.href).searchParams.get("RefreshInterval");
        return interval;
    }

    function SetRefreshInterval(value) {
        var url = new URL(window.location.href);
        url.searchParams.set("RefreshInterval", value);
        return url;
    }

    function LookToReload() {
        let interval = GetRefreshInterval();
        if (interval && interval * 1 > 0)
            setTimeout(() => {
                location.reload();
            }, interval);
    }

    function ShowCopiedMessage() {
        $('.copied-message').fadeIn('fast');

        setTimeout(() => {
            $('.copied-message').fadeOut('fast');
        }, 1000);
    }

    function CopyCell() {
        let value = $('.selected').text();

        const el = document.createElement('textarea');
        el.value = value ? value : " ";
        el.setAttribute('readonly', '');
        el.style.position = 'absolute';
        el.style.left = '-9999px';
        document.body.appendChild(el);
        el.select();
        document.execCommand('copy');
        document.body.removeChild(el);
    }

    function CopyRow() {
        let row = $('.selected').closest('tr');
        let value = "";
        $(row).find('td').each(function () {
            value += `${$(this).text()} `;
        });

        const el = document.createElement('textarea');
        el.value = value ? value : " ";
        el.setAttribute('readonly', '');
        el.style.position = 'absolute';
        el.style.left = '-9999px';
        document.body.appendChild(el);
        el.select();
        document.execCommand('copy');
        document.body.removeChild(el);
    }

    //resize window
    $(window).resize(() => {
        SetHeight();
        clusterize.refresh();
    });

    //filter by selection
    $('#btnFilterEq, #btnFilterEqMenu').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_FQ', {
            FieldName: encodeURIComponent(SelectedField),
            FieldValue: encodeURIComponent(SelectedValue),
            FieldType: encodeURIComponent(SelectedType)
        }), AttachEventsToTable);
    });

    //exclude filter by selection
    $('#btnFilterNotEq, #btnFilterNotEqMenu').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_NFQ', {
            FieldName: encodeURIComponent(SelectedField),
            FieldValue: encodeURIComponent(SelectedValue),
            FieldType: encodeURIComponent(SelectedType)
        }), AttachEventsToTable);
    });

    //go to prev filter
    $('#btnFilterPrev, #btnFilterPrevMenu').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_Prev'), AttachEventsToTable);
    });

    //go to next filter
    $('#btnFilterNext, #btnFilterNextMenu').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_Next'), AttachEventsToTable);
    });

    //clear filter
    $('#btnFilterClear, #btnFilterClearMenu').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_Clear'), () => {
            AttachEventsToTable();
        });
    });

    //show releated
    $('#btnFilterRelated, #btnFilterRelatedMenu').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_Related', {
            ID: encodeURIComponent(SelectedRows[0])
        }), AttachEventsToTable);
    });

    //recharge selected
    $('#btnRecharge, #btnRechargeMenu').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        IsRecharge = true;
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/CommunicationNodes/ClearCache/3',
            traditional: true,
            success: function (response) {
                $('#viewsRowsTable').load(BuildUrl('Recharge', {
                    IDs: encodeURIComponent(SelectedRows.join(","))
                }), AttachEventsToTable);
                ShowSpinner(false);
            }
        });
    });

    //show dialog for delete selected records
    $('#btnDeleteSelected, #btnDeleteSelectedMenu').on('click', () => { $('#confirmDelete').modal('show'); });

    //confirm deleting selected rows
    $('#DeleteConfirm').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        $('#confirmDelete').modal('hide');
        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Delete', {
            IDs: encodeURIComponent(SelectedRows.join(","))
        }), AttachEventsToTable);
    });

    //show modal for sabe filter
    $('#btnFilterSave, #btnFilterSaveMenu').on('click', () => {
        $('#emptyName').hide();
        $('#SaveFilterConfirm').prop('disabled', true);
        $('#filterName').val('');
        $('#saveFiltermodal').modal('show');
    });

    //show error when filter name is empty
    $('#filterName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyName').slideDown('fast');
            $('#SaveFilterConfirm').attr('disabled', true);
        }
        else {
            $('#emptyName').slideUp('fast');
            $('#SaveFilterConfirm').attr('disabled', false);
        }
    });

    //confrim saving new filter
    $('#SaveFilterConfirm').on('click', () => {
        $('#saveFiltermodal').modal('hide');
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/SaveFilter/?Name=' + encodeURIComponent($('#ViewName').val()) +
                '&Type=' + ConvertViewTypeModelToInt($('#ViewType').val()) +
                '&OwnerType=' + ConvertViewOnwerModelToInt($('#OwnerType').val()) +
                '&OwnerName=' + encodeURIComponent($('#ViewOwner').val()) +
                '&FilterName=' + encodeURIComponent($('#filterName').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                }
            }
        });
    });

    //show modal for confirm save new filter
    $('#btnFilterAsBase, #btnFilterAsBaseMenu').on('click', () => {
        $('#emptyViewName').hide();
        $('#SaveFViewConfirm').prop('disabled', true);
        $('#newViewName').val('');
        $('#saveViewmodal').modal('show');
    });

    //show error when empty view name
    $('#newViewName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyViewName').slideDown('fast');
            $('#SaveFViewConfirm').attr('disabled', true);
        }
        else {
            $('#emptyViewName').slideUp('fast');
            $('#SaveFViewConfirm').attr('disabled', false);
        }
    });

    //confirm created new based view
    $('#SaveFViewConfirm').on('click', () => {
        $('#saveViewmodal').modal('hide');
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/SaveView/?Name=' + encodeURIComponent($('#ViewName').val()) +
                '&Type=' + ConvertViewTypeModelToInt($('#ViewType').val()) +
                '&OwnerType=' + ConvertViewOnwerModelToInt($('#OwnerType').val()) +
                '&OwnerName=' + encodeURIComponent($('#ViewOwner').val()) +
                '&ViewName=' + encodeURIComponent($('#newViewName').val()) +
                '&Group=' + encodeURI($('#ViewGroup').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    window.open('/TariscopeViews/Open/?Name=' + encodeURIComponent(response.name) +
                        '&Type=' + ConvertViewTypeModelToInt($('#ViewType').val()) +
                        '&OwnerType=1&OwnerName=&Group=' + encodeURI($('#ViewGroup').val()), '_parent');
                }
            }
        });
    });

    //load other calls
    $('#disableRowLimit').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/DisableRowLimit',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#ForLoadMore').hide();
                    $('#loadedLabel').hide();
                    LoadPartialCalls();
                }
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL, #ExportEXCELMenu').on('click', function () { Export("xlsx"); });
    $('#ExportHTML, #ExportHTMLMenu').on('click', function () { Export("html"); });
    $('#ExportCSV, #ExportCSVMenu').on('click', function () { Export("csv"); });
    $('#ExportPDF, #ExportPDFMenu').on('click', function () { Export("pdf"); });

    //open modal for select fields
    $('#btnFilterSelectColls, #btnFilterSelectCollsMenu').on('click', () => {
        $('#FieldsContainer').load('/TariscopeViews/GetFields?Name=' + encodeURIComponent($('#ViewName').val()) +
            '&Type=' + ConvertViewTypeModelToInt($('#ViewType').val()) +
            '&OwnerType=' + ConvertViewOnwerModelToInt($('#OwnerType').val()) +
            '&OwnerName=' + encodeURI($('#ViewOwner').val()) +
            '&Group=' + encodeURI($('#ViewGroup').val()) +
            '&FieldName=' + encodeURIComponent(SelectedField), () => {
                //move buttons (top down)
                $('.tcxField').mouseover(function () {
                    $(this).append($('#btnsTopDown'));
                });

                //mode top
                $('#btnMoveTcxFieldTop').on('click', function () {
                    let CurrentNumber = $(this).parent().parent().find('input').attr('enumnumber') * 1;
                    let CurrentElement = $(this).parent().parent();
                    let PrevElement = $(this).parent().parent().prev();

                    if (PrevElement.length > 0) {
                        let ExpectPrevNumber = $(PrevElement).find('input').attr('enumnumber') * 1;
                        let InputToMove = $('input[name="Fields[' + CurrentNumber + ']"]');
                        let PrevInput = $(InputToMove).prev();
                        let RealPrevNumber = (PrevInput.length > 0 ? ($(PrevInput).val() * 1) : -1);

                        $(CurrentElement).insertBefore($(PrevElement));

                        if (ExpectPrevNumber === RealPrevNumber)
                            $(InputToMove).insertBefore(PrevInput);
                    }
                });

                //mode down
                $('#btnMoveTcxFieldDown').on('click', function () {
                    let CurrentNumber = $(this).parent().parent().find('input').attr('enumnumber') * 1;
                    let CurrentElement = $(this).parent().parent();
                    let NextElement = $(this).parent().parent().next();

                    if (NextElement.length > 0) {
                        let ExpectNextNumber = $(NextElement).find('input').attr('enumnumber') * 1;
                        let InputToMove = $('input[name="Fields[' + CurrentNumber + ']"]');
                        let NextInput = $(InputToMove).next();
                        let RealNextNumber = (NextInput.length > 0 ? ($(NextInput).val() * 1) : -1);

                        $(CurrentElement).insertAfter($(NextElement));

                        if (ExpectNextNumber === RealNextNumber)
                            $(InputToMove).insertAfter(NextInput);
                    }
                });

                $('#FieldsEditor').modal('show');
            });
    });

    //open view with new fields
    $('#btnSaveFields').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        $('#FieldsEditor').modal('hide');
        ShowSpinner(true);

        var f = $("[id^='field_']");
        var v = [];

        f.map(function (e) {
            if ($(f[e]).prop('checked'))
                v.push($(f[e]).data('field'));
        });

        $('#viewsRowsTable').load(BuildUrl('SetFields', {
            Fields: v.join(',')
        }), AttachEventsToTable);
    });

    //show sql filter for view
    $('#btnFilterShowCurrent, #btnFilterShowCurrentMenu').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Read_SQL/?Name=' + encodeURIComponent($('#ViewName').val()) +
                '&Type=' + ConvertViewTypeModelToInt($('#ViewType').val()) +
                '&OwnerType=' + ConvertViewOnwerModelToInt($('#OwnerType').val()) +
                '&OwnerName=' + encodeURI($('#ViewOwner').val()) +
                '&Group=' + encodeURI($('#ViewGroup').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#sqlContainer').load("/TariscopeViews/GetSQLEditor/?sql=" + encodeURIComponent(response.sql), () => { $('#SQLEditor').modal('show'); });
                }
            }
        });
    });

    $('#btnChangeViewSql').on('click', () => {

        let Filter = $('#sqlContainer .CodeMirror-code span[role="presentation"]').text();
        ShowSpinner(true);
        
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Write_SQL/?Name=' + encodeURIComponent($('#ViewName').val()) +
                '&Type=' + ConvertViewTypeModelToInt($('#ViewType').val()) +
                '&OwnerType=' + ConvertViewOnwerModelToInt($('#OwnerType').val()) +
                '&OwnerName=' + encodeURI($('#ViewOwner').val()) +
                '&Group=' + encodeURI($('#ViewGroup').val()),
            data: JSON.stringify(Filter),
            contentType: 'application/json',
            traditional: true,
            success: function (response) {
                if (response.success === true) {
                    LoadCalls();
                }
                else {
                    ShowSpinner(false);
                    $('#ErrorDialog').modal('show');
                    $('#ErrorDialogMessage').text(response.message);
                }
            }
        });
    })

    //recharge all rows in opened view
    //recharge all rows in opened view
    $('#btnRechargeAll, btnRechargeAllMenu').on('click', () => { $('#rechargeAllModal').modal('show'); });
    $('#goReachargeAll').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        IsRecharge = true;
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/CommunicationNodes/ClearCache/3',
            traditional: true,
            success: function (response) {
                $('#viewsRowsTable').load(BuildUrl('RechargeAll'), AttachEventsToTable);
                ShowSpinner(false);
            }
        });
    });

    //show modal for select sort direction
    $('#btnFilterSort, #btnFilterSortMenu').on('click', () => { $('#sortViewmodal').modal('show'); });

    //confirm sorting
    $('#SortViewConfirm').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        $('#sortViewmodal').modal('hide');
        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_Sort', {
            FieldName: encodeURIComponent(SelectedField),
            IsAsc: encodeURIComponent($('#selectSortDirection').val())
        }), AttachEventsToTable);
    });

    //unsort selected
    $('#btnFilterUnSortSelected, #btnFilterUnSortSelectedMenu').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        $('#sortViewmodal').modal('hide');
        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_UnsortSelected', {
            FieldName: encodeURIComponent(SelectedField),
        }), AttachEventsToTable);
    });

    //unsort all
    $('#btnFilterUnSort, #btnFilterUnSortMenu').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        $('#sortViewmodal').modal('hide');
        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_Unsort'), AttachEventsToTable);
    });

    //show modal for select grouping
    $('#btnFilterGroup, #btnFilterGroupMenu').on('click', () => { $('#groupViewmodal').modal('show'); });

    //confirm grouping
    $('#GroupViewConfirm').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        $('#groupViewmodal').modal('hide');
        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_Group', {
            FieldName: encodeURIComponent(SelectedField),
            GroupType: encodeURIComponent($('#selectGrouping').val())
        }), AttachEventsToTable);
    });

    //reset grouping
    $('#btnFilterUnGroup, #btnFilterUnGroupMenu').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        ShowSpinner(true);
        $('#viewsRowsTable').load(BuildUrl('Read_UnGroup'), AttachEventsToTable);
    });

    //show modal for rename
    $('#btnRename, #btnRenameMenu').on('click', () => {
        $('#renameName').val($('#ViewName').val());
        $('#modalButtonRename').prop('disabled', false);
        $('#renameViewmodal').modal('show');
    });

    //show error when empty name
    $('#renameName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyRename').slideDown('fast');
            $('#modalButtonRename').attr('disabled', true);
        }
        else {
            $('#emptyRename').slideUp('fast');
            $('#modalButtonRename').attr('disabled', false);
        }
    });

    //rename view
    $('#modalButtonRename').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/Rename/?Name=' + encodeURIComponent($('#ViewName').val()) +
                '&NewName=' + encodeURIComponent($('#renameName').val()) +
                '&Type=' + ConvertViewTypeModelToInt($('#ViewType').val()) +
                '&OwnerType=' + ConvertViewOnwerModelToInt($('#OwnerType').val()) +
                '&OwnerName=' + encodeURI($('#ViewOwner').val()) +
                '&Group=' + encodeURI($('#ViewGroup').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    window.open('/TariscopeViews/Open/?Name=' + response.Name + '&Type=' + response.Type + '&OwnerType=1&OwnerName=&Group=' + response.Group, '_parent');
                }
                else {
                    $('#renameViewmodal').modal('hide');
                }
            }
        });
    });

    //save changes
    $('#btnSaveChanges, #btnSaveChangesMenu').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/TariscopeViews/SaveChanges/?Name=' + encodeURIComponent($('#ViewName').val()) +
                '&Type=' + ConvertViewTypeModelToInt($('#ViewType').val()) +
                '&OwnerType=' + ConvertViewOnwerModelToInt($('#OwnerType').val()) +
                '&OwnerName=' + encodeURIComponent($('#ViewOwner').val()) +
                '&Group=' + encodeURI($('#ViewGroup').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                }
            }
        });
    });

    //open details for selected calls
    $('#btnDetailsSelected, #btnDetailsSelectedMenu, #btnDetailsSelectedBlank, #btnDetailsSelectedBlankMenu').on('click', function () {
        let datad = $(this).prop('id') == 'btnDetailsSelectedBlank' || $(this).prop('id') == 'btnDetailsSelectedBlankMenu';

        $.ajax({
            type: "POST",
            url: '/TariscopeViews/SupportDetails/' + SelectedRows[0],
            traditional: true,
            success: function (response) {
                if (response !== null) {
                    if (response.success === true) {
                        let ids = '';
                        SelectedRows.forEach(x => { ids += 'ids=' + x + '&'; });
                        window.open('/TariscopeViews/Details/?' + ids, datad ? "_blank" : "_parent");
                    }
                    else {
                        $('#notSupportDetailsmodal').modal('show');
                    }

                }
            }
        });
    });

    //open details for all calls in view
    $('#btnDetailsAll, #btnDetailsAllMenu, #btnDetailsAllBlank, #btnDetailsAllBlankMenu').on('click', function () {
        let datad = $(this).prop('id') == 'btnDetailsAllBlank' || $(this).prop('id') == 'btnDetailsAllBlankMenu';

        $.ajax({
            type: "POST",
            url: '/TariscopeViews/SupportDetails/' + $($(clusterize.content_elem).find('tr')[0]).data('id'),
            traditional: true,
            success: function (response) {
                if (response !== null) {
                    if (response.success === true) {
                        window.open(BuildUrl('DetailsAll'), datad ? "_blank" : "_parent");
                    }
                    else {
                        $('#notSupportDetailsmodal').modal('show');
                    }

                }
            }
        });
    });

    //show modal to start/stop refresh
    $('#btnStartAutoRefresh, #btnStartAutoRefreshMenu').on('click', () => {
        let interval = GetRefreshInterval();
        if (interval && interval * 1 > 0) {
            $('#refreshInterval').val(interval / 1000);
        }
        else {
            $('#refreshInterval').val(0);
        }

        $('#refreshWindowModal').modal('show');
    });

    //set refresh interval
    $('#saveRefreshInterval').on('click', () => {
        $('#refreshWindowModal').modal('hide');
        let interval = $('#refreshInterval').val() * 1000;
        setTimeout(() => {
            window.location = SetRefreshInterval(interval);
        }, interval);
    });

    //copy cell
    $('#btnCopyCell, #btnCopyCellMenu').on('click', () => {
        CopyCell();
    });

    //copy row
    $('#btnCopyRow, #btnCopyRowMenu').on('click', () => {
        CopyRow();
    });

    //handle ctrl pressed
    $(document).keydown(function (e) {
        if (e.keyCode == ctrlKey || e.keyCode == cmdKey) ctrlDown = true;
    }).keyup(function (e) {
        if (e.keyCode == ctrlKey || e.keyCode == cmdKey) ctrlDown = false;
    });

    //handle x and c pressed
    $(document).keydown(function (e) {
        //copy cell
        if (ctrlDown && (e.keyCode == cKey)) {
            CopyCell();
            ShowCopiedMessage();
        }

        //copy row
        if (ctrlDown && (e.keyCode == xKey)) {
            CopyRow();
            ShowCopiedMessage();
        }
    });

    //show modal to change category for selected
    $('#btnCategory, #btnCategoryMenu').on('click', () => {
        SelectedOnly = true;
        $('#SetupCallCategoryModal').modal('show');
    });

    //show modal to change category all in view
    $('#btnCategoryAll, #btnCategoryAllMenu').on('click', () => {
        SelectedOnly = false;
        $('#SetupCallCategoryModal').modal('show');
    });

    //chnage categories
    $('#btnApplyCategory').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        ShowSpinner(true);

        if (SelectedOnly) {
            $('#viewsRowsTable').load(BuildUrl('UpdateCategory', {
                IDs: encodeURIComponent(SelectedRows.join(",")),
                CategoryID: $('#CallNewCategory').val()
            }), AttachEventsToTable);

            BuildUrl('UpdateCategory', {
                CategoryID: $('#CallNewCategory').val()
            })
        }
        else {
            $('#viewsRowsTable').load(BuildUrl('UpdateCategoryAll', {
                CategoryID: $('#CallNewCategory').val()
            }), AttachEventsToTable);
        }
    });

    //recharge with tracing
    $('#btnRechargeTracing, #btnRechargeTracingMenu').on('click', () => {
        window.open(`/Tracing/${SelectedRows[0]}`, '_blank');
    });

    $('#btnFilterByNumbers, #btnFilterByNumbersMenu').on('click', () => {
        ShowSpinner(true);
        $('#numbersContainer').load(
            '/TariscopeViews/GetNumbers/?Name=' + encodeURIComponent($('#ViewName').val()) +
            '&Type=' + ConvertViewTypeModelToInt($('#ViewType').val()) +
            '&OwnerType=' + ConvertViewOnwerModelToInt($('#OwnerType').val()) +
            '&OwnerName=' + encodeURIComponent($('#ViewOwner').val()) +
            '&Group=' + encodeURI($('#ViewGroup').val()),
            () => {
                ShowSpinner(false);
                $('#ChooseNumbersDialog').modal('show');
                AttachEventsForSDTables();
            }
        )
    })

    $('#btnChooseNumbers').on('click', () => {
        ShowSpinner(true);

        $('#viewsRowsTable').load(
            BuildUrl('Read_Numbers', {
                NumbersStr: encodeURIComponent(selectedNumbers)
            }),
            () => {
                LoadedRows = 0;
                if (request !== null) {
                    request.abort();
                }
                AttachEventsToTable();
                ShowSpinner(false);
            }
        )
    })

    $('#btnResetNumbersSelection').on('click', () => {
        $('#tariscope-SDD tbody tr.selected').removeClass('selected');
        $('#btnResetNumbersSelection').prop('disabled', true);
        selectedNumbers = [];
    })

    function AttachEventsForSDTables() {

        selectedNumbers = [];

        if (selectedNumbers.length === 0) {
            $('#btnResetNumbersSelection').prop('disabled', true)
        }
        else {
            $('#btnResetNumbersSelection').prop('disabled', false)
        }
        //attach events to table with destination and source
        $('#tariscope-SDD tbody').on('click', 'tr', function () {
            let hidden = $(this).find('td[data-name="SDDataHidden"]').text();

            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                RemoveFromArray(selectedNumbers, hidden);
            }
            else {
                if ($(this).data('name') !== 'SDDataNonSelect') {
                    selectedNumbers.push(hidden);
                    $(this).addClass('selected');
                }
            }

            if (selectedNumbers.length === 0) {
                $('#btnResetNumbersSelection').prop('disabled', true)
            }
            else {
                $('#btnResetNumbersSelection').prop('disabled', false)
            }
        });

        $('#tariscope-SDD tbody tr').each((index, element) => {
            let hidden = $(element).find('td[data-name="SDDataHidden"]').text();

            if (selectedNumbers.includes(hidden)) {
                $(element).addClass('selected');
            }
        });

        let inputs = $('#tariscope-SDD').find('input');

        if (inputs.length) {
            let search = $(inputs[0]);
            search.val('');
            search.unbind();
            search.on('input', () => {
                let str = search.val();

                if (!str || !str.trim()) {
                    $('#tariscope-SDD').find('tbody').find('tr').each(function () {
                        $(this).show();
                    });
                }
                else {
                    $('#tariscope-SDD').find('tbody').find('tr').each(function () {
                        if ($(this).find('td[data-name="SDDataDisplay"]').text().toLowerCase().includes(str.toLowerCase())) {
                            $(this).show();
                        }
                        else {
                            $(this).hide();
                        }
                    });
                }
            });
        }
    }

    //show global filter modal
    $('#btnGlobalFilter, #btnGlobalFilterMenu').on('click', () => { $('#GlobalFolterModal').modal('show'); });

    //apply global filter
    $('#ApplyGlobalFolterBtn').on('click', () => {
        GlobalFilter.period = $('#PeriodType').val();
        GlobalFilter.year = $('#SelectedYearValue').val();
        GlobalFilter.month = $('#SelectedMonthValue').val();
        GlobalFilter.from = GetDate('datetimepickerFrom');
        GlobalFilter.to = GetDate('datetimepickerTo');
        GlobalFilter.department = $('#SourceDepartment').length > 0 ? $('#SourceDepartment').val() : '-2';
        GlobalFilter.fromEnabled = $('#PeriodFromEnable').prop('checked');
        GlobalFilter.toEnabled = $('#PeriodToEnable').prop('checked');

        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }
        ShowSpinner(true);

        let url = BuildUrl('Read_Date');

        for (key in GlobalFilter) {
            url += `&gf.${key}=${GlobalFilter[key]}`;
        }

        $('#viewsRowsTable').load(
            url,
            () => {
                AttachEventsToTable();
                ShowSpinner(false);
            }
        )
    });

    //show section for enter custom view period
    $('#PeriodType').change(function () {
        switch ($(this).val() * 1) {
            case 9:
                $('#CustomPeriodSection').slideUp('fast');
                $('#SelectedMonth').show();
                $('#SelectedYearMonthSection').slideDown('fast');
                break;
            case 10:
                $('#CustomPeriodSection').slideUp('fast');
                $('#SelectedMonth').hide();
                $('#SelectedYearMonthSection').slideDown('fast');
                break;
            case 11:
                $('#SelectedYearMonthSection').slideUp('fast');
                $('#CustomPeriodSection').slideDown('fast');

                try {
                    $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date());
                    $('#datetimepickerTo').data("DateTimePicker").setDate(new Date());
                } catch (e) { }
                break;
            default:
                $('#SelectedYearMonthSection').slideUp('fast');
                $('#CustomPeriodSection').slideUp('fast');
                break;
        }

    });

    ShowSpinner(true);
    initDateTimepickers();
    setTimeout(() => {
        if (window.innerWidth > 767)
            $('#MenuHamburger').click();
    }, 500);
    LoadCalls();
    LookToReload();
});
