﻿$(document).ready(function () {
    var isAdd = !$('#modelID').val() || !$('#modelID').val().trim();
    var devsLoaded = false;
    var depsLoaded = false;
    var nodsLoaded = false;

    function ValidateDevices() {
        var nodes = $("[id^='AllowNode_']");

        nodes.map(function (e) {
            if ($(nodes[e]).prop('checked') == false) {
                $('#AllovedAllDevc').prop('checked', false);

                $("[data-v-node-id='" + $(nodes[e]).data('node-id') + "']").prop('checked', false);
                $("[data-v-node-id='" + $(nodes[e]).data('node-id') + "']").prop('disabled', true);
                $("[data-sv-node-id='" + $(nodes[e]).data('node-id') + "']").addClass('disDiv');
            }
            else {
                $("[data-v-node-id='" + $(nodes[e]).data('node-id') + "']").prop('disabled', false);
                $("[data-sv-node-id='" + $(nodes[e]).data('node-id') + "']").removeClass('disDiv');
            }
        });
    }

    function ValidateDepartments() {
        var nodes = $("[id^='AllowNode_']");

        nodes.map(function (e) {
            if ($(nodes[e]).prop('checked') == false) {
                $('#AllovedAllDept').prop('checked', false);

                $("[data-d-node-id='" + $(nodes[e]).data('node-id') + "']").prop('checked', false);
                $("[data-d-node-id='" + $(nodes[e]).data('node-id') + "']").prop('disabled', true);
                $("[data-sd-node-id='" + $(nodes[e]).data('node-id') + "']").addClass('disDiv');
            }
            else {
                $("[data-d-node-id='" + $(nodes[e]).data('node-id') + "']").prop('disabled', false);
                $("[data-sd-node-id='" + $(nodes[e]).data('node-id') + "']").removeClass('disDiv');
            }
        });
    }

    function ShowTitle() {

        //show right title
        $('#add').prop('hidden', !isAdd);
        $('#edit').prop('hidden', isAdd);
    }

    function SetPasswordsFields() {
        $('#UserPassword').prop('readonly', !isAdd);
        $('#comparePasswordDiv').prop('hidden', !isAdd);

        if (isAdd)
            $('#btnEditOldPassword').hide();
        else
            $('#btnEditOldPassword').show();
    }

    function EnableSubmit() {
        //enable submit only if loaded departments and devices
        $('#submitBtn').prop('disabled', !(devsLoaded && depsLoaded && nodsLoaded));

        if (devsLoaded && depsLoaded && nodsLoaded) {
            ValidateDevices();
            ValidateDepartments();
        }
    }

    function LoadRights() {
        $('#DeviceConcentrator').load('/Users/Devices/?user_id=' + encodeURIComponent($('#modelID').val()), function () {
            devsLoaded = true;
            EnableSubmit();

            //of allowed all devices switch
            $("[id^='AllowDevice']").change('click', function () {
                if ($(this).prop('checked') == false) {
                    $('#AllovedAllDevc').prop('checked', false);
                }
            });
        });
        $('#DepartmentConcentrator').load('/Users/Departments/?user_id=' + encodeURIComponent($('#modelID').val()), function () {
            depsLoaded = true;
            EnableSubmit();

            //of allowed all departments switch
            $("[id^='AllowDepartment']").change('click', function () {
                if ($(this).prop('checked') == false) {
                    $('#AllovedAllDept').prop('checked', false);
                }
            });
        });
        $('#NodesConcentrator').load('/Users/Nodes/?user_id=' + encodeURIComponent($('#modelID').val()), function () {
            nodsLoaded = true;
            EnableSubmit();

            //of allowed all departments switch
            $("[id^='AllowNode']").change('click', function () {
                if ($(this).prop('checked') == false) {
                    $('#AllowAllNodes').prop('checked', false);

                    //devices
                    $("[data-v-node-id='" + $(this).data('node-id') + "']").prop('checked', false);
                    $("[data-v-node-id='" + $(this).data('node-id') + "']").prop('disabled', true);
                    $("[data-sv-node-id='" + $(this).data('node-id') + "']").addClass('disDiv');

                    //departments
                    $("[data-d-node-id='" + $(this).data('node-id') + "']").prop('checked', false);
                    $("[data-d-node-id='" + $(this).data('node-id') + "']").prop('disabled', true);
                    $("[data-sd-node-id='" + $(this).data('node-id') + "']").addClass('disDiv');
                }
                else {
                    //devices
                    $("[data-v-node-id='" + $(this).data('node-id') + "']").prop('disabled', false);
                    $("[data-sv-node-id='" + $(this).data('node-id') + "']").removeClass('disDiv');

                    //departments
                    $("[data-d-node-id='" + $(this).data('node-id') + "']").prop('disabled', false);
                    $("[data-sd-node-id='" + $(this).data('node-id') + "']").removeClass('disDiv');
                }
            });
        });
    }

    function ShowRightExtends(show) {
        if (show === true) {
            $('#sectionForExpand').slideDown('fast');
        }
        else {
            $('#sectionForExpand').slideUp('fast');
        }
    }

    //open window for select image
    $('#uploadNewAva').on('click', function () {
        $('#FileInput').val('');
        $('#FileInput').click();
    });

    //validate user
    $('#UserForm').submit(function () {
        var fields = {};

        fields['UserID'] = $('#modelID').val();
        fields['UserEmail'] = $('#UserEmail').val();
        fields['IsAdd'] = isAdd ? "1" : "0";
        fields['OldPassword'] = $('#pswdCurrr').val();
        fields['UserPassword'] = $('#UserPassword').val();
        fields['UserPasswordConfirm'] = $('#UserPasswordConfirm').val();

        fields['Role_Admin'] = $('#Role_Admin').prop('checked');
        fields['Role_SimpleUser'] = $('#Role_SimpleUser').prop('checked');
        fields['Role_ComplicatedUser'] = $('#Role_ComplicatedUser').prop('checked');
        fields['Role_Db_Admin'] = $('#Role_Db_Admin').prop('checked');
        fields['Role_Db_User'] = $('#Role_Db_User').prop('checked');
        fields['Role_Employee'] = $('#Role_Employee').prop('checked');

        var res = false;

        $.ajax({
            type: "POST",
            async: false,
            url: '/Account/ValidateUser/?fields=' + encodeURIComponent(JSON.stringify(fields)),
            traditional: true,
            success: function (response) {
                if (response != null) {
                    if (!response.success) {//validation is not ok, show errors
                        $('#errors_list').empty();
                        response.Errors.forEach(function (e) {
                            $("#errors_list").append('<li>' + e + '</li>');
                        });

                        $('#validateErrorsmodal').modal('show');

                        //return false;
                    }
                }
                res = response.success;
            }
        });

        return res;
    });

    //upload image to server for convert him to base64
    $("#FileInput").change(function () {
        ShowSpinner(true);
        var data = document.getElementById("FileInput").files[0];
        var formData = new FormData();
        formData.append(data.name, data);

        $.ajax({
            type: 'POST',
            async: true,
            url: '/Users/Upload/',
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            success: function (response) {
                console.log(response);
                if (response.success == true) {
                    $('#modelAvatarBase64').val('data:image/png;base64,' + response.base64);
                    $('#avaPreview').attr('src', 'data:image/png;base64,' + response.base64);
                    ShowSpinner(false);
                }
                else {
                    console.log(response.msg);
                }
            }
        });
    });

    //show modal for enter current password
    $('#btnEditOldPassword').on('click', function () {
        $('#sendPass').prop('disabled', true);
        $('#wrongPass').slideUp();
        $('#pswdCurrr').val('');
        $('#enterPassModal').modal('show');
    });

    //block button when empty pass
    $('#pswdCurrr').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#sendPass').prop('disabled', true);
        }
        else {
            $('#sendPass').prop('disabled', false);
        }
    });

    //send current password
    $('#sendPass').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/Users/TruePass/' + encodeURIComponent($('#modelID').val()) + '/' + encodeURIComponent($('#pswdCurrr').val()),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#UserPassword').prop('readonly', false);
                    $('#comparePasswordDiv').prop('hidden', false);
                    $('#btnEditOldPassword').hide();
                    $('#enterPassModal').modal('hide');
                }
                else {
                    $('#wrongPass').slideDown('fast');
                    $('#sendPass').prop('disabled', true);
                }
            }
        });
    });

    //cancel button
    $('#cancelEdit').on('click', function () {
        if (isAdd)
            window.location.href = "/Users";
        else
            window.location.href = "/Users/Profile/?id=" + encodeURIComponent($('#modelID').val());

    });

    //user can be in one role
    $('#Role_Admin').change(function () {
        if ($(this).prop('checked') == true) {
            ShowRightExtends(false);

            $('#Role_SimpleUser').prop('checked', false);
            $('#Role_ComplicatedUser').prop('checked', false);
            $('#Role_Employee').prop('checked', false);

            $('#adminLossRights').slideUp('fast');
        }
        else {
            ShowRightExtends(false);

            if ($('#IsAdministrator').text() == 'Yes')
                $('#adminLossRights').slideDown('fast');
        }
    });
    $('#Role_SimpleUser').change(function () {
        if ($(this).prop('checked') == true) {
            ShowRightExtends(true);

            $('#Role_Admin').prop('checked', false);
            $('#Role_ComplicatedUser').prop('checked', false);
            $('#Role_Employee').prop('checked', false);

            if ($('#IsAdministrator').text() == 'Yes')
                $('#adminLossRights').slideDown('fast');
        }
        else {
            ShowRightExtends(false);
        }
    });
    $('#Role_ComplicatedUser').change(function () {
        if ($(this).prop('checked') == true) {
            ShowRightExtends(true);

            $('#Role_Admin').prop('checked', false);
            $('#Role_SimpleUser').prop('checked', false);
            $('#Role_Employee').prop('checked', false);

            if ($('#IsAdministrator').text() == 'Yes')
                $('#adminLossRights').slideDown('fast');
        }
        else {
            ShowRightExtends(false);
        }
    });
    $('#Role_Employee').change(function () {
        if ($(this).prop('checked') == true) {
            ShowRightExtends(false);

            $('#Role_Admin').prop('checked', false);
            $('#Role_SimpleUser').prop('checked', false);
            $('#Role_ComplicatedUser').prop('checked', false);

            if ($('#IsAdministrator').text() == 'Yes')
                $('#adminLossRights').slideDown('fast');
        }
        else {
            ShowRightExtends(false);
        }
    });

    //on all switch of devices
    $('#AllovedAllDevc').change('click', function () {
        if ($(this).prop('checked') == true) {
            var checks = $("[id^='AllowDevice']");

            checks.map(function (e) {
                if ($(checks[e]).prop('disabled') != true)
                    $(checks[e]).prop('checked', true);
            });
        }
    });

    //on all switch of departments
    $('#AllovedAllDept').change('click', function () {
        if ($(this).prop('checked') == true) {
            var checks = $("[id^='AllowDepartment']");

            checks.map(function (e) {
                if ($(checks[e]).prop('disabled') != true)
                    $(checks[e]).prop('checked', true);
            });
        }
    });

    //on all switch of nodes
    $('#AllowAllNodes').change('click', function () {
        if ($(this).prop('checked') == true) {
            $("[id^='AllowNode']").prop('checked', true);
        }

        ValidateDevices();
        ValidateDepartments();
    });
    
    //show user roles modals
    $('#showAdminmodal').on('click', () => { $('#adminInfoModal').modal('show'); });
    $('#showUsermodal').on('click', () => { $('#simpleuserInfoModal').modal('show'); });
    $('#showCompUsermodal').on('click', () => { $('#compyuserInfoModal').modal('show'); });
    $('#showEmployeeInfoModal').on('click', () => { $('#employeeInfoModal').modal('show'); });

    ShowRightExtends(!($('#Role_Admin').prop('checked') == true || $('#Role_Employee').prop('checked') == true));
    ShowTitle();
    SetPasswordsFields();
    LoadRights();
});