﻿{
    const STATISTICK_ITEMS = "StatisticMenu";
    const PERSONAL_DATA_ITEMS = "PersonalDataMenu";
    const SERVICE_ITEMS = "ServiceMenu";
    
    let LevelMargin = 7;
    let Menus = [];             //Menu items with tree menu
    let MenusIncludes = {};     //when open left menu
    let itemsList = [];         //list of all added menu items
    let itemsLevel = [];        //list for all added menu items margin set
    let entries = [];           //list of all entriezs
    let entriesState = {};      //state for entries (true: open, false: closed)

    function BuildMenuItem(root, id, title, level, url, icon, chevrone, remote = false) {

        /* create menu tree-item */
        var li = document.createElement('li');
        li.id = root + id;
        li.className = "treeItem";

        var a = document.createElement('a');
        if (remote) {
            a.href = url;
            a.target = '_blank';
        }
        else if (url !== null) {
            a.href = url;
        }
        else {
            a.href = 'javascript:;';
        }
        a.style.marginLeft = LevelMargin * level + "px";

        var ic = document.createElement('i');
        ic.id = "iconTree";
        ic.className = icon;

        var ttl = document.createElement('span');
        ttl.innerHTML = title;

        a.appendChild(ic);
        a.appendChild(ttl);

        if (chevrone) {
            var chev = document.createElement('i');
            chev.className = "fa fa-chevron-down treeChevroneRight treeChevroneSmall";

            a.appendChild(chev);
        }

        li.appendChild(a);

        $(li).insertAfter($('#' + root));

        itemsList.push(li);
        itemsLevel.push(level);

        $(li).hide();

        return li.id;
    }

    function ChangeMenuItemLevel(item, level) {
        /*change left margin for menu items*/
        $(item).find('a').css('margin-left', LevelMargin * level + "px");
    }

    function ShowMenuItemChevron(item, show) {
        /* show or hide chevron icon*/
        if (show) {
            $(item).find($('.treeChevroneRight')).hide();
        }
        else {
            $(item).find($('.treeChevroneRight')).show();
        }
    }

    function RotateMenuItemChevron(item, back) {
        /* show or hide chevron icon*/
        if (back) {
            $('#' + item).find($('.treeChevroneRight')).css('transform', 'rotate(-90deg)');
        }
        else {
            $('#' + item).find($('.treeChevroneRight')).css('transform', 'rotate(0)');
        }
    }

    function ShowEntries(parent, force = false) {
        /*show all providers*/
        entries.forEach(element => {
            if (element.includes(parent)) {
                if (force || entriesState[element]) {
                    $('#' + element).slideDown("fast");

                    entriesState[element] = false;
                }
                else {
                    $('#' + element).slideUp("fast");
                    entriesState[element] = true;
                }

                RotateMenuItemChevron(parent, !entriesState[element]);
            }
        });
    }

    function CheckIncludes() {
        for (key in MenusIncludes) {
            MenusIncludes[key].forEach(e => {
                if (window.location.href.includes(e))
                    ShowEntries(key);
            });
        }
        return false;
    }

    //staistic
    function _addStatisticMenu() {
        Menus.push(STATISTICK_ITEMS);
        MenusIncludes[STATISTICK_ITEMS] = ['/PersonalArea/Statistic'];

        //group calls
        if ($('#LeftSideMenuAdditional_IPTraffic').length > 0) {
            let ip = BuildMenuItem(STATISTICK_ITEMS, "MyIP", $('#LeftSideMenuAdditional_IPTraffic').val(), 1, "/PersonalArea/Statistic/IPTraffic", "fa fa-globe", false);
            entriesState[ip] = true;
            entries.push(ip);
        }

        //group calls
        if ($('#LeftSideMenuAdditional_GroupCalls').length > 0) {
            let gcalls = BuildMenuItem(STATISTICK_ITEMS, "GroupCalls", $('#LeftSideMenuAdditional_GroupCalls').val(), 1, "/PersonalArea/Statistic/GroupCalls", "fa fa-phone-square", false);
            entriesState[gcalls] = true;
            entries.push(gcalls);
        }

        //my calls
        if ($('#LeftSideMenuAdditional_MyCalls').length > 0) {
            let calls = BuildMenuItem(STATISTICK_ITEMS, "MyCalls", $('#LeftSideMenuAdditional_MyCalls').val(), 1, "/PersonalArea/Statistic/MyCalls", "fa fa-phone", false);
            entriesState[calls] = true;
            entries.push(calls);
        }
    }

    //personal data
    function _addPersonalDataMenu() {
        Menus.push(PERSONAL_DATA_ITEMS);
        MenusIncludes[PERSONAL_DATA_ITEMS] = ['/PersonalArea/PersonalData'];

        //gdocuments
        if ($('#LeftSideMenuAdditional_Documents').length > 0) {
            let documents = BuildMenuItem(PERSONAL_DATA_ITEMS, "MyDocuments", $('#LeftSideMenuAdditional_Documents').val(), 1, "/PersonalArea/PersonalData/Documents", "fa fa-file-pdf", false);
            entriesState[documents] = true;
            entries.push(documents);
        }

        //account
        if ($('#LeftSideMenuAdditional_Account').length > 0) {
            let account = BuildMenuItem(PERSONAL_DATA_ITEMS, "MyAccount", $('#LeftSideMenuAdditional_Account').val(), 1, "/PersonalArea/PersonalData/Account", "fa fa-comments-dollar", false);
            entriesState[account] = true;
            entries.push(account);
        }

        //profile
        if ($('#LeftSideMenuAdditional_Profile').length > 0) {
            let profile = BuildMenuItem(PERSONAL_DATA_ITEMS, "MyProfile", $('#LeftSideMenuAdditional_Profile').val(), 1, "/PersonalArea/PersonalData/Profile", "fa fa-user-circle", false);
            entriesState[profile] = true;
            entries.push(profile);
        }
    }

    //service
    function _addServiceMenu() {
        Menus.push(SERVICE_ITEMS);
        MenusIncludes[SERVICE_ITEMS] = ['/PersonalArea/Service'];

        //abonents
        if ($('#LeftSideMenuAdditional_Destinations').length > 0) {
            let dest = BuildMenuItem(SERVICE_ITEMS, "Destinations", $('#LeftSideMenuAdditional_Destinations').val(), 1, "/PersonalArea/Service/Destinations", "fa fa-map-marked-alt", false);
            entriesState[dest] = true;
            entries.push(dest);
        }

        //abonents
        if ($('#LeftSideMenuAdditional_Abonents').length > 0) {
            let abonents = BuildMenuItem(SERVICE_ITEMS, "PublicAbonents", $('#LeftSideMenuAdditional_Abonents').val(), 1, "/PersonalArea/Service/Phones", "fa fa-users", false);
            entriesState[abonents] = true;
            entries.push(abonents);
        }

        //issues
        if ($('#LeftSideMenuAdditional_Issues').length > 0) {
            let issues = BuildMenuItem(SERVICE_ITEMS, "MyIssues", $('#LeftSideMenuAdditional_Issues').val(), 1, "/PersonalArea/Service/Issues", "fa fa-bug", false);
            entriesState[issues] = true;
            entries.push(issues);
        }

        //phonr book
        if ($('#LeftSideMenuAdditional_PB').length > 0) {
            let pb = BuildMenuItem(SERVICE_ITEMS, "PhoneBook", $('#LeftSideMenuAdditional_PB').val(), 1, "/PersonalArea/Service/PhoneBook", "fa fa-address-book", false);
            entriesState[pb] = true;
            entries.push(pb);
        }
    }

    /*Add menus here*/
    function AddItemsToMenu() {
        if ($(`#${PERSONAL_DATA_ITEMS}`).length > 0) {
            _addPersonalDataMenu();
        }

        if ($(`#${STATISTICK_ITEMS}`).length > 0) {
            _addStatisticMenu();
        }

        if ($(`#${SERVICE_ITEMS}`).length > 0) {
            _addServiceMenu();
        }
    }

    function MenuClickEvents() {
        Menus.forEach(e => { $('#' + e).click(() => { ShowEntries(e); }); });
    }

    function HamburgerMenuEvent() {
        $('#MenuHamburger').on('click', function () {
            if ($('#SideMenu').width() >= 250) {
                itemsList.forEach(function (element) {
                    ChangeMenuItemLevel(element, 0);
                    ShowMenuItemChevron(element, true);
                });

                Menus.forEach((e) => { ShowMenuItemChevron($('#' + e), true); });

            }
            else {
                var i = 0;
                itemsList.forEach(function (element) {
                    ChangeMenuItemLevel(element, itemsLevel[i]);
                    ShowMenuItemChevron(element, false);
                    i++;
                });
                Menus.forEach(e => { ShowMenuItemChevron($('#' + e), false); });
            }

        });
    }

    $(document).ready(function () {
        AddItemsToMenu();
        MenuClickEvents();
        HamburgerMenuEvent();
        CheckIncludes();
    });
}