﻿$(document).ready(function () {
    var selectedVar = null;

    function Export(t) {
        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");

        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/SystemVariables/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/SystemVariables/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }

                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function UpdateButtonsUI() {
        /*update ui for buttons when not selected any var some buttons disabled*/
        if (selectedVar === null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
        }
    }

    function AttachEventsToTable() {
        var header = document.getElementById("sysVarHeader");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        //events for table
        $('#tariscope-sv tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedVar = null;
            }
            else {
                selectedVar = $(this).find('td[data-name="Key"]').text();
                $('#tariscope-sv tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtonsUI();
        });

        UpdateButtonsUI();

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/SystemVariables/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        UpdateTable($('#tbSearch').val());
                    }
                }
            });
        });
    }

    function UpdateTable(e) {
        //update table with sys vars
        selectedVar = null;
        $('#sysVarTable').load('/SystemVariables/Search/?s=' + encodeURIComponent(e), AttachEventsToTable);
    }

    //events for buttons
    var typingTimer;                //timer identifier
    var doneTypingInterval = 700;   //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            UpdateTable($('#tbSearch').val());
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //open modal for add new var
    $('#btnAdd').on('click', function () {
        $('#add').prop('hidden', false);
        $('#edit').prop('hidden', true);

        $('#VarName').val('');
        $('#VarNameSection').prop('hidden', false);
        $('#VarValue').val('');

        $('#saveSysVar').prop('disabled', true);

        $('#addeditModal').modal('show');
    });

    //open modal for edit
    $('#btnEdit').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/SystemVariables/GetVar/?key=' + encodeURIComponent(selectedVar),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#add').prop('hidden', true);
                    $('#edit').prop('hidden', false);

                    $('#editedName').html(response.Key);

                    $('#VarName').val(response.Key);
                    $('#VarValue').val(response.Value);
                    $('#VarDescription').val(response.Description);
                    $('#VarNameSection').prop('hidden', true);
                    $('#saveSysVar').prop('disabled', false);
                    $('#addeditModal').modal('show');
                }
            }
        });
    });

    //show message when empty name
    $('#VarName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyName').slideDown('fast');
            $('#wrongName').slideUp('fast');
            $('#saveSysVar').prop('disabled', true);
        }
        else {
            $('#emptyName').slideUp('fast');
            $('#wrongName').slideUp('fast');
            $('#saveSysVar').prop('disabled', false);
        }
    });

    //save new var or edit existing
    $('#saveSysVar').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/SystemVariables/Edit/?key=' + encodeURIComponent($('#VarName').val()) + '&value=' + encodeURIComponent($('#VarValue').val()) + '&IsEdit=' + $('#add').prop('hidden') + '&description=' + encodeURIComponent($('#VarDescription').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateTable($('#tbSearch').val());
                    $('#addeditModal').modal('hide');
                }
                else if (response !== null && response.isfree === false) {
                    $('#wrongName').slideDown('fast');
                    $('#saveSysVar').prop('disabled', true);
                }
                else {
                    $('#addeditModal').modal('hide');
                }
            }
        });
    });

    //show modal for delete selected var
    $('#btnDelete').on('click', function () {
        $('#cannotDelete').slideUp('fast');
        $('#DeleteConfirm').prop('disabled', false);
        $('#confirmDelete').modal('show');
    });

    //confirm deleting selected var
    $('#DeleteConfirm').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/SystemVariables/Delete/?key=' + encodeURIComponent(selectedVar),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateTable($('#tbSearch').val());
                    $('#confirmDelete').modal('hide');
                }
                else {
                    $('#cannotDelete').slideDown('fast');
                    $('#DeleteConfirm').prop('disabled', true);
                }
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //edit instance name
    $('#btnInctanceName').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/SystemVariables/GetVar/?key=WebAdmin_InstanceName',
            traditional: true,
            success: function (response) {
                if (response !== null) {
                    $('#InstanceName').val(response.Value ? response.Value : '');
                    $('#SetInctanceNameModal').modal('show');
                }
            }
        });
    });

    //save instance name
    $('#InstanceNameBtnSave').on('click', () => {
        $('#SetInctanceNameModal').modal('hide');

        $.ajax({
            type: "POST",
            async: true,
            url: '/SystemVariables/SetInstanceName/?name=' + encodeURIComponent($('#InstanceName').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateTable($('#tbSearch').val());
                }
            }
        });
    });

    UpdateTable('');
});