﻿using System;
using Microsoft.Data.SqlClient;
using SoftPi.Tariscope.Common;
using SoftPi.Tariscope.DAL;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;

public class SetCosEmailScript : IScript
{
    private IScriptHost _host;

    public void Init(IScriptHost host)
    {
        _host = host;
        host.Close += OnClose;
    }
    private void OnClose(ref bool Cancel)
    {
        return;
    }
    public void Main(object Parameters)
    {
        try
        {
            SubscriberLimitingActionParameters ActionParameters = (SubscriberLimitingActionParameters)Parameters;

            _host.AddEvent(string.Format("Restrict subscriber:{0} Cos:{1}, Category: {2}", ActionParameters.Abonent.AbonentName, ActionParameters.CosValue, ActionParameters.Credit.CategoryID));
            _host.AddEvent(ActionParameters.ActionType.ToString());

            string CategoryName;
            using (SqlConnection cn = new SqlConnection(_host.DatabaseConnectionString))
            {
                cn.Open();
                if (ActionParameters.Credit.CategoryID.HasValue)
                    CategoryName = new Categories(cn).Details(ActionParameters.Credit.CategoryID.Value).Name;
                else
                    CategoryName = "All categories";
            }
            if (ActionParameters.ActionType == RestrictStatus.QueueRestrict)
            {
                string MessageText = string.Format("Restrict subscriber:{0}, Cos:{1}, Category: {2}, Limit: {3}, Charged: {4}", ActionParameters.Abonent.AbonentName, ActionParameters.CosValue, CategoryName, ActionParameters.Credit.Credit, ActionParameters.Credit.Debit);
                _host.SendMail("", "Tariscope limiting notification", MessageText);

                _host.Wait(5000);

                string MessageText2 = string.Format("Dear {0}!     You limit exceeded for category: {1}. Limit: {2}, Charged: {3}", ActionParameters.Abonent.AbonentName, CategoryName, ActionParameters.Credit.Credit, ActionParameters.Credit.Debit);
                _host.SendMail(ActionParameters.Abonent.EMail, "Telephony limiting", MessageText2);
                _host.Wait(5000);
            }
            else if (ActionParameters.ActionType == RestrictStatus.QueueUnrestrict)
            {
                string MessageText = string.Format("Unrestrict subscriber:{0}, Cos:{1}, Category: {2}", ActionParameters.Abonent.AbonentName, ActionParameters.CosValue, CategoryName);
                _host.SendMail("", "Tariscope limiting notification (Unrestrict)", MessageText);

                _host.Wait(5000);
            }
            ActionParameters.Result = MediationActionResult.Success;
        }
        catch (Exception ex)
        {
            _host.AddEvent(ex.ToString());
        }
    }
}
