#!/bin/bash
echo
echo "Update Tariscope Linux"
echo "-------------------------------------"
echo "Start this script only if:"
echo "1. You have made a backup of the current DB!"
echo "2. Tariscope is installed in /opt/tariscope!"
echo "3. Run this script just as root (su)!"
echo "4. Attention always use the separate scripts rrun.sh & ts-install.sh. Not the ones in the *.gz! These sometimes cause errors!"
echo "Adjust the script before running, if point 2 does not apply!"
echo
read -p "Do you want to proceed? (yes/no) " yn

case $yn in
        yes ) echo ok, we will proceed;;
        no ) echo exiting...;
                exit;;
        * ) echo invalid response;
                exit 1;;
esac

sleep 2
echo "Step 01: Creat folder for update files ('/home/tariscope_update')!"
echo
sudo mkdir /home/tariscope_update

sleep 2
echo "Step 02: Backup app settings (Tariscope installed under '/opt/tariscope')!"
echo
sudo cp /opt/tariscope/www/appsettings.json /home/tariscope_update/

sleep 2
echo "Step 03: Download latest Tariscope Version!"
echo
wget -P /home/tariscope_update/ http://softpiua.com/files/tariscope46.tar.gz
wget -P /home/tariscope_update/ http://softpiua.com/files/ts-install.sh
wget -P /home/tariscope_update/ http://softpiua.com/files/rrun.sh

if [[ ! -f /home/tariscope_update/tariscope46.tar.gz ]] ; then
    sleep 5
    echo 'Installation files missing or download failed! '
            echo
    sleep 5
    echo "Delete update created update folders!"
            echo
    rm -r /home/tariscope_update
    exit
fi

sleep 5
echo "Step 04: Stop all active services!"
echo
sudo service TS.MAIN stop
sleep 5
sudo systemctl disable TS.MAIN.service

sleep 5
echo "Step 05: Delete all services (TS.MAIN.service, TS.REPORTER.service and TS.SCHEDULER.service in '/etc/systemd/system')!"
echo
sudo rm -r /etc/systemd/system/TS.*

sleep 5
echo "Step 06: Reload Systemctl-Deamon"
echo 
sudo systemctl daemon-reload

sleep 2
echo "Step 07: Rename old Tariscope folder to update date '$(date +"tariscope_%Y%m%d")' !"
echo
mv /opt/tariscope/ /opt/$(date +"tariscope_%Y%m%d")

sleep 2
echo "Step 08: Creat folder for new version ('/opt/tariscope/')!"
echo
mkdir /opt/tariscope

sleep 2cd 
echo "Step 09: Copy existing Views from old version to new Tariscope folder!"
echo
cd /opt/$(date +"tariscope_%Y%m%d")/
cp -r /opt/$(date +"tariscope_%Y%m%d")/Views /opt/tariscope/

sleep 2
echo "Step 10: Extract new Tariscope version into ('/opt/tariscope/')!"
echo
tar -xvzf /home/tariscope_update/tariscope46.tar.gz --directory /opt/tariscope

sleep 2
echo "Step 11: Start Update!"
echo
sudo rm -r /opt/tariscope/ts-install.sh
sudo cp -r /home/tariscope_update/ts-install.sh /opt/tariscope
sudo chmod +x /opt/tariscope/ts-install.sh
cd /opt/tariscope/
sudo sh ts-install.sh -p /opt/tariscope

sleep 2
echo "Step 12: Copy settings back!"
echo
sudo mv /opt/tariscope/www/appsettings.json /opt/tariscope/www/appsettings.json_orig
sudo cp -r /home/tariscope_update/appsettings.json /opt/tariscope/www/

sleep 2
echo "Step 13: Implement service!"
echo
sudo rm -r /opt/tariscope/www/rrun.sh
sudo cp -r /home/tariscope_update/rrun.sh /opt/tariscope/www
sudo chmod +x /opt/tariscope/www/rrun.sh
cd /opt/tariscope/www/
sudo sh rrun.sh
rm -r /home/tariscope_update

sleep 2
echo "Step 14: Update done!"
