﻿$(document).ready(() => {
    let SelectedAbonent = null;

    function UpdateMainButtonsUI() {
        if (SelectedAbonent == null) {
            $("#btnAccount").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
        }
        else {
            $("#btnAccount").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
        }
    }

    function AttachEventsMainTable() {
        var header = document.getElementById("servicesHead");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        /*table events*/
        $('#abnormalAbonents_table tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                SelectedAbonent = null;
            }
            else {
                SelectedAbonent = $(this).find('td[data-name="ID"]').text();
                $('#abnormalAbonents_table tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateMainButtonsUI();
        });

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/AI/Prediction/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        Load();
                    }
                }
            });
        });

        UpdateMainButtonsUI();
    }

    function Load() {
        $('#ReportEntryBody').load('/AI/Prediction/ReportAbonents?search=' + encodeURIComponent($('#tbSearch').val()), AttachEventsMainTable);
    }

    /*atach input event to search textbox*/
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            Load();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //open account in external page
    $('#btnAccount').on('click', () => { window.open('/AccountSummary#' + SelectedAbonent, "_target"); });

    //remove the abonent from the list
    $('#btnDelete').on('click', () => { $('#ClearSelectedModal').modal('show'); });
    $('#ClearSelectedBtn').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/AI/Prediction/RemoveAbnormal/' + SelectedAbonent,
            success: function (response) {
                ShowSpinner(false);
                if (response != null && response.success == true) {
                    Load();
                    SelectedAbonent = null;
                }
            }
        });
    });

    //remove all abonents from the list
    $('#btnDeleteAll').on('click', () => { $('#ClearAllModal').modal('show'); });
    $('#ClearAllBtn').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/AI/Prediction/RemoveAbnormal/-1',
            success: function (response) {
                ShowSpinner(false);
                if (response != null && response.success == true) {
                    Load();
                    SelectedAbonent = null;
                }
            }
        });
    });

    Load();
});