﻿$(document).ready(() => {
    let selectedRow = null;
    let isGroup = false;

    function ExpandLeftMenu() {
        try {
            if (NodeIsLoaded) {
                ShowNodes('NewNodesMenu');
                ShowNodeEntry($('#nodeID').val() + '');
                ShowDevices('CNode_' + $('#nodeID').val() + '');
                ShowDeviceContent('CNode_' + $('#nodeID').val() + 'CSelectedDevice_' + $('#deviceID').val());
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }
    }

    function UpdateButtons() {
        if (selectedRow === null) {
            $("#btnAddResGroupClass").attr("disabled", true);
            $("#btnEdit").attr("disabled", true);
            $("#btnSetCategories").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
        }
        else {
            $("#btnAddResGroupClass").attr("disabled", !isGroup);
            $("#btnEdit").attr("disabled", false);
            $("#btnSetCategories").attr("disabled", isGroup);
            $("#btnDelete").attr("disabled", false);
        }
    }

    function AttachEventsToTable() {
        if (selectedRow !== null && isGroup) {
            let row = $('tr[data-d="1"] > td[data-name="ID"]:contains("' + selectedRow + '")').parent();
            row.treegrid('expand');
        }


        selectedRow = null;

        $('#tariscope-rc tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedRow = null;
                isGroup = false;
            }
            else {
                selectedRow = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-rc tr.selected').removeClass('selected');
                $(this).addClass('selected');
                isGroup = $(this).data('d') * 1 == 1;
            }

            UpdateButtons();
        });
        UpdateButtons();
    }

    function Load() {
        $('#rcTable').load('/Devices/RestrictionClasses/Load/' + $('#deviceID').val(), AttachEventsToTable);
    }

    //show modals for delete
    $('#btnDelete').on('click', () => {
        if (isGroup) {
            $('#deleteRestrictGroupmodal').modal('show');
        }
        else {
            $('#deleteRestrictClassmodal').modal('show');
        }
    });

    //confirm delete group
    $('#deleteGroupconfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Devices/RestrictionClasses/Group/Delete/' + selectedRow,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#deleteRestrictGroupmodal').modal('hide');
                    let row = $('tr[data-d="1"] > td[data-name="ID"]:contains("' + selectedRow + '")').parent()
                    row.treegrid('collapse');
                    row.remove();

                    selectedRow = null;
                    isGroup = false;
                }
            }
        });
    });

    //confirm delete class
    $('#deleteClassconfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Devices/RestrictionClasses/Class/Delete/' + selectedRow,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#deleteRestrictClassmodal').modal('hide');
                    $('tr[data-d="0"] > td[data-name="ID"]:contains("' + selectedRow + '")').parent().remove();

                    selectedRow = null;
                    isGroup = false;
                    UpdateButtons();
                }
            }
        });
    });

    //show modal to add restriciton group
    $('#btnAddResGroup').on('click', () => {
        $('#groupName').val('');
        $('#saveRestricitonGroup').prop('disabled', true);
        $('#emprtGroupName').hide();

        //add grou confimr
        $('#saveRestricitonGroup').unbind();
        $('#saveRestricitonGroup').on('click', () => {
            $.ajax({
                type: "POST",
                url: '/Devices/RestrictionClasses/Group/Add/?Name=' + encodeURIComponent($('#groupName').val()),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#editGroup').modal('hide');
                        Load();
                    }
                }
            });
        });

        $('#editGroup').modal('show');
    });

    //show error when emprty group name
    $('#groupName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emprtGroupName').slideDown('fast');
            $('#saveRestricitonGroup').prop('disabled', true);
        }
        else {
            $('#emprtGroupName').slideUp('fast');
            $('#saveRestricitonGroup').prop('disabled', false);
        }
    });

    //show modal for add restriciton class
    $('#btnAddResGroupClass').on('click', () => {
        $('#saveRestrictionClass').unbind();

        $('#emptyClass').hide();
        $('#className').val('');
        $('#classClass').val('');

        $('#saveRestrictionClass').prop('disabled', true);

        //confirm add a new restriciton class
        $('#saveRestrictionClass').on('click', () => {
            $.ajax({
                type: "POST",
                url: '/Devices/RestrictionClasses/Class/Add/' + $('#deviceID').val() + '/' + selectedRow
                    + '/?Name=' + encodeURIComponent($('#className').val())
                    + '&Class=' + encodeURIComponent($('#classClass').val()),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#editClass').modal('hide');
                        Load();
                    }
                }
            });
        });

        $('#editClass').modal('show');
    });

    //show error when empty class name
    $('#className').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyClass').slideDown('fast');
            $('#saveRestrictionClass').prop('disabled', true);
        }
        else {
            $('#emptyClass').slideUp('fast');
            $('#saveRestrictionClass').prop('disabled', false);
        }
    });

    //show modal for edit group or class
    $('#btnEdit').on('click', () => {
        $('#saveRestrictionClass').unbind();

        if (isGroup) {
            $('#saveRestricitonGroup').unbind();

            $('#groupName').val($('strong[data-groupidname="' + selectedRow + '"]').text());

            $('#saveRestricitonGroup').prop('disabled', false);
            $('#emprtGroupName').hide();

            //edit group confimr
            $('#saveRestricitonGroup').on('click', () => {
                $.ajax({
                    type: "POST",
                    url: '/Devices/RestrictionClasses/Group/Edit/' + selectedRow + '/?Name=' + encodeURIComponent($('#groupName').val()),
                    traditional: true,
                    success: function (response) {
                        if (response !== null && response.success === true) {
                            $('#editGroup').modal('hide');
                            Load();
                        }
                    }
                });
            });

            $('#editGroup').modal('show');
        }
        else {
            $('#emptyClass').hide();
            $('#className').val($('span[data-classidname="' + selectedRow + '"]').text());
            $('#classClass').val($('td[data-classidclass="' + selectedRow + '"]').text());

            $('#saveRestrictionClass').prop('disabled', true);

            //confirm add a new restriciton class
            $('#saveRestrictionClass').on('click', () => {
                $.ajax({
                    type: "POST",
                    url: '/Devices/RestrictionClasses/Class/Edit/' + $('#deviceID').val() + '/' + selectedRow
                        + '/?Name=' + encodeURIComponent($('#className').val())
                        + '&Class=' + encodeURIComponent($('#classClass').val()),
                    traditional: true,
                    success: function (response) {
                        if (response !== null && response.success === true) {
                            $('#editClass').modal('hide');

                            $('span[data-classidname="' + selectedRow + '"]').text($('#className').val());
                            $('td[data-classidclass="' + selectedRow + '"]').text($('#classClass').val());
                        }
                    }
                });
            });

            $('#editClass').modal('show')
        }
    });

    //show modal for set categories
    $('#btnSetCategories').on('click', () => {
        $('.CB').prop('checked', false);

        $('#classNameFC').text($('span[data-classidname="' + selectedRow + '"]').text());

        $.ajax({
            type: "POST",
            url: '/Devices/RestrictionClasses/Class/GetCategories/' + $('#deviceID').val() + '/' + selectedRow,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    response.cats.map(e => {
                        $('#cats_' + e).prop('checked', true);
                    })

                    $('#setCatmodal').modal('show');
                }
            }
        });
    });

    //save configured categories
    $('#btnSaveCategories').on('click', () => {
        let c = [];
        let els = $('input[class="CB"]:checked');
        els.each(e => {
            c.push($(els[e]).data('id'));
        });

        $.ajax({
            type: "POST",
            url: '/Devices/RestrictionClasses/Class/SetCategories/' + $('#deviceID').val() + '/' + selectedRow + '/?Categories=' + c.join(','),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    Load();
                    $('#setCatmodal').modal('hide');
                }
            }
        });
    });

    Load();
    ExpandLeftMenu();
});