﻿$(document).ready(() => {
    let interval = 2000;
    let timerID = null;
    let setSticky = false;

    function ExpandLeftMenu() {
        try {
            if (ObserversIsLoaded) {
                ShowObservers('ObserverMenu', true);
                ShowObserversContent('ObserverMenu_' + $('#ProfileName').val().replace(' ', '_'));
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }

    }

    function AttachEventsToTable() {
        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/Observers/LastCalls/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        clearTimeout(timerID);
                        Load();
                    }
                }
            });
        });

        timerID = setTimeout(Load, interval);

        if (!setSticky)
            SetSticky();
    }

    function Load() {
        let source = '';

        if ($('#PBXID').val() * 1 > 0) source = 'Remote/' + $('#PBXID').val();
        else source = 'Local/' + encodeURIComponent($('#ProfileName').val());

        $('#lastCallsTable').load('/Observers/LoadLastCalls/' + source, AttachEventsToTable);
    }

    function SetSticky() {
        header = document.getElementsByTagName("thead")[0];                 //for sticky head
        sticky = header.offsetTop;                                   //for sticky head

        //animate scroll top
        $('.go-top').on('click', function (event) {
            event.preventDefault();
            $('html, body').animate({ scrollTop: 0 }, 300);
        });

        //event for show go top button
        $(window).on("scroll", function () {
            //for go top button
            if ($(this).scrollTop() > 200) {
                $('.go-top').fadeIn(200);
            } else {
                $('.go-top').fadeOut(200);
            }

            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
                $('thead').width($('table').width());
            } else {
                header.classList.remove("sticky");
            }
        });

        setSticky = true;
    }

    Load();
    ExpandLeftMenu();
});