﻿$(document).ready(() => {
    var append = false;
    var logID = null;
    var UpdateLog = false;

    function ExpandLeftMenu() {
        try {
            if (ObserversIsLoaded) {
                ShowObservers('ObserverMenu', true);
                ShowObserversContent('ObserverMenu_' + $('#OBSName').val().replace(' ', '_'));
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }

    }

    function ScrollDown() {
        //scrolling down page
        $("html, body").animate({ scrollTop: $(document).height() }, 500);
    }

    function ReadLog() {
        console.log('ReadLog: logID = ' + logID + ', window.UpdateLog = ' + UpdateLog + ', append = ' + append);
        //reading log file line by line
        if (UpdateLog)
            $.ajax({
                type: "POST",
                async: true,
                url: '/Observers/ReadCDR/' + encodeURIComponent($('#OBSName').val()) + '/?Append=' + append,
                success: function (response) {
                    if (response !== null && response.success === true) {

                        var items = 0;
                        response.lines.forEach(function (e) {
                            var item = $('<p class="">' + e + '</p>');
                            $('#LogContainer').append($(item));
                            items++;
                        });

                        if (!append || items > 0)
                            ScrollDown();
                        append = true;

                        logID = setTimeout(ReadLog, 1000);
                    }
                }
            });

    }

    function UpdateLogButtonsAndAlert() {
        //update buttons for log (disable or enable run and stop buttons)
        $.ajax({
            type: "POST",
            async: true,
            url: '/Observers/SvcInfo/' + encodeURIComponent($('#OBSName').val()),
            success: function (response) {
                if (response !== null && response.success === true) {

                    switch (response.ServiceStatus) {
                        default:
                        case -1://not installed
                            $('#btnRun_log').attr('disabled', true);
                            $('#btnStop_log').attr('disabled', true);
                            $('#svcNotInstaled').slideDown('fast');
                            break;
                        case 1://stop
                            $('#btnRun_log').attr('disabled', false);
                            $('#btnStop_log').attr('disabled', true);
                            $('#svcNotInstaled').slideUp('fast');
                            break;
                        case 4://run
                            $('#btnRun_log').attr('disabled', true);
                            $('#btnStop_log').attr('disabled', false);
                            $('#svcNotInstaled').slideUp('fast');
                            break;
                    }
                }
            }
        });
    }

    function AttachEventsForLog() {
        var header = document.getElementById("logHead");                 //for sticky head
        var sticky = header.offsetTop;                                   //for sticky head

        //animate scroll top
        $('.go-top').on('click', function (event) {
            event.preventDefault();
            $('html, body').animate({ scrollTop: 0 }, 300);
        });

        //event for show go top button
        $(window).on("scroll", function () {
            //for go top button
            if ($(this).scrollTop() > 200) {
                $('.go-top').fadeIn(200);
            } else {
                $('.go-top').fadeOut(200);
            }

            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
                $('#logHead').width($('#LogContainer').width());
            } else {
                header.classList.remove("sticky");
            }
        });

        //back to settings
        $('#btnBack, #BackTo').on('click', () => { window.open('/Observers', '_parent'); });

        //download
        $('#btnLogDownload').on('click', () => {
            window.open('/Observers/DownloadCDR/' + encodeURIComponent($('#OBSName').val()), '_blank');
        });
    }

    AttachEventsForLog();
    UpdateLogButtonsAndAlert();

    UpdateLog = true;
    ReadLog();
    ExpandLeftMenu();
});