﻿$(document).ready(() => {
    let selectedPayment = null;
    let IsEdit = false;

    function UpdateRateButtonsUI() {
        if (selectedPayment === null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
        }
    }

    function AttachEventsToTable() {
        /*table events*/
        $('#tariscope-payments tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedPayment = null;
            }
            else {
                selectedPayment = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-payments tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }
            UpdateRateButtonsUI();
        });

        UpdateRateButtonsUI();
    }

    function Load() {
        selectedPayment = null;
        $('#paymentsTable').load('/Payments/Get', AttachEventsToTable);
    }

    function RecalculateLimitState() {
        let current = $('#currentCost').val() * 1;
        let max = $('#maxCost').val() * 1;

        $('#CurrentCost').removeClass('text-success');
        $('#MaxCost').removeClass('text-success');
        $('#CurrentCost').removeClass('text-danger');
        $('#MaxCost').removeClass('text-danger');

        if (current > max) {
            $('#CurrentCost').removeClass('text-success');
            $('#CurrentCost').addClass('text-danger');
            $('#sendPayments').prop('disabled', true);
        }
        else if (current < max) {
            $('#CurrentCost').removeClass('text-danger');
            $('#CurrentCost').addClass('text-success');
            $('#MaxCost').removeClass('text-success');
            $('#MaxCost').addClass('text-danger');
            $('#sendPayments').prop('disabled', true);
        }
        else {
            $('#CurrentCost').removeClass('text-danger');
            $('#CurrentCost').addClass('text-success');
            $('#sendPayments').prop('disabled', false);
        }
    }

    function initDateTimepicker() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: true,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepickerPay').datetimepicker(daytimeOpitions);

        try {
            $('#datetimepickerPay').data("DateTimePicker").setDate(new Date());
        } catch (e) { console.log(e); }
    }

    function initTypeSelect() {
        $('#subscriberSelect').select2({
            theme: "bootstrap",
            templateResult: function (data) {
                let r = data.text.split('~');
                var $result = $(
                    '<div class="row" style="width: 90%;">' +
                    '<div class="col-md-3">' + r[0] + '</div>' +
                    '<div class="col-md-5">' + r[1] + '</div>' +
                    '<div class="col-md-4">' + r[2] + '</div>' +
                    '</div>'
                );
                return $result;
            },
            templateSelection: function (data) {
                var r = data.text.split('~');
                var $result = $('<p style="margin-top: 5px;">' + r[1] + '</p>');
                return $result;
            }
        });
    }

    //show modal to change limit
    $('#changeLimit').on('click', () => {
        $('#saveNewLimit').prop('disabled', false);
        $('#newLimit').val($('#MaxCost').text());
        $('#newLimitError').hide();
        $('#batchMaxmodal').modal('show');
    });

    //save new limit
    $('#saveNewLimit').on('click', () => {
        $('#MaxCost').text($('#newLimit').val() * 1);
        $('#maxCost').val($('#newLimit').val() * 1);
        RecalculateLimitState();
        $('#batchMaxmodal').modal('hide');
    });

    //new limit error
    $('#newLimit').on('input', function () {
        if (!$(this).val() || !$(this).val().trim() || ($(this).val() * 1 <= 0) || isNaN($(this).val() * 1)) {
            console.log(1);
            $('#newLimitError').slideDown('fast');
            $('#saveNewLimit').prop('disabled', true);
        }
        else {
            console.log(2);
            $('#newLimitError').slideUp('fast');
            $('#saveNewLimit').prop('disabled', false);
        }
    });

    //show modal for add payment
    $('#btnAdd').on('click', () => {
        IsEdit = false;
        $.ajax({
            type: "POST",
            url: '/AccountSummary/GetBanks/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#bankList').empty();

                    response.list.map((e) => {
                        $($('#bankList')).append('<option value="' + e.Value + '" />');
                    });

                    initDateTimepicker();

                    $('#paycost').val('0');
                    $('#paymentType').val('0');
                    $('#paymentDescription').val('');
                    $('#payBank').val('');
                    $('#payModal').modal('show');

                    setTimeout(initTypeSelect, 300);
                }
            }
        });
    });

    //payment modal confirm
    $('#AddPaymentConfirm').on('click', () => {
        if (IsEdit) {
            $.ajax({
                type: "POST",
                url: '/Payments/Edit/?PaymentID=' + encodeURIComponent(selectedPayment) +
                    '&AbonentID=' + $('#subscriberSelect').val() +
                    '&Cost=' + $('#paycost').val() +
                    '&PaymentDate=' + encodeURIComponent($('#datetimepickerPay').data('date')) +
                    '&Bank=' + encodeURIComponent($('#payBank').val()) +
                    '&Description=' + encodeURIComponent($('#paymentDescription').val()) +
                    '&PaymentType=' + $('#paymentType').val(),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#payModal').modal('hide');
                        $('#currentCost').val(response.current);
                        $('#CurrentCost').text(response.current);
                        RecalculateLimitState();
                        Load();
                    }
                }
            });
        }
        else {
            $.ajax({
                type: "POST",
                url: '/Payments/Add/?ID=' + $('#subscriberSelect').val() +
                    '&Cost=' + $('#paycost').val() +
                    '&PaymentDate=' + encodeURIComponent($('#datetimepickerPay').data('date')) +
                    '&Bank=' + encodeURIComponent($('#payBank').val()) +
                    '&Description=' + encodeURIComponent($('#paymentDescription').val()) +
                    '&PaymentType=' + $('#paymentType').val(),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#payModal').modal('hide');
                        $('#currentCost').val(response.current);
                        $('#CurrentCost').text(response.current);
                        RecalculateLimitState();
                        Load();
                    }
                }
            });
        }
    });

    //show modal to delete the payment
    $('#btnDelete').on('click', () => { $('#deletePayment').modal('show'); });

    //confirm delete
    $('#deletePaymentbtn').on('click', () => {
        $('#deletePayment').modal('hide');
        $.ajax({
            type: "POST",
            url: '/Payments/Delete/?ID=' + encodeURIComponent(selectedPayment),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#currentCost').val(response.current);
                    $('#CurrentCost').text(response.current);
                    RecalculateLimitState();
                    Load();
                }
            }
        });
    });

    //show modal to edit the payment
    $('#btnEdit').on('click', () => {
        IsEdit = true;
        $.ajax({
            type: "POST",
            url: '/Payments/GetForEdit/?ID=' + encodeURIComponent(selectedPayment),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    console.log(response);

                    $.ajax({
                        type: "POST",
                        url: '/AccountSummary/GetBanks/',
                        traditional: true,
                        success: function (response2) {
                            if (response2 !== null && response2.success === true) {

                                $('#bankList').empty();

                                response2.list.map((e) => {
                                    $($('#bankList')).append('<option value="' + e.Value + '" />');
                                });

                                initDateTimepicker();
                                $('#datetimepickerPay').data("DateTimePicker").setDate(new Date(response.payment.Payment.PaymentDate));


                                $('#subscriberSelect').val(response.payment.Payment.AbonentId);
                                $('#paycost').val(response.payment.Payment.Amount);
                                $('#paymentType').val(response.payment.Payment.PaymentType);
                                $('#paymentDescription').val(response.payment.Payment.Description);
                                $('#payBank').val(response.payment.Payment.BankName);
                                $('#payModal').modal('show');

                                setTimeout(initTypeSelect, 300);
                            }
                        }
                    });
                }
            }
        });
    });

    //save payments
    $('#sendPayments').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/Payments/Save/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    window.open('/AccountSummary', '_parent');
                }
            }
        });
    });

    Load();
});