﻿$(document).ready(() => {
    let summaryAjax = null;

    function LoadSummary(url) {
        //load summary for period
        if (summaryAjax !== null)
            summaryAjax.abort();

        PlayLoadAnimation('AccountStatus', true);

        summaryAjax = $.ajax({
            type: "POST",
            url: '/PersonalArea/PersonalData/Account/GetAccountSummary/' + url,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#StartDebt').val(response.summary.StartDebt.toFixed(2));
                    $('#EndDebt').val(response.summary.EndDebt.toFixed(2));
                    $('#MonthCharges').val(response.summary.MonthCharges.toFixed(2));
                    $('#MonthPayments').val(response.summary.MonthPayments.toFixed(2));
                    $('#PredictedCharges').val(response.summary.PredictedCharges.toFixed(2));

                    PlayLoadAnimation('AccountStatus', false);
                }
            }
        });
    }

    function PanelIsVisible(name) {
        //return true if panel opened
        return $('#' + name + '_body').is(':visible') === true;
    }

    function PlayLoadAnimation(name, show) {
        //show load anim,ation
        if (show === true) {
            $('#' + name + '_body').addClass('disDiv');
            $('#' + name + '_load').show();
        }
        else {
            $('#' + name + '_body').removeClass('disDiv');
            $('#' + name + '_load').hide();
        }
    }

    function PanelControll(name, show) {
        //open and close panels
        if (show === true) {
            $('#' + name + '_body').slideDown('fast');
            $('#' + name + '_icon').css('transform', 'rotate(180deg)');
        }
        else {
            $('#' + name + '_body').slideUp('fast');
            $('#' + name + '_icon').css('transform', 'rotate(0deg)');
        }
    }

    function LoadMonthSummaryCharges(url) {
        //load summary for period
        PlayLoadAnimation('MonthSummary', true);
        $('#MonthSummary_body').load('/PersonalArea/PersonalData/Account/GetMonthSummaryCharges/' + url, () => { PlayLoadAnimation('MonthSummary', false); });
    }

    function LoadMonthDetails(url) {
        //load summary for period
        PlayLoadAnimation('MonthDetails', true);
        $('#MonthDetails_body').load('/PersonalArea/PersonalData/Account/GetMonthDetails/' + url, () => { PlayLoadAnimation('MonthDetails', false); });
    }

    function LoadCallAndTraffic(url) {
        //load summary for period
        PlayLoadAnimation('CallsAndTraffic', true);
        $('#CallsAndTraffic_body').load('/PersonalArea/PersonalData/Account/GetCallsAndTraffic/' + url, () => { PlayLoadAnimation('CallsAndTraffic', false); });
    }

    function GetData() {
        //load data for selected period
        let url = $('#PeriodYear').val() + '/' + $('#PeriodMonth').val();

        LoadSummary(url);
        LoadMonthSummaryCharges(url);
        LoadMonthDetails(url);
        LoadCallAndTraffic(url);
    }

    function Init() {
        let dt = new Date();

        //setup current period on start
        $('#PeriodYear').val(dt.getFullYear() + '');
        $('#PeriodMonth').val((dt.getMonth() + 1) + '');

        PanelControll('AbonentInfo', false);
        PanelControll('AccountStatus', true);
        PanelControll('MonthSummary', true);
        PanelControll('MonthDetails', false);
        PanelControll('CallsAndTraffic', true);
    }

    //event for buttons for open or close panel
    $('button[id="btnControllPanel"]').on('click', function () {
        let name = $(this).data('name');
        PanelControll(name, !PanelIsVisible(name));
    });

    //when changed period by select
    $('#PeriodYear').change(GetData);
    $('#PeriodMonth').change(GetData);

    //changed period by buttons (back)
    $('#btnLeft').on('click', () => {
        let year = $('#PeriodYear').val() * 1;
        let month = $('#PeriodMonth').val() * 1;

        month--;

        if (month === 0) {
            $('#PeriodYear').val(year - 1);
            $('#PeriodMonth').val(12);
        }
        else {
            $('#PeriodMonth').val(month);
        }

        GetData();
    });

    //changed period by buttons (forward)
    $('#btnRight').on('click', () => {
        let year = $('#PeriodYear').val() * 1;
        let month = $('#PeriodMonth').val() * 1;

        month++;

        if (month > 12) {
            $('#PeriodYear').val(year + 1);
            $('#PeriodMonth').val(1);
        }
        else {
            $('#PeriodMonth').val(month);
        }

        GetData();
    });

    Init();
    GetData();
});