﻿$(document).ready(() => {
    var selectedProvider = null;
    let selectedProviderToImport = null;

    function Export(t) {
        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");

        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/Providers/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/Providers/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }

                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function UpdateProviderButtonsUI() {
        /*update ui for buttons when not selected any service some buttons disabled*/
        if (selectedProvider === null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
            $("#btnExport").attr("disabled", true);
            $("#btnCopy").attr("disabled", true);

            $("#btnEditMenu").addClass("disDiv");
            $("#btnDeleteMenu").addClass("disDiv");
            $("#btnExportMenu").addClass("disDiv");
            $("#btnCopyMenu").addClass("disDiv");
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
            $("#btnExport").attr("disabled", false);
            $("#btnCopy").attr("disabled", false);

            $("#btnEditMenu").removeClass("disDiv");
            $("#btnDeleteMenu").removeClass("disDiv");
            $("#btnExportMenu").removeClass("disDiv");
            $("#btnCopyMenu").removeClass("disDiv");
        }

    }

    function AttachEventsProvidersTable() {
        /*table events*/
        $('#tariscope-pr tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedProvider = null;
            }
            else {
                selectedProvider = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-pr tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateProviderButtonsUI();
        });

        UpdateProviderButtonsUI();

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/Providers/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        UpdateProvidersTable($('#tbSearch').val());
                    }
                }
            });
        });
    }

    function UpdateProvidersTable(e) {
        /*update table by search string*/
        $('#prTable').load(encodeURI('/Providers/Search/?Search=' + encodeURIComponent(e)), AttachEventsProvidersTable);
    }

    function ShowUploadModal(show) {
        if (show) {
            $("#uploadFilemodal").modal({
                backdrop: "static",
                keyboard: false,
                show: true
            });
        }
        else {
            $("#uploadFilemodal").modal('hide');

            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();

            setTimeout(function () { $('body').css('padding-right', 0); }, 1000);
        }
    }

    function ShowOperationModal(show) {
        if (show) {
            $("#importDatamodal").modal({
                backdrop: "static",
                keyboard: false,
                show: true
            });
        }
        else {
            $("#importDatamodal").modal('hide');

            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();

            setTimeout(function () { $('body').css('padding-right', 0); }, 1000);
        }
    }

    function SetProgress(e) {
        //set progress for anything
        $('#restoreProgress').css('width', e + '%');
    }

    function StartImport() {
        ShowOperationModal(true);

        $.ajax({
            type: "POST",
            url: '/ProvidesAndRates/Import/',
            timeout: 0,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateProvidersTable($('#tbSearch').val());
                    ShowOperationModal(false);
                }
            }
        });
    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;   //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            UpdateProvidersTable($('#tbSearch').val());
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    /*attach events for deleting service*/
    $('#btnDelete, #btnDeleteMenu').on('click', function () {
        $('#DeleteConfirm').attr('disabled', false);
        $('#DeleteConfirmCancel').attr('disabled', false);
        $('#confirmDelete').modal('show');
    });

    /*deleting provider and update table with providers*/
    $('#DeleteConfirm').on('click', function () {
        $('#confirmDelete').modal('hide');
        ShowSpinner(true);

        $('#DeleteConfirm').attr('disabled', true);
        $('#DeleteConfirmCancel').attr('disabled', true);


        $.ajax({
            type: "POST",
            url: '/Providers/DeleteProvider/' + selectedProvider,
            traditional: true,
            success: function (response) {
                ShowSpinner(false);

                if (response !== null && response.success === true) {
                    UpdateProvidersTable($('#tbSearch').val());
                    DeleteProvider(selectedProvider);
                    $('li[id^=Provider_' + selectedProvider + ']').remove();
                    selectedProvider = null;
                    UpdateProviderButtonsUI();
                }
                else {
                    $('#cannotDeleteProvidermodal').modal('show');
                }
            }
        });
    });

    /*attach event to text box with name*/
    /*show alert message when name is empty*/
    $('#editPRName').on('input', function (e) {
        if ($('#editPRName').val() === "") {
            $('#emptyAdd').attr('hidden', false);
            $('#modalButtonEdit').attr('disabled', true);
        }
        else {
            $('#emptyAdd').attr('hidden', true);
            $('#modalButtonEdit').attr('disabled', false);
        }
    });

    /*attach events for add provider*/
    $('#btnAdd, #btnAddMenu').on('click', function () {
        $('#modalEditTitle').attr('hidden', true);
        $('#modalAddTitle').attr('hidden', false);

        $('#emptyAdd').attr('hidden', true);

        $('#editPRID').val('0');
        $('#editPRName').val('');
        $('#editPRDesc').val('');

        $('#modalButtonEdit').attr('disabled', true);

        $('#editPRModal').modal('show');
    });

    /*attach events for edit provider*/
    $('#btnEdit, #btnEditMenu').on('click', function () {
        $('#modalEditTitle').attr('hidden', false);
        $('#modalAddTitle').attr('hidden', true);

        $('#emptyAdd').attr('hidden', true);

        $('#modalButtonEdit').attr('disabled', false);

        $.ajax({
            type: "POST",
            url: '/Providers/GetProviderInfo/?id=' + selectedProvider,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#lblKdb').html(response.name);

                    $('#editPRID').val(response.id);
                    $('#editPRName').val(response.name);
                    $('#editPRDesc').val(response.desc);

                    $('#editPRModal').modal('show');
                }
            }
        });
    });

    /*Edit or add provider*/
    $('#modalButtonEdit').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/Providers/EditProvider/?id=' + $('#editPRID').val() + '&name=' + encodeURIComponent($('#editPRName').val()) + '&desc=' + encodeURIComponent($('#editPRDesc').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    if (response.isnew === true) {
                        AddNewProvider(response.provider);
                    }
                    else {
                        $('#Provider_' + response.ID + ' > a > span').text(response.name);
                    }

                    selectedProvider = null;
                    UpdateProvidersTable($('#tbSearch').val());
                    $('#editPRModal').modal('hide');
                }
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL, #ExportEXCELMenu').on('click', function () { Export("xlsx"); });
    $('#ExportHTML, #ExportHTMLMenu').on('click', function () { Export("html"); });
    $('#ExportCSV, #ExportCSVMenu').on('click', function () { Export("csv"); });
    $('#ExportPDF, #ExportPDFMenu').on('click', function () { Export("pdf"); });

    //show modal to export provider
    $('#btnExport, #btnExportMenu').on('click', () => { $('#startExportProvidermodal').modal('show'); });

    //start export provider
    $('#confirmExport').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/ProvidesAndRates/Export/' + selectedProvider,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    window.open('/ProvidesAndRates/Download/?file=' + encodeURIComponent(response.Location), '_blank');
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }

                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    });

    //uploading files into server (with progress)
    $("#FileInput").change(function () {
        SetProgress(0);

        var data = document.getElementById("FileInput").files[0];
        var formData = new FormData();
        formData.append(data.name, data);

        if (!data.name.endsWith('.json')) {
            $('#importErrorModal').modal('show');
            return;
        }

        ShowUploadModal(true);

        $.ajax({
            type: 'POST',
            async: true,
            url: '/ProvidesAndRates/Upload/',
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            xhr: function () {
                var xhr = new window.XMLHttpRequest();
                xhr.upload.addEventListener("progress", function (e) {
                    if (e.lengthComputable) { SetProgress(Math.round((e.loaded / e.total) * 100)); }
                }, false);
                return xhr;
            },
            error: function (jqxhr, status, errorThrown) {
                console.log('jqxhr:');
                console.log(jqxhr);
                console.log('status:');
                console.log(status);
                console.log('errorThrown:');
                console.log(errorThrown);

            },
            success: function (response) {
                if (response.success === true) {
                    ShowUploadModal(false);
                    StartImport();
                }
                else {
                    console.log(response.msg);
                }
            }
        });
    });

    //show window to upload file
    $('#btnImport, #btnImportMenu').on('click', () => { $("#FileInput").click(); });

    //show modal to create a copy
    $('#btnCopy, #btnCopyMenu').on('click', () => { $('#startCopyProvidermodal').modal('show'); });

    //start make a copy
    $('#confirmCopy').on('click', () => {
        ShowOperationModal(true);

        $.ajax({
            type: "POST",
            url: '/ProvidesAndRates/Copy/' + selectedProvider,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    AddNewProvider(response.provider);
                    UpdateProvidersTable($('#tbSearch').val());
                    ShowOperationModal(false);
                }
            }
        });
    });

    //show modal to set the rating type
    $('#btnTarification, #btnTarificationMenu').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/CommunicationNodes/GetSettings/',
            traditional: true,
            success: function (response) {
                $('#ratingKind').val(response.settings.Raiting);
                $('#ratingSettingsmodal').modal('show');
            }
        });

    });

    //save rating settings
    $('#setRatingbtn').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/CommunicationNodes/SetSettings/-1/-1/' + $('#ratingKind').val(),
            traditional: true
        });
    });

    //show modal to set the rating type
    $('#btnCache, #btnCacheMenu').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/CommunicationNodes/GetCodesInfo/',
            traditional: true,
            success: function (response) {
                $('#codesCount').text(response.codes);
                $('#cachedCount').text(response.cached);
                $('#clearCacheDanger').hide();
                $('#olderPeriodCache').val(0);
                $('#telephoneCachemodal').modal('show');
            }
        });
    });

    //show info when changed the type of clearing the cache
    $('#olderPeriodCache').change(() => {
        if ($('#olderPeriodCache').val() * 1 === 3) {
            $('#clearCacheDanger').slideDown('fast');
        }
        else {
            $('#clearCacheDanger').slideUp('fast');
        }
    });

    //confirm reset cache
    $('#resetCachebtn').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/CommunicationNodes/ClearCache/' + $('#olderPeriodCache').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    $('#numbersOfClearedTelephonesmodal').modal('show');
                }
            }
        });
    });

    //show modal to import providers online
    $('#btnImportOnline, #btnImportOnlineMenu').on('click', () => {
        ShowSpinner(true);
        $('#onlineProviders').load('/Providers/LoadOnline', () => {
            ShowSpinner(false);

            $('#tariscope-primport tbody').on('click', 'tr', function () {
                if ($(this).hasClass('selected')) {
                    $(this).removeClass('selected');
                    selectedProviderToImport = null;
                }
                else {
                    selectedProviderToImport = $(this).find('td[data-name="URL"]').text();
                    $('#tariscope-primport tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }

                $('#importOnlineBtn').prop('disabled', selectedProviderToImport === null);
            });

            $('#importOnlineBtn').prop('disabled', true);

            $('#loadOnline').modal('show');
        });
    });

    //start import a provider
    $('#importOnlineBtn').on('click', () => {
        ShowOperationModal(true);
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/ProvidesAndRates/StartImport/?URL=' + encodeURIComponent(selectedProviderToImport),
            traditional: true,
            success: function (response) {
                ShowOperationModal(false);
                if (response !== null && response.success === true) {
                    UpdateProvidersTable($('#tbSearch').val());
                }
                else {
                    $('#errorModalMessage').text(response.msg);
                    $('#errorModal').modal('show');
                }
            }
        });
    });

    //edit internal exchnage
    $('#btnInternalExchange, #btnInternalExchangeMenu').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/SystemVariables/GetInternalExchnage',
            traditional: true,
            success: function (response) {
                if (response !== null) {
                    $('#internalUpdate').val(response.Value ? response.Value * 1 : 0);
                    $('#internalUpdateModal').modal('show');
                }
            }
        });
    });

    //save internal exchnage
    $('#setInternalExchnagebtn').on('click', () => {
        $('#internalUpdateModal').modal('hide');

        $.ajax({
            type: "POST",
            async: true,
            url: '/SystemVariables/SetInternalExchnage/?value=' + encodeURIComponent($('#internalUpdate').val()),
            traditional: true
        });
    });

    //edit use origin
    $('#btnUseOrigin, #btnUseOriginMenu').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/SystemVariables/GetUpdateOriginNumber',
            traditional: true,
            success: function (response) {
                if (response !== null) {
                    $('#useOgirinNumber').val(response.Value ? response.Value * 1 : 0);
                    $('#useOriginNumberToLocalModal').modal('show');
                }
            }
        });
    });

    //save use origin
    $('#setUseOriginbtn').on('click', () => {
        $('#useOriginNumberToLocalModal').modal('hide');

        $.ajax({
            type: "POST",
            async: true,
            url: '/SystemVariables/SetUpdateOriginNumber/?value=' + encodeURIComponent($('#useOgirinNumber').val()),
            traditional: true
        });
    });

    UpdateProvidersTable($('#tbSearch').val());
});