﻿$(document).ready(() => {
    function SetHeight() {
        let zoomer = document.getElementById("ReportZoomer");

        if (zoomer !== null) {
            let e = document.getElementById('reportIframe');
            e.style.height = e.contentWindow.document.body.scrollHeight + 200 + 'px';
            return;
        }

        windowHeight = window.innerHeight -
            $('.main-header').outerHeight() -
            $('.content-header').outerHeight() -
            $('.box-header').outerHeight() -
            $('.main-footer').outerHeight();

        if (windowHeight < 400)
            windowHeight = 400;

        $('#reportIframe').css('height', windowHeight - 85 + 'px');
    }

    //resize window
    $(window).resize(() => {
        SetHeight();
    });

    $('#reportIframe').on('load', () => {
        setInterval(SetHeight, 750);
    });

    //scaling report
    $('a[id="zoom"]').on('click', function () {
        let scale = 1 * ($(this).data('value') * 1);
        $('#reportIframe').css('transform', 'scale(' + scale + ',' + scale + ')');
    });

    //go to index
    $('#btnNew').on('click', () => {
        window.open('/Reporting', '_parent');
    });

    //download saved report
    $('#btnDownlopad').on('click', () => {
        window.open($('#reportFileName').val(), '_blank');
    });

    //open log
    $('#btnOpenLog').on('click', () => {
        window.open('/Logger/Reporter', '_parent');
    });
});