﻿$(document).ready(() => {
    function MakeDisable(num) {
        //disable next steps if previous ones are proccesed again
        for (var i = num; i < 8; i++) {
            var elem = $('a[aria-controls="step' + (i + 2) + '"]');
            elem.parent().addClass('disabled');
        }
    }

    function nextTab(elem) {
        //go to next wizard page
        $(elem).next().find('a[data-toggle="tab"]').click();
    }

    function prevTab(elem) {
        //go to prev wizard page
        $(elem).prev().find('a[data-toggle="tab"]').click();
    }

    function ClearTableAndSelect() {
        //remove prev added data to table and selectes
        $("#tableWithData tr").remove();
        $("#tableWithData tbody").append('<tr></tr>');

        $('#serviceID option').remove();
        $('#price option').remove();
        $('#fromDate option').remove();
    }

    function InitTable(data) {
        //create head row
        var trHead = document.createElement('tr');
        for (var i = 0; i < data[0].length; i++) {
            //create cell
            var th = document.createElement('th');
            th.innerText = data[0][i];
            //add cell to row
            trHead.appendChild(th);
        }
        $('#tableWithData tr:last').after(trHead);

        for (var i = 1; i < data.length; i++) {
            //create row
            var tr = document.createElement('tr');
            for (var j = 0; j < data[i].length; j++) {
                //create cell
                var td = document.createElement('td');
                td.innerText = data[i][j];
                //add cell to row
                tr.appendChild(td);
            }
            //add row to table
            $('#tableWithData tr:last').after(tr);
        }

    }

    function AddFields(data) {
        //add empty field
        $('#serviceID').append('<option value="' + -1 + '"></option>');
        $('#price').append('<option value="' + -1 + '"></option>');
        $('#fromDate').append('<option value="' + -1 + '"></option>');

        //add source fields
        for (var i = 0; i < data.length; i++) {
            $('#serviceID').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#price').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#fromDate').append('<option value="' + i + '">' + data[i] + '</option>');
        }
    }

    function SelectedMatch(data) {
        //select matched fields
        $('#serviceID').val(data[1]);
        $('#price').val(data[2]);
        $('#fromDate').val(data[3]);
    }

    //Initialize tooltips
    $('.nav-tabs > li a[title]').tooltip();

    //Wizard
    $('a[data-toggle="tab"]').on('show.bs.tab', function (e) {

        var $target = $(e.target);

        if ($target.parent().hasClass('disabled')) {
            return false;
        }
    });
    $(".prev-step").click(function (e) {

        var $active = $('.wizard .nav-tabs li.active');
        prevTab($active);
    });

    //file input
    var inputs = document.querySelectorAll('.file-input');
    for (var i = 0, len = inputs.length; i < len; i++) {
        customInput(inputs[i]);
    }
    function customInput(el) {
        const fileInput = el.querySelector('[type="file"]');
        const label = el.querySelector('[data-js-label]');

        fileInput.onchange = fileInput.onmouseout = function () {
            if (!fileInput.value) return;

            var value = fileInput.value.replace(/^.*[\\\/]/, '');
            el.className += ' -chosen';
            label.innerText = value;
        };
    }

    //welcome
    $('#WelcomeButton').on('click', function () {
        var $active = $('.wizard .nav-tabs li.active');
        $active.next().removeClass('disabled');
        nextTab($active);

        MakeDisable(1);
    });

    //change file format
    $('#SelectFileFormat').change(function () {
        $('#FileInput').attr('accept', '.' + $('#SelectFileFormat option:selected').val());
    });

    //Download, process the seleted file and get table names
    $('#FileProcessButton').on('click', function () {
        var data = new FormData();
        var file = $("#FileInput")[0].files[0];

        if (file != null) {
            ShowSpinner(true);
            $('#emptyFile').slideUp('fast');
            data.append($('#SelectFileFormat option:selected').val(), file);

            $.ajax({
                type: "POST",
                async: true,
                url: '/CustomerServices/LoadFile/?type=' + $('#SelectFileFormat option:selected').val(),
                data: data,
                datatype: 'json',
                contentType: false,
                processData: false,
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        //clear select with tables and load new
                        $('#SelectWitTables').empty();
                        response.tables.forEach(function (e) {
                            $('#SelectWitTables').append('<option value="' + e + '">' + e + '</option>');
                        });

                        var $active = $('.wizard .nav-tabs li.active');
                        $active.next().removeClass('disabled');
                        nextTab($active);

                        MakeDisable(2);
                    }
                    else {
                        $('#FileProcessButton').attr('disabled', true);
                    }
                    ShowSpinner(false);
                }
            });
        }
        else {
            $('#emptyFile').slideDown('fast');
        }
    });

    //get predata and build table
    $('#FilePreloadButton').on('click', function () {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            async: true,
            url: '/CustomerServices/GetPreData/?table=' + encodeURIComponent($('#SelectWitTables option:selected').val()),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {

                    let tb = JSON.parse(response.tb);

                    //build table with pre data
                    ClearTableAndSelect();
                    InitTable(tb);

                    //add fields to selectes
                    AddFields(tb[0]);

                    //selected matched
                    SelectedMatch(response.sl);

                    var $active = $('.wizard .nav-tabs li.active');
                    $active.next().removeClass('disabled');
                    nextTab($active);

                    MakeDisable(3);
                }
                else {
                    $('#FilePreloadButton').attr('disabled', true);
                }
                ShowSpinner(false);
            }
        });
    });

    //send selected matches
    $('#FileMatchButton').on('click', function () {
        var matches = $('#serviceID').val() + ',' +
            $('#price').val() + ',' +
            $('#fromDate').val();

        $.ajax({
            type: "POST",
            async: true,
            url: '/CustomerServices/SetMatch/?Matches=' + matches,
            traditional: true,
            success: function (response) {
                $('#dateForExample').text(response.date);
                var $active = $('.wizard .nav-tabs li.active');
                $active.next().removeClass('disabled');
                nextTab($active);

                MakeDisable(4);
            }
        });
    });

    //go to check the broken DNs
    $('#StartCheck').on('click', () => {
      $.ajax({
            type: "POST",
            async: true,
            url: '/CustomerServices/SetDateFormat/?DateFormat=' + encodeURIComponent($('#dateFormat').val()),
            traditional: true,
            success: function (response) {
                window.open('/CustomerServices/SaveImport', '_parent');
            }
        });

    });

    //cancel import
    $('#CancelImport').on('click', () => { window.open('/CustomerServices', '_parent'); })
});