﻿$(document).ready(() => {
    let selectedContatc = null;

    function UpdateContactButtonUI() {
        if (selectedContatc === null) {
            $('#btnEditContact').prop('disabled', true);
            $('#btnDeleteContact').prop('disabled', true);
        }
        else {
            $('#btnEditContact').prop('disabled', false);
            $('#btnDeleteContact').prop('disabled', false);
        }
    }

    function AttachEventsToContacts() {
        selectedContatc = null;

        $('#tariscope-abonent-contacts tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedContatc = null;
            }
            else {
                selectedContatc = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-abonent-contacts tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateContactButtonUI();
        });

        UpdateContactButtonUI();
    }

    function LoadContacts() {
        $('#contactsTable').load('/Subscribers/LoadContacts/' + $('#AbonentID').val(), AttachEventsToContacts);
    }

    //back to abonent
    $('#btnBackToAbonent').on('click', () => {
        $('#additionalSection').slideUp('fast');
        $('#editSection').slideDown('fast');

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetContacts/' + $('#AbonentID').val(),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#AbonentContact').val(response.c);
                }
            }
        });
    });

    //show modal for delete abonent contact
    $('#btnDeleteContact').on('click', () => { $('#deleteAbonentContactmodal').modal('show'); });

    //confirm delete ccontact
    $('#deleteAbonentContactConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/DeleteContact/' + selectedContatc,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#deleteAbonentContactmodal').modal('hide');
                    LoadContacts();
                }
            }
        });
    });

    //show modal for add abonent contact
    $('#btnAddContact').on('click', () => {

        $('#abContactID').val(0);
        $('#abContact').val('');
        $('#abContactType').val('');
        $('#abContactDescription').val('');

        $('#abcontactRequired').hide();
        $('#abcontactTypeRequired').hide();
        $('#editAbonentContacttitle').text($('#newAbcontact').val());
        $('#saveAbcontact').prop('disabled', true);

        $('#editAbonentContactmodal').modal('show');
    });

    //show error when contact field is emprt
    $('#abContact').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#abcontactRequired').slideDown('fast');
            $('#saveAbcontact').prop('disabled', true);
        }
        else {
            $('#abcontactRequired').slideUp('fast');
            $('#saveAbcontact').prop('disabled', (!$('#abContactType').val() || !$('#abContactType').val().trim()));
        }
    });

    //show error when contact type field is emprt
    $('#abContactType').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#abcontactTypeRequired').slideDown('fast');
            $('#saveAbcontact').prop('disabled', true);
        }
        else {
            $('#abcontactTypeRequired').slideUp('fast');
            $('#saveAbcontact').prop('disabled', (!$('#abContact').val() || !$('#abContact').val().trim()));
        }
    });

    //save abonent contact
    $('#saveAbcontact').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/SaveContact/' + $('#abContactID').val()
                + '/' + $('#AbonentID').val()
                + '/?Contact=' + encodeURIComponent($('#abContact').val())
                + '&Type=' + encodeURIComponent($('#abContactType').val())
                + '&Description=' + encodeURIComponent($('#abContactDescription').val()),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#editAbonentContactmodal').modal('hide');
                    LoadContacts();
                }
            }
        });
    });

    //show modal for edit contact
    $('#btnEditContact').on('click', () => {
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/Subscribers/GetContact/' + selectedContatc,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#abContactID').val(response.con.ID);
                    $('#abContact').val(response.con.Value);
                    $('#abContactType').val(response.con.Type);
                    $('#abContactDescription').val(response.con.Description);

                    $('#abcontactRequired').hide();
                    $('#abcontactTypeRequired').hide();
                    $('#editAbonentContacttitle').text($('#editAbcontact').val());
                    $('#saveAbcontact').prop('disabled', false);

                    $('#editAbonentContactmodal').modal('show');
                }
            }
        });
    });

    LoadContacts();
});